/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.domain;

import org.apache.groovy.contracts.domain.AssertionMap;
import org.apache.groovy.contracts.domain.ClassInvariant;
import org.apache.groovy.contracts.domain.Postcondition;
import org.apache.groovy.contracts.domain.Precondition;
import org.apache.groovy.contracts.util.Validate;
import org.codehaus.groovy.ast.ClassNode;

public class Contract {
    private final ClassNode classNode;
    private ClassInvariant classInvariant = ClassInvariant.DEFAULT;
    private final AssertionMap<Precondition> preconditions;
    private final AssertionMap<Postcondition> postconditions;

    public Contract(ClassNode classNode) {
        Validate.notNull(classNode);
        this.classNode = classNode;
        this.preconditions = new AssertionMap();
        this.postconditions = new AssertionMap();
    }

    public ClassNode classNode() {
        return this.classNode;
    }

    public void setClassInvariant(ClassInvariant classInvariant) {
        Validate.notNull(classInvariant);
        this.classInvariant = classInvariant;
    }

    public AssertionMap<Precondition> preconditions() {
        return this.preconditions;
    }

    public AssertionMap<Postcondition> postconditions() {
        return this.postconditions;
    }

    public boolean hasDefaultClassInvariant() {
        return this.classInvariant == ClassInvariant.DEFAULT;
    }

    public ClassInvariant classInvariant() {
        return this.classInvariant;
    }
}

