/***********************************************************
constants
***********************************************************/

// reference to the interface defined in nsIMediaCollectorJS.idl
const nsIMediaCollectorJS = Components.interfaces.nsIMediaCollectorJS;

// reference to the required base interface that all components must support
const nsISupports = Components.interfaces.nsISupports;

// UUID uniquely identifying our component
// You can get from: http://kruithof.xs4all.nl/uuid/uuidgen here
const CLASS_ID = Components.ID("{31e54148-a4e3-11dc-8314-0800200c9a66}");

// description
const CLASS_NAME = "MediaCollector Javascript XPCOM Component";

// textual unique identifier
const CONTRACT_ID = "@mediacollector.component.com/mediacollector;1";

const d = "TVMOZJS----> ";//debug prefix for console 	
const end = "\r\n";//new line

var saveGif = false;
var savePng = false;
var saveJpg = false;

var saveHtml = false;
var saveText = false;

var mainError = null;

/***********************************************************
class definition
***********************************************************/

//class constructor
function MediaCollectorJS() {
};

// class definition
MediaCollectorJS.prototype = {

  // define the function we want to expose in our interface
  hello: function() 
  {
      return "Hello MediaCollectorJS!";
  },
   
  setUserPrefs: function(pJpg,pGif,pPng,pHtml,pText)
  {
  	saveJpg = pJpg ? true : false;
  	savePng = pPng ? true : false;
  	saveGif = pGif ? true : false;
  	saveHtml = pHtml ? true : false;
  	saveText = pText ? true : false;
  },
  
  saveLinks: function(doc,folderPath)
  {
  	try
  	{
  		dump(d + folderPath.persistentDescriptor + end);	
  		  	
  		var reGif = /((\w+)(.gif))$/igm;
	  	var rePng = /((\w+)(.png))$/igm;
	  	var reJpg = /((\w+)(.jpg))$/igm;
	  	var reHtml = /((\w+)(.[Hh]tm[l]?))$/igm;
	  	var reText = /((\w+)(.[Tt]xt))$/igm;  	
  		  	
	  	var links = doc.getElementsByTagName("A"); //get all a tags
	  	dump(d + "Found A tags: " + links.length + end);
	  	var images = doc.getElementsByTagName("IMG");
	  	dump(d + "Found IMG tags: " + images.length + end);
	  		  	  	
	  	//loop through all A tags
	  	for(var i = 0;i < links.length;i++)
	  	{
	  		var uri = links[i].href; //get full uri
	  		dump(d + uri + end);
	  		if(uri.length > 0)
	  		{
	  			var uriPrefix = uri.substring(0,5); //get file prefix to see if we can save it - may not be needed
	  			
	  			if(saveHtml)
	  			{
		  			//save html files
		  			reHtml.lastIndex = 0;
		  			var aData = reHtml.exec(uri); //match pattern againt uri
		  			if(aData)
		  			{
		  				var file = aData[1]; 
		  				var fileName = aData[2];
		  				var fileExtension = aData[3];
		  				dump(d + file + " - " + fileName + " - " + fileExtension + end);	  				
		  				
		  				var saved = saveURI(uri,convertURITitle(uri),fileExtension,folderPath);		
		  				if(saved)
		  				{
		  					dump(d + "\tSaved as HTML" + end);
		  				}
		  				else
		  				{
		  					dump(d + "\tCan't Be Saved as HTML" + end);
		  				}
		  			}
	  			}
	  			
	  			if(saveText)
	  			{
		  			//save text files
		  			reText.lastIndex = 0;
		  			var aData = reText.exec(uri); //match pattern againt uri
		  			if(aData)
		  			{
		  				/*
		  				if url is http://images.google.com/intl/en_ALL/images/images_hp.gif
		  				file = about.html
		  				fileName = about
		  				fileExtention = .html
		  				*/
		  				
		  				var file = aData[1];
		  				var fileName = aData[2];
		  				var fileExtension = aData[3];
		  				dump(d + file + " - " + fileName + " - " + fileExtension + end);
		  				var saved = saveURI(uri,convertURITitle(fileName),fileExtension,folderPath);
		  				if(saved)
		  					dump(d + "\tSaved as TXT" + end);
		  			}
		  			else
		  			{
		  				dump(d + "\tCan't Be Saved as TXT" + end);
		  			}
	  			}
	  		}
	  	}
	  	
	  	//loop through IMG tags
	  	
	  	for(var i = 0;i < images.length;i++)
	  	{
	  		var uri = images[i].src;
	  		dump(d + uri + end);
	  		if(uri.length>0)
	  		{
	  			var uriPrefix = uri.substring(0,5); //get file prefix to see if we can save it - may not be needed 
	  			
	  			if(saveGif)
	  			{
		  			reGif.lastIndex = 0;
		  			var aData = reGif.exec(uri); //match pattern againt uri
		  			if(aData)
		  			{
		  				/*
		  				if url is http://images.google.com/intl/en_ALL/images/images_hp.gif
		  				file = about.html
		  				fileName = about
		  				fileExtention = .html
		  				*/
		  				
		  				var file = aData[1];
		  				var fileName = aData[2];
		  				var fileExtension = aData[3];
		  				dump(d + file + " - " + fileName + " - " + fileExtension + end);
		  				var saved = saveURI(uri,convertURITitle(fileName),fileExtension,folderPath);
		  				if(saved)
		  					dump(d + "\tSaved as GIF" + end);
		  			}
		  			else
		  			{
		  				dump(d + "\tCan't Be Saved as GIF" + end);
		  			}
	  		  	}	
	  		
	  			if(saveJpg)
	  			{
			  		reJpg.lastIndex = 0;
			  		aData = reJpg.exec(uri); //match pattern againt uri
			  		if(aData)
			  		{
			  			/*
		  				if url is http://images.google.com/intl/en_ALL/images/images_hp.gif
		  				file = about.html
		  				fileName = about
		  				fileExtention = .html
		  				*/
		  				
			  			var file = aData[1];
			  			var fileName = aData[2];
			  			var fileExtension = aData[3];	  			
			  			dump(d + file + " - " + fileName + " - " + fileExtension + end);
			  			var saved = saveURI(uri,convertURITitle(fileName),fileExtension,folderPath);
			  			if(saved)
			  				dump(d + "\tSaved as JPG" + end);
			  		}
			  		else
			  		{
			  			dump(d + "\tCan't Be Saved as JPG" + end);
			  		}
		  		}
		  		
		  		if(savePng)
		  		{
			  		rePng.lastIndex = 0;
			  		aData = rePng.exec(uri); //match pattern againt uri			
			  		if(aData)
			  		{
			  			/*
		  				if url is http://images.google.com/intl/en_ALL/images/images_hp.gif
		  				file = about.html
		  				fileName = about
		  				fileExtention = .html
		  				*/
			  			
			  			var file = aData[1];
			  			var fileName = aData[2];
			  			var fileExtension = aData[3];
			  			dump(d + file + " - " + fileName + " - " + fileExtension + end);
			  			var saved = saveURI(uri,convertURITitle(fileName),fileExtension,folderPath);
			  			if(saved)
			  				dump(d + "\tSaved as PNG" + end);
			  		}
			  		else
			  		{
			  			dump(d + "\tCan't Be Saved as PNG" + end);
			  		}
	  			}
	  		}
	  	
	  	
	  			
	  	}//end for
	  	
	  	
	  	
	  	
	  	
  	}
  	catch(MainError)
  	{
  		dump(d + MainError + end);
  		return false;	
  	}
  	
  	
  	
  	return true;
  },
	
  QueryInterface: function(aIID)
  {
    if (!aIID.equals(nsIMediaCollectorJS) &&    
        !aIID.equals(nsISupports))
      throw Components.results.NS_ERROR_NO_INTERFACE;
    return this;
  }
};

/***********************************************************
class factory

This object is a member of the global-scope Components.classes.
It is keyed off of the contract ID. Eg:

myHelloWorld = Components.classes["@dietrich.ganx4.com/helloworld;1"].
                          createInstance(Components.interfaces.nsIHelloWorld);

***********************************************************/
var MediaCollectorJSFactory = {
  createInstance: function (aOuter, aIID)
  {
    if (aOuter != null)
      throw Components.results.NS_ERROR_NO_AGGREGATION;
    return (new MediaCollectorJS()).QueryInterface(aIID);
  }
};

/***********************************************************
module definition (xpcom registration)
***********************************************************/
var MediaCollectorJSModule = {
  registerSelf: function(aCompMgr, aFileSpec, aLocation, aType)
  {
    aCompMgr = aCompMgr.
        QueryInterface(Components.interfaces.nsIComponentRegistrar);
    aCompMgr.registerFactoryLocation(CLASS_ID, CLASS_NAME, 
        CONTRACT_ID, aFileSpec, aLocation, aType);
  },

  unregisterSelf: function(aCompMgr, aLocation, aType)
  {
    aCompMgr = aCompMgr.
        QueryInterface(Components.interfaces.nsIComponentRegistrar);
    aCompMgr.unregisterFactoryLocation(CLASS_ID, aLocation);        
  },
  
  getClassObject: function(aCompMgr, aCID, aIID)
  {
    if (!aIID.equals(Components.interfaces.nsIFactory))
      throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

    if (aCID.equals(CLASS_ID))
      return MediaCollectorJSFactory;

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  canUnload: function(aCompMgr) { return true; }
};

/***********************************************************
module initialization

When the application registers the component, this function
is called.
***********************************************************/
function NSGetModule(aCompMgr, aFileSpec) { return MediaCollectorJSModule; }

function getBundle(aURI)
{
  if (!aURI)
    return null;

  debug(aURI);
  var bundle = null;
  try
  {
    var strBundleService = Components.
      classes["@mozilla.org/intl/stringbundle;1"].
      getService(Components.interfaces.nsIStringBundleService);
    bundle = strBundleService.createBundle(aURI);
  }
  catch (ex)
  {
    bundle = null;
    debug("Exception getting bundle " + aURI + ": " + ex);
  }

  return bundle;
}


function convertURITitle(title)
{
	title = title.replace(/[\s\/\\:\.]/igm,"_");
	return title;
}	

function saveURI(url,file,extension,saveLocation)
{
	
	
	// get the path to the user's home (profile) directory: [source: http://www.captain.at/programming/xul/]
	const DIR_SERVICE = new Components.Constructor("@mozilla.org/file/directory_service;1","nsIProperties");
	try 
	{ 
		var path=(new DIR_SERVICE()).get("ProfD", Components.interfaces.nsIFile).path; 
		dump("home directory is: " + path);
	} 
	catch(e) 
	{
		dump("could not determine home directory: " + e);
	}
	
	// determine the file-separator
	if(path.search(/\\/) != -1) 
	{
		path = "\\";
	}
	else 
	{
		path = "/";
	}

	
	
	
	//var url = "http://www.mozilla.org";
	//var fileName = "c:\\\g\\test1.gif";
	fileName = saveLocation.persistentDescriptor+path+file+extension;
	dump(d + "Saving uri: " + url + end + " at " + fileName + end);
	var astatus = new Array();
	var i = 0;
	var persiststate = "";
	try 
	{
		var uri = Components.classes["@mozilla.org/network/standard-url;1"].createInstance(Components.interfaces.nsIURI);
		uri.spec = url;
		
		var localFile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile)
		//localFile.initWithPath(fileName);
		localFile.initWithFile(saveLocation);
		localFile.appendRelativePath(file+extension);
		var persist = Components.classes["@mozilla.org/embedding/browser/nsWebBrowserPersist;1"].createInstance(Components.interfaces.nsIWebBrowserPersist);
		persist.saveURI(uri,null,null,null,null, localFile);
		//persist.cancelSave();
	}
	catch(e)
	{
		dump("Exception: " + "Saving uri: " + url + "\r\n" + " at " + file + "\r\n" + e + end);
		return false;
	}
	return true;
}

