using System;
using System.Collections.Generic;
using System.Text;
using CoreSync;
using System.Xml;
using System.Xml.Serialization;

namespace SmartSync
{
    class XMLDataExchange
    {
        public static String ContactsToXML(Contacts oContacts)
        {
            StringBuilder cts = new StringBuilder();
            cts.Append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\r\n");
            cts.Append("<contacts>");
            for (int i = 0; i < oContacts.getCount(); i++)
            {
                String ct = ContactToXML(oContacts.get(i));
                ct=ct.Substring(ct.IndexOf("?>")+2);
                cts.Append(ct);
            }
            cts.Append("\r\n</contacts>");
            return cts.ToString();
        }
        public static Contacts ContactsFromXML(String xmlData)
        {
            Contacts retval = new Contacts();
            System.IO.StringReader input = new System.IO.StringReader(xmlData);
            XmlTextReader rdr = new XmlTextReader(input);
            while (rdr.Read())
            {
                if (rdr.NodeType == XmlNodeType.Element)
                {
                    if (rdr.Name == "contacts")
                    {
                        XmlReader cts = rdr.ReadSubtree();
                        while (cts.Read())
                        {
                            if (cts.NodeType == XmlNodeType.Element)
                            {
                                if (cts.Name=="contact")
                                {
                                    String node = cts.ReadOuterXml();
                                    Contact ct = ContactFromXML(node);
                                    retval.add(ct);
                                }
                            }
                        }
                    }
                }
            }
            return retval;
        }

        public static Contact ContactFromXML(String xmlData)
        {
            System.IO.StringReader input = new System.IO.StringReader(xmlData);
            //XmlTextReader rdr = new XmlTextReader(input);
            XmlSerializer ser = new XmlSerializer((new Contact()).GetType());
            Contact retval=(Contact)ser.Deserialize(input);
            return retval;
        }

        public static String ContactToXML(Contact oContact)
        {
            StringBuilder sb = new StringBuilder();
            System.IO.StringWriter output = new System.IO.StringWriter(sb);
            XmlSerializer ser = new XmlSerializer((new Contact()).GetType());
            ser.Serialize(output, oContact);
            return sb.ToString();
        }
    }
}
