/*
 * Decompiled with CFR 0.152.
 */
package org.mozdev.multexi.forms.multexi.admin;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.mozdev.multexi.conf.Configuration;

public class ConfigurationForm
extends ActionForm {
    private static final long serialVersionUID = 1L;
    private String serverAddress;
    private Integer serverPort;
    private String mccUpdateUrl;
    private Integer mccMaxUpdateTime;

    protected boolean isUrlValid(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if ("".equals(this.serverAddress)) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("form.multexi.configure.errors.serverAddress"));
        }
        if (this.serverPort <= 0) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("form.multexi.configure.errors.serverPort"));
        }
        if ("".equals(this.mccUpdateUrl) || !this.isUrlValid(this.mccUpdateUrl)) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("form.multexi.configure.errors.mccUpdateUrl"));
        }
        if (this.mccMaxUpdateTime <= 0) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("form.multexi.configure.errors.mccMaxUpdateTime"));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.mccMaxUpdateTime = new Integer(-1);
        this.mccUpdateUrl = "";
        this.serverAddress = "";
        this.serverPort = new Integer(-1);
        try {
            URL url = new URL(Configuration.get((String)"multexi.extension.server.edfUrl"));
            this.serverAddress = url.getHost();
            this.serverPort = new Integer(url.getPort());
            int time = new Integer(Configuration.get((String)"multexi.mcc.maxUpdateTime"));
            this.mccMaxUpdateTime = new Integer(time / 60 / 60 / 60);
            this.mccUpdateUrl = Configuration.get((String)"multexi.defaultUpdateUrl");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Integer getMccMaxUpdateTime() {
        return this.mccMaxUpdateTime;
    }

    public void setMccMaxUpdateTime(Integer mccMaxUpdateTime) {
        this.mccMaxUpdateTime = mccMaxUpdateTime;
    }

    public String getMccUpdateUrl() {
        return this.mccUpdateUrl;
    }

    public void setMccUpdateUrl(String mccUpdateUrl) {
        this.mccUpdateUrl = mccUpdateUrl;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }
}

