/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's RNG Schema object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Schema.js,v 1.2 2006/08/23 16:55:31 jameso Exp $
 */

mozile.require("mozile.rng");

var name = "mozile.rng.Schema";
var RNGFile = "../rng/address.rng";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testBasics", "testLoad", "testCreateRNGNode", "testIndexNode", "testGetNodes", "testParseElement", "testParse", "testValidate"];
}

/*
 *
 */
function testBasics() {
	var component = new mozile.rng.Schema();
	assertNull("There should be no root.", component._root);
	assertEquals("String is '[object mozile.rng.Schema]'", "[object mozile.rng.Schema]", component.toString());
	assertEquals("Type is 'schema'", "schema", component.getType());
}

/**
 * 
 */
function testLoad() {
	var component = new mozile.rng.Schema();
	var doc = component.load(RNGFile);
	var element = doc.documentElement;
	assertEquals("The nodeName should be 'element'", "element", element.nodeName);
	assertEquals("The name should be 'addressBook'", "addressBook", element.getAttribute("name"));
}

/**
 * 
 */
function testCreateRNGNode() {
	var component = new mozile.rng.Schema();
	var doc = component.load(RNGFile);
	var element = doc.documentElement;
	var RNGNode = component._createRNGNode(element);
	//assertEquals("The string should show the RNGNode type", "[object RNGElement]", RNGNode.toString());
	var RNGNode = component._createRNGNode(doc.createTextNode(' '));
	assertNull("There should be no node", RNGNode);
}

/**
 * 
 */
function testIndexNode() {
	// Currently trivial
}

/**
 * 
 */
function testGetNodes() {
	var component = new mozile.rng.Schema();
	var doc = component.parse(RNGFile);
	
	assertNotNull("There should be an array of elements", component.getNodes("element"));
	var cards = component.getNodes("element", "card");
	assertEquals("There should be one card element entry", 1, cards.length);
	assertEquals("The 'card' entry should match the 'card' RNG element", component._root.getChildNode(0).getChildNode(0), cards[0]);
}

/**
 * 
 */
function testParseElement() {
	var component = new mozile.rng.Schema();
	var doc = component.load(RNGFile);
	var element = doc.documentElement;
	var validation = new mozile.rng.Validation()
	var RNGNode = component.parseElement(element, validation);
	//assertEquals("The string should show the RNGNode type", "[object RNGElement]", RNGNode.toString());
	assertEquals("The RNGNode should have one child", 1, RNGNode.getChildNodes().length);
}

/**
 * 
 */
function testParse() {
	var component = new mozile.rng.Schema();
	var validation = component.parse(RNGFile);
	//alert(validation);
	assertTrue("Schema should be valid", validation.isValid);
	assertNotNull("Parse should create the root.", component._root);
	var RNGNode = component._root;
	assertNotNull("There should now be a root.", RNGNode);
	assertEquals("The RNGNode should have one child", 1, RNGNode.getChildNodes().length);
}

/**
 * 
 */
function testValidate() {
	// Currently simple
}

