/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's RNG Grammar object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Grammar.js,v 1.2 2006/08/23 16:55:31 jameso Exp $
 */

mozile.require("mozile.rng");
mozile.require("mozile.xml");
mozile.require("mozile.test.rng.util");

var name = "mozile.rng.Grammar";
var includePath = "../tests/rng/include.rng";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testRNGNode", "testParentGrammar", "testDefinition", "testValidate"];
}

/**
 * A battery of test cases.
 */
var cases = [
	{
		"rng": '<grammar xmlns="http://relaxng.org/ns/structure/1.0"> <include href="'+ includePath +'"/> <start> <ref name="D"/> </start> </grammar>', 
		"valid": [
			'<a/>',
			'<a></a>',
			'<a> </a>',
		],
		"invalid": [
			'<b/>',
			'<b></b>',
			'<b> </b>',
			'<a><b/></a>',
			'<a> <b/></a>',
		]
	},
];


function getNode() {
	var schema = new mozile.rng.Schema();
	var val = schema.parse('<grammar xmlns="http://relaxng.org/ns/structure/1.0"><start><element name="a"><empty/></element></start></grammar>');
	//alert(val.report());
	return schema._root;
}
	
/**
 * Test node, naming, and namespace.
 */
function testRNGNode() {
	var RNGNode = getNode();
	//mozile.test.rng.checkRNGNode(RNGNode);

	assertEquals("getStart should return a 'start' element", "start", RNGNode.getStart().getType());
	
	assertTrue("mustHave('element') should be true", RNGNode.mustHave('element'));
	assertFalse("mustHave('attribute') is false", RNGNode.mustHave('attribute'));
}

/**
 *
 */
function testParentGrammar() {
	// Currently trivial
}

/**
 *
 */
function testAppendChild() {
	// TODO: This method should be improved and tested.
}

/**
 * 
 */
function testDefinition() {
	// Older versions of Safari crash during this test.
	if(mozile.browser.isSafari && mozile.browser.safariVersion <= 418) return;
	
	var rngNode = new mozile.rng.Schema('<grammar xmlns="http://relaxng.org/ns/structure/1.0"> <start> <ref name="D"/> </start> </grammar>');
	rngNode = rngNode._root;
	var rngDefine = new mozile.rng.Define(mozile.xml.parseElement('<define name="D"> <element name="a"><empty/></element> </define>'));
	
	assertNull("Definition 'D' should not yet be defined", rngNode.getDefinition("D") );
	assertEquals("Definition 'D' should be returned", rngDefine, rngNode.addDefinition(rngDefine) );
	assertEquals("Definition 'D' should be defined", rngDefine, rngNode.getDefinition("D") );
}

/**
 * Test validation.
 */
function testValidate() {
	mozile.test.rng.checkCases(name);
}

