/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's RNG Element object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: Element.js,v 1.2 2006/08/23 16:55:31 jameso Exp $
 */

mozile.require("mozile.rng");
mozile.require("mozile.xml");
mozile.require("mozile.test.rng.util");

var name = "mozile.rng.Element";

/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testRNGNode", "testValidate"];
}

/**
 * Create a sample node.
 */
function getNode() {
	return new mozile.rng.Element(mozile.xml.parseElement('<element name="card"/>'), mozile.test.rng.schema);
}
	
/**
 * Test node, naming, and namespace.
 */
function testRNGNode() {
	var RNGNode = getNode();
	mozile.test.rng.checkRNGNode(RNGNode);
	assertEquals("Name should be 'card'", "card", RNGNode.getName());
	assertNull("The namespace should be null", RNGNode.getNamespace());

	// Check namespace
	var element = mozile.xml.parseElement('<element name="   a    " ns="http://somenamespace.com"><empty/></element>');
	RNGNode = new mozile.rng.Element(element);
	assertEquals("The name should be 'a' without whitespace", "a", RNGNode.getName());
	assertEquals("The name should the localName", RNGNode.getName(), RNGNode.getLocalName());
	assertEquals("The namespace should be http://somenamespace.com", "http://somenamespace.com", RNGNode.getNamespace());

	// Check inherited namespace
	element = mozile.xml.parseElement('<element name="a" xmlns="http://relaxng.org/ns/structure/1.0" ns="http://somenamespace.com"><element name="b  "><empty/></element></element>');
	var schema = new mozile.rng.Schema(element);
	var RNGNode = schema._root.getChildNodes()[0];
	assertEquals("The name should be 'b' without whitespace", "b", RNGNode.getName());
	assertEquals("The name should the localName", RNGNode.getName(), RNGNode.getLocalName());
	assertEquals("The namespace should be http://somenamespace.com", "http://somenamespace.com", RNGNode.getNamespace());

	// Check qualified namespace
	var element = mozile.xml.parseElement('<element name="  b:a  " xmlns:b="http://somenamespace.com"><empty/></element>');
	RNGNode = new mozile.rng.Element(element);
	assertEquals("The name should be 'b:a' without whitespace", "b:a", RNGNode.getName());
	assertEquals("The name should match 'prefix:localName'", RNGNode.getName(), RNGNode.getPrefix() +":"+ RNGNode.getLocalName());
	assertEquals("The namespace should be http://somenamespace.com", "http://somenamespace.com", RNGNode.getNamespace());

	assertTrue("mustHave('element') should be true", RNGNode.mustHave('element'));
	assertFalse("mustHave('attribute') is false", RNGNode.mustHave('attribute'));
}

/**
 * Test validation.
 */
function testValidate() {
	// Older versions of Safari have limited namespace support.
	if(mozile.browser.isSafari && mozile.browser.safariVersion <= 418)
		mozile.test.rng.checkCases(name, [6])
	else mozile.test.rng.checkCases(name);
}

