/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 
/** Mozile Test Script
 * @fileoverview This file contains JsUnit test functions for Mozile's InsertionPoint object.
 * <p>Project Homepage: http://mozile.mozdev.org
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: InsertionPoint.js,v 1.2 2006/08/23 16:55:28 jameso Exp $
 */


mozile.require("mozile.xml");
mozile.require("mozile.edit.InsertionPoint");
mozile.require("mozile.test.shared.util");
mozile.require("mozile.test.edit.util");
var name = "mozile.edit.InsertionPoint";

var testNode;
var testContent = '<p id="testContent">_Content.          More.<img/> <img/><img/><img/>More.<!--Comment-->More.<img/><!--Comment--><img/>More.<img/><!--Comment--><!--Comment--><!--Comment--><!--Comment--><strong>Content.</strong><img/>More.<em>Content.</em>More.<strong><em>Content.</em></strong>More._</p>';



/**
 * Expose the functions named in this array to JsUnit.
 * Make sure to keep it up to date!
 */
function exposeTestFunctionNames() {
	return ["testGetters", "testSelect", "testExtend", "testSeek", "testSeekNode"];
}

/**
 * 
 */
function testGetters() {
	mozile.test.shared.preselect();
	resetSelection("target2");
	var selection = mozile.dom.selection.get();
	var IP = selection.getInsertionPoint();
	assertNotNull("The IP should not be null.", IP);
	assertNotUndefined("The IP should not be undefined.", IP);
	
	var node;
	node = document.getElementById("target2").firstChild;
	//alert(mozile.xpath.getXPath(IP.getNode()) +" "+ IP.getOffset());
	assertEquals("node should be 'target2'.", node, IP.getNode());
	assertEquals("offset should be '1'.", 1, IP.getOffset());

	// These methods are not implemented:
	node = document.getElementById("target");
	IP = mozile.edit.getInsertionPoint(node, mozile.edit.NEXT);
	assertEquals("node should be 'target[1]'.", node.firstChild, IP.getNode());
	assertEquals("offset should be '0'.", 0, IP.getOffset());

	IP = mozile.edit.getInsertionPoint(node, mozile.edit.PREVIOUS);
	assertEquals("node should be 'target's last child.", node.lastChild, IP.getNode());
	assertEquals("offset should be lastChild's length.", node.lastChild.data.length, IP.getOffset());
	
}

/**
 *
 */
function testSelect() {
	mozile.test.shared.preselect();
	var node = document.getElementById("target2").firstChild;
	var offset = 5;
	var IP = new mozile.edit.InsertionPoint(node, offset);
	
	assertNotNull("The IP should not be null.", IP);
	assertNotUndefined("The IP should not be undefined.", IP);
	assertEquals("node should be 'target2'.", node, IP.getNode());
	assertEquals("offset should be "+offset, offset, IP.getOffset());
	
	var selection = mozile.dom.selection.get();
	if(!mozile.browser.isIE) {
		selection.removeAllRanges();
		assertNull("anchorNode should be null", selection.anchorNode);
		assertEquals("anchorOffset should be 0", 0, selection.anchorOffset);
		assertNull("focusNode should be undefined", selection.focusNode);
		assertEquals("focusOffset should be 0", 0, selection.focusOffset);
	}
	
	IP.select();
	selection = mozile.dom.selection.get();
	//alert(mozile.util.dumpValues(selection.store()) +"\n"+ mozile.xpath.getXPath(node) +"\n"+ mozile.xpath.getXPath(selection.anchorNode));
	assertEquals("anchorNode should be 'target2'", node, selection.anchorNode);
	assertEquals("anchorOffset should be "+offset, offset, selection.anchorOffset);
	assertEquals("focusNode should be 'target2'", node, selection.focusNode);
	assertEquals("focusOffset should be "+offset, offset, selection.focusOffset);
}

mozile.require("mozile.util");


/**
 *
 */
function testExtend() {
	mozile.test.shared.preselect();
	resetSelection("target2");
	var selection = mozile.dom.selection.get();
	var IP = selection.getInsertionPoint();
	
	for(var i=0; i < 20; i++) IP.next();
	IP.extend();
	selection = mozile.dom.selection.get();

	assertEquals("anchorNode should be 'target2'", document.getElementById("target2").firstChild, selection.anchorNode);
	assertEquals("anchorOffset should be 1", 1, selection.anchorOffset);
	assertEquals("focusNode should be the IP node", IP.getNode(), selection.focusNode);
	assertEquals("focusOffset should be the IP offset", IP.getOffset(), selection.focusOffset);
	
}


/**
 *
 */
function testSeek() {
	mozile.test.shared.preselect();
	resetSelection("target2");
	var selection = mozile.dom.selection.get();
	var IP = selection.getInsertionPoint();
	//mozile.setCurrentEditor(document.getElementById("target"));
	var target = document.getElementById("target");

	var i;
	for(i=0; i < 20; i++) IP.next();
	assertEquals("The selection should now be in 'target[2]'", target.childNodes[2], IP.getNode());
	for(i=0; i < 20; i++) IP.previous();
	assertEquals("The selection should now be in 'target2'", document.getElementById("target2").firstChild, IP.getNode());
	
	// Seek next
	resetTestNode();
	selection = mozile.dom.selection.get();
	IP = selection.getInsertionPoint();
	var offsets = [ // index-range, next expected action
		2,3,4,5,6,7,8,9, // 0-7, skip whitespace
		19,20,21,22,23,24, // 8-13, jump over one empty element
		0,1, // 14-15, jump over one and only one empty element
		4,5, // 16-17, enter next text node
		0,1,2,3,4,5, // 18-23, jump over comment
		1,2,3,4,5, // 24-28, jump over
		10, // 29, ignore comment
		0,1,2,3,4,5, // 30-35, jump over empty element and multiple comments into child's text
		0,1,2,3,4,5,6,7,8, // 36-44, jump out of child, past empty element, into text
		0,1,2,3,4,5, // 45-49, jump into em/test()
		1,2,3,4,5,6,7,8, // 50-57 jump out of em/test()
		1,2,3,4,5, // 57-61 jump into strong/em/test()
		1,2,3,4,5,6,7,8, // 62-69 jump out of strong/em/test()
		1,2,3,4,5 // 70-74
	];

	// IE collapses white space automatically, so account for this fact.
	// Starting at index 8 replace the next 6 values with these ones:
	if(mozile.browser.isIE) offsets.splice(8, 6,
		10,11,12,13,14,15
	);

	for(i=0; i < offsets.length; i++) {
		IP.next();
		assertEquals("Next: Focus offset for index "+ i +" should be "+ offsets[i], offsets[i], IP.getOffset());
	}
	
	IP.next();
	
	// Exceptions because of changed direction
	offsets[23] = 0;
	offsets[50] = 0;
	offsets[58] = 0;
	offsets[63] = 0;
	offsets[71] = 0;
	for(i = offsets.length - 1; i >= 0; i--) {
		IP.previous();
		assertEquals("Previous: Focus offset for index "+ i +" should be "+ offsets[i], offsets[i], IP.getOffset());
	}	
	
}


/**
 *
 */
function testSeekNode() {
	mozile.test.shared.preselect();
	var selection = mozile.dom.selection.get();

	// Seek next
	resetTestNode();
	var IP = selection.getInsertionPoint();
	var offsets = [
		2,4,5,6,8,10,12,0, // now inside strong
		20,0, // now inside em
		22,0, // now inside strong,em
		24 // 12
	];
	var i, offset;
	for(i=0; i < offsets.length; i++) {
		IP.seekNode(mozile.edit.NEXT);
		offset = IP.getOffset();
		if(IP.getNode().nodeType == mozile.dom.TEXT_NODE) {
			offset = mozile.dom.getIndex(IP.getNode());
		}
		//debug(IP +" --> "+ offsets[i] +"="+ offset);
		assertEquals("NEXT: Focus offset for index "+ i +" should be "+ offsets[i], offsets[i], offset);
	}
	
	// Seek previous
	for(i = offsets.length - 2; i >= 0; i--) {
		IP.seekNode(mozile.edit.PREVIOUS);
		offset = IP.getOffset();
		if(IP.getNode().nodeType == mozile.dom.TEXT_NODE) {
			offset = mozile.dom.getIndex(IP.getNode());
		}
		assertEquals("PREVIOUS: Focus offset for index "+ i +" should be "+ offsets[i], offsets[i], offset);
	}	

}


/**
 *
 */
/*
function testOutsideCurrentEditor() {
	var node = document.documentElement;
	var offset = 5;
	var IP = new mozile.edit.InsertionPoint(node, offset);
	
	IP.previous();
	assertNull("There should be no node", IP.getNode());
	assertNull("There should be no offset", IP.getOffset());
	
	IP = document.getElementById("target").getLastInsertionPoint();
	IP.next();
	assertNull("There should be no node", IP.getNode());
	assertNull("There should be no offset", IP.getOffset());
}
*/


/**
 *
 */
function resetSelection(id) {
	var anchorNode = document.getElementById(id).firstChild;
	var anchorOffset = 1;
	var selection = mozile.dom.selection.get();
	selection.collapse(anchorNode, anchorOffset);
}


/**
 *
 */
function resetTestNode() {
	if(testNode) testNode.parentNode.removeChild(testNode);
	var test;
	var container = document.getElementById("container");
	if(mozile.browser.isIE) {
		test = document.createElement("div");
		test.innerHTML = testContent;
		testNode = test.firstChild;
		container.appendChild(testNode);
	}
	else {
		var range = document.createRange();
		range.selectNodeContents(container);
		var fragment = range.createContextualFragment(testContent);
		testNode = fragment.firstChild;
		container.appendChild(fragment);
	}
	var selection = mozile.dom.selection.get();
	selection.collapse(testNode.firstChild, 1);
}