/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/0.8/LICENSE
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * @fileoverview Shared utilities for the Mozile project.
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.8
 * $Id: util.js,v 1.2 2006/08/23 16:47:53 jameso Exp $
 */


mozile.provide("mozile.util.*");

/**
 * A collection of utility functions.
 * @type Object
 */
mozile.util = new Object();
// JSDoc hack
mozile.util.prototype = new mozile.Module;

/**
 * Output all an object's property and method names as a comma-separated string.
 * @param {Object} obj
 * @type String
 */
mozile.util.dumpKeys = function(obj) {
	var keys = new Array();
	for(var key in obj) keys.push(key);
	keys.sort();
	return keys.join(", ");
}

/**
 * Output all an object's keys and values as a newline separated string.
 * @param {Object} obj
 * @type String
 */
mozile.util.dumpValues = function(obj) {
	var result = new Array();
	for(var key in obj) {
		result.push( key +" = "+ obj[key] );
	}
	result.sort();
	return result.join("\n");
}

/**
 * Makes the first character of each word in the given string uppercase and returns the new string.
 * @param {String} string The string to capitalize.
 * @ype String
 */
mozile.util.capitalize = function(string) {
	if(!string) return string;
	return string.replace(/\w+/g, function(a){
		return a.charAt(0).toUpperCase() + a.substr(1).toLowerCase();
	});
}

/**
 * Pads a string with spaces.
 * Uses a crude caching technique.
 * @param {String} string The string to pad.
 * @param {Integer} length The desired length.
 * @param {Boolean} left Optional. When true the spaces are added to the beginning of the string.
 * @ype String
 */
mozile.util.pad = function(string, length, left) {
	if(!string) string = " ";
	else string = String(string);

	if(!this._memory) this._memory = new Object();
	var id = string +":"+ length +":"+ left;
	if(this._memory[id]) return this._memory[id];

	var space = "";
	if(string.length < length) {
		for(var s=0; s < length - string.length; s++) space += " ";
	}

	var result;
	if(left) result = space + string;
	else     result = string + space;
	this._memory[id] = result;

	return result;
}



/** Mozile Debug -
 * A basic debugging tool. It logs messages to the mozileDebugArray, but only if their level exceeds the Mozile.getDebugLevel() setting, or they are marked "Status Message".
 * 
 * @param details An array of information. The first two fields are "File", and "Function" (usually a function name). Fancier debugging functions might use more fields. 
 * @param level An integer describing the importance of the debugging message. 4="critical", 3="very important", 2="important", 1="normal", 0="not important".
 * @param message A string containing the debugging message.
 * @return Always true.
 */
mozile.util.debug = function(details, level, message) {
	if(level >= mozile.getDebugLevel() || details["Status Message"]) {
		var date = new Date();
		mozile.util.messages.push([date.toLocaleString(), details, level, message]);
	}
	return true;
}

// Create the global debug list for this document.
mozile.util.messages = new Array();



