/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
 

/** Mozile Loader  
 * @fileoverview This file is used to configure and load Mozile. Mozile is a collection of JavaScripts which allow inline editing of XHTML/XML documents in Mozilla browsers. See the "INSTRUCTIONS" section below for more details on configuring this file.
 * 
 * Project Homepage: http://mozile.mozdev.org
 * For details on configuration, see: 
 *   http://mozile.mozdev.org/docs/mozileDocs.html
 * 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


/**** INSTRUCTIONS ****/

/**
 * This file allows you to configure how Mozile will operate in your webpages.
 * There are two sections:
 *   - Configuration
 *   - Commands
 *   - Initialization
 * In order for Mozile to function, you will may have to change the Configuration options. In order to specify which parts of your document should be editable you may have to add or remove Commands.
 * You probably should NOT change anything in the Initialization section.
 */



/**** CONFIGURATION ****/


var mozileScriptSource = "../../";
var mozileOptions = "debugLevel=0, warnBeforeUnload=false, saveCharset=UTF-8, saveEntities=[html40latin1, html40symbols, mathml20], saveConversion=[questionmark], hideInactiveCommands=true";
var mozileInterface = true; // Load interface code.
var mozileModules = [
		//"UnwantedModule",
		"UndoRedo",
		"CopyCutPaste: requestPrivileges=false",
		"XHTMLBasic",
		"LocalFile",
		//"LocalFile: default=true",
		"HTTPPost: url='http://localhost/~james/mozile/current/modules/HTTPPost/PHPdemo/save_dump.php'",
]; // end of mozileModules array
var XHTMLNS = "http://www.w3.org/1999/xhtml";


/**** END OF CONFIGURATION ****/



/**
 * Mozile Configuration
 * This function creates the main Mozile object and loads the modules.
 */
// Do not edit the following line.
function mozileConfiguration() {

/**** COMMANDS ****/

// mozile.createEditor("someElementId","");
mozile.createEditors(".editor","");
// mozile.makeDocumentEditable("");
// mozile.replaceTextarea("someTextareaId");

/**** END OF COMMANDS ****/

} // end of mozileConfiguration()




/*********** DO NOT EDIT BELOW THIS LINE ***********/
/**** (unless you really know what you're doing) ****/




/**** INITIALIZATION ****/

/**
 * Mozile Initialization
 * This function inserts a <script> tag into the document. The <script> tag load the core.js JavaScript file, which makes Mozile work. Once core.js is loaded, it will call the mozileConfiguration() function above, while will continue the loading process.
 */
function mozileInitialization() {

/**
 * Browser Detection
 * Mozile only works in Mozilla browsers: Firefox and Mozilla (Seamonkey). Although Apple's Safari browser might report that it is Gecko compatible, it does not include all the necessary functionality for Mozile, so it is not supported.
 */
	if((navigator.product == 'Gecko') && (navigator.userAgent.indexOf("Safari") == -1))
	{
		
		// If no mozileScriptSource is given, try to get the src attribute of the script tag in the original document which points to this file.
		if(mozileScriptSource=="") {
			var mozileRE = /(.*)mozile.js$/;
			var source, result;
			var scripts = document.getElementsByTagName("script");
			for(var i=0; i<scripts.length; i++) {
				source = scripts[i].getAttribute("src");
				result = mozileRE.exec(source);
				if(result && result[1]) {
					mozileScriptSource = result[1] + "../";
					break;
				}
			}
		}		
		
		// Build the script tag
		var scriptTag = document.createElementNS(XHTMLNS,"script");
		scriptTag.setAttribute("id","Mozile-Core-core.js");
		scriptTag.setAttribute("type","application/x-javascript");
		scriptTag.setAttribute("src", mozileScriptSource +"core/core.js");
			
		// For HTML insert the tag in the head, otherwise at the beginning of the documentElement
		if(document.documentElement.tagName.toLowerCase() == "html") {
			document.getElementsByTagName("head")[0].appendChild(scriptTag);
		}
		else {
			document.documentElement.insertBefore(scriptTag,document.documentElement.firstChild);
		}
	
		// core.js should now load when this script is finished running
	}

	// If the browser detection fails, throw an error. 
	// TODO; It might be better to die silently.
	else {
		alert("Mozile Error: This browser is not supported! Only Mozilla and Mozilla Firefox browsers are currently supported.");
	}

} // end of mozileInitialization()


// Finally, call the initialization function.
mozileInitialization();