/** Mozile Selection Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's addtions to the native Selection object.
 * 
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */

/*
 *
 */
function testNotInsertable() {
	var target = document.getElementById("target4");
	assertNull("IP should be null", target.getFirstInsertionPoint());
	assertNull("IP should be null", target.getFirstInsertionPoint());
}


/*
 *
 */
function testPosition() {
	var target = document.getElementById("target");
	assertEquals("Position should be 3.", 3, target.getPosition());
	assertNull("A node without a parent has no position.", document.createElement("cats").getPosition());
}

/**
 * Tests the getXPath method for three kinds of nodes.
 */
function testXPath() {
		// Element
	checkXPath(document.getElementById("target"));
		// Attribute
	checkXPath(document.getElementById("target").getAttributeNode("id"));
		// Text Node
	checkXPath(document.getElementById("target").lastChild);
}


/**
 * Tests the getXPath method for three kinds of nodes.
 */
function testBlock() {
	assertTrue("'target' is a block.", document.getElementById("target").isBlock());
	assertEquals("'target' is the parentBlock of 'target2'.", document.getElementById("target"), document.getElementById("target2").getParentBlock());
	assertTrue("'target' an ancestor of 'target2'.", document.getElementById("target").isAncestorOf(document.getElementById("target2")));
}

function testInsert() {
	var element = document.createElementNS(XHTMLNS, "span");
	document.getElementById("target").parentNode.insertAfter(element, document.getElementById("target"));
	assertEquals("'target's next sibling should be the element.", element, document.getElementById("target").nextSibling);
}


/**
 * Checks to see if an 
 * @param {Node} The node to check.
 */
function checkXPath(node) {
	//alert(node.getXPath());
	assertNotNull("getXPath should not be null.", node.getXPath());
	assertNotUndefined("getXPath should be defined.", node.getXPath());
	assertEquals("getXPath should be a string.", "string", typeof(node.getXPath()));
	
	var result = executeXPath(node.getXPath());
	assertEquals("There should be exactly one result.", 1, result.length);
	assertEquals("Names should match.", node.nodeName, result[0].nodeName);
	assertEquals("Types should match.", node.nodeType, result[0].nodeType);
	
	// Special case for badly behaving old Mozilla versions.
	// They seem to do everything right, except the node identity check fails.
	if(node.nodeType == Node.ATTRIBUTE_NODE) {
		var mozillaVersion = navigator.userAgent.match(/rv\:(\d+\.\d+)/)[1];
		if(Number(mozillaVersion) >= 1.8)
			assertEquals("The result should match the node.", node, result[0]);
	}
	else {
		assertEquals("The result should match the node.", node, result[0]);
	}
}


