/** Mozile Toolbar Test Script
 * @fileoverview This file contains JSUnit test functions for testing the MozileToolbar class. 
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.2
 */


/* Known Issues
testShowHideExternal crashes the browser when testing XUL pages.
*/


var name = "Toolbar";
var id = "target";
var position = "bottomOfWindow";
var configString = name+": position="+position;

/** Test - Constructor
 * Make sure that the MozileToolbar constructor is working. Use the default namespace.
 */
function testConstructor() {
	var element = document.getElementById(id);
	var component = new MozileToolbar(element, configString);
	checkComponentBasics(component);
	assertEquals("The position should be set", position, component.getPosition());
}


/** Test - Options
 * Test getting and setting options.
 */
function testOptions() {
	var element = document.getElementById(id);
	var configString = "DummyModule garbage text";
	var component = new MozileToolbar(element, configString);
	checkOptions(component);
}


/** Test - Show and Hide Element
 * Test showing and hiding the interface, which means inserting and removing it.
 */
function testShowHideElement() {
	var element = document.getElementById(id);
	var category = element.localName;
	var component = new MozileToolbar(element, configString);
	
	var count1 = document.getElementsByTagName(category).length;
	assertEquals("There should be one element with the matching id", 1, countElements(category, id));

	component.hide();
	assertEquals("The toolbar should be collapsed", true, component.getElement().collapsed);
	
	component.show();
	assertEquals("The toolbar should not be collapsed", false, component.getElement().collapsed);
	
	component.hide();
	assertEquals("The toolbar should be collapsed", true, component.getElement().collapsed);
}


/** 
 * Basic tests to ensure that the component exists and simple methods are working.
 */
function checkInterfaceBasics(component) {
	assertNotNull("getElement() should not be null", component.getElement());
	assertNotUndefined("getElement() should be defined.", component.getElement());
	assertEquals("getElement() should return an element.", 1, component.getElement().nodeType);
	
	assertNotNull("getParent() should not be null", component.getParent());
	assertNotUndefined("getParent() should be defined.", component.getParent());
	assertEquals("getParent() should return an element.", 1, component.getParent().nodeType);
}