/** Mozile Command Test Script
 * @fileoverview This file contains JSUnit test functions for testing the MozileInsertCommand object.
 * Requires MozileCommandUtils.js, MozileComponentUtils.js

 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */

var module = new MozileModule("XHTMLBasic");
module.load();

var name = "DummyCommand";
var id = "Mozile-TestCommand";
var tag = "test";
var label = "Test";
var tooltip = "Test Command";
var accelerator = "Command-T";
var accesskey = "T";
var image = "images/test.png";

var configString = name+": id="+id+", tag="+tag+", label="+label+", tooltip='"+tooltip+"', accesskey="+accesskey+", accelerator='"+accelerator+"', image='"+image+"'";


/** Test - Constructor
 * Test the constructor and basic methods.
 */

function testConstructor() {
	var component = new MozileInsertCommand(name);
	checkComponentBasics(component);
}



/** Test - Command
 * Create a command and make sure it's working
 */
function testCommand() {
	var component = new MozileInsertCommand(configString);
	checkComponentBasics(component);
	checkCommandOptions(component);
	checkOptions(component);
}


/**
 * Test a empty node insertion.
 */
function testExecuteEmpty() {
	var component = new MozileInsertCommand(configString);
	component.createNode = function() {
		var node = document.createElement("img");
		node.setAttribute("src", "linky");
		return node;
	}
	
	var target = document.getElementById("target2");
	var selection = window.getSelection();
	var range = document.createRange();
	range.setStart(target.firstChild, 2);
	range.setEnd(target.firstChild, 2);
	selection.removeAllRanges();
	selection.addRange(range);
	component.execute();
	
	var newNode = target.firstChild.nextSibling;
	assertEquals("Nodes should match.", component.createNode().nodeName, newNode.nodeName);
	assertEquals("NewNode's next sibling should be selected", newNode.nextSibling, selection.focusNode);
	assertTrue("Selection should be collapsed.", selection.isCollapsed);
	assertEquals("Selection offset should be at the beginning.", 0, selection.focusOffset);
}

/**
 * Test a non-empty node insertion.
 */
function testExecuteNonEmpty() {
	var component = new MozileInsertCommand(configString);
	component.createNode = function() {
		var node = document.createElement("a");
		node.setAttribute("href", "linky");
		node.appendChild(window.getSelection().getRangeAt(0).extractContents());
		return node;
	}
	
	var target = document.getElementById("target");
	var selection = window.getSelection();
	var range = document.createRange();
	range.setStart(target.firstChild, 0);
	range.setEnd(target.firstChild, 2);
	selection.removeAllRanges();
	selection.addRange(range);
	component.execute();
	
	var newNode = target.firstChild.nextSibling;
	assertEquals("Nodes should match.", component.createNode().nodeName, newNode.nodeName);
	assertEquals("First child's text node should be selected", newNode.firstChild, selection.focusNode);
	assertTrue("Selection should be collapsed.", selection.isCollapsed);
	assertEquals("Selection offset should be at the end.", newNode.firstChild.textContent.length, selection.focusOffset);
}


/** Test - Elements
 * Create a command and make sure it's working
 */
function testElements() {
	var component = new MozileInsertCommand(configString);
	checkComponentBasics(component);

	checkButton(component.getButton());
	checkMenuitem(component.getMenuitem());
}



