/** Mozile Component Test Script
 * @fileoverview This file contains JSUnit test functions for testing the MozileEditor object.
 * Requires MozileComponentUtils.js
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


var name = "DummyModule";
var testNode;
var testContent = '<p id="testContent">_Content.          More.<img/> <img/><img/><img/>More.<!--Comment-->More.<img/><!--Comment--><img/>More.<img/><!--Comment--><!--Comment--><!--Comment--><!--Comment--><span>Content.</span><img/>More._</p>';

/** Test - Constructor
 * Test the constructor and basic methods.
 */

function testConstructor() {
	var component = new MozileEditor(name);
	checkComponentBasics(component);
}



/** Test - Options
 * Test getting and setting options.
 */
function testOptions() {
	var configString = "DummyModule garbage text";
	var component = new MozileEditor(configString);
	checkOptions(component);
}


function testInsertDelete() {
	var component = mozileEditor;
	resetSelection("target2");
	
	var node = document.getElementById("target2").firstChild;
	var original = node.textContent;
	component.insertString("k");
	assertEquals("Text should be changed.", "k"+original, node.textContent);
	component.deletion(InsertionPoint.prototype.PREVIOUS);
	assertEquals("Text should be restored.", original, node.textContent);
}



function testNotInsertDelete() {
	var component = mozileEditor;
	resetSelection("non-editable");
	
	var node = document.getElementById("non-editable").firstChild;
	var original = node.textContent;
	component.insertString("k");
	assertEquals("Text should not be changed.", original, node.textContent);
	component.deletion(InsertionPoint.prototype.PREVIOUS);
	assertEquals("Text should not be changed.", original, node.textContent);
}


function testDeleteNext() {
	var component = mozileEditor;
	var selection = window.getSelection();
	
	var operations = [ // s = steps, r = number of children removed
		{"s": 15, "r": 1},
		{"s": 2, "r": 2},
		{"s": 1, "r": 1},
		{"s": 1, "r": 1},
		{"s": 6, "r": 2},
		{"s": 5, "r": 3},
		{"s": 1, "r": 1},
		{"s": 6, "r": 6},
		{"s": 9, "r": 2},
		{"s": 5, "r": 0},
	];
	var op;

	var step = InsertionPoint.prototype.NEXT;
	resetTestNode();
	var totalLength = testNode.getLength();
	var lastLength = totalLength;
	for(var i=0; i < operations.length; i++) {
		op = operations[i];
		for(var j=0; j < op["s"]; j++) component.deletion(step);
		assertEquals("Previous: Number of testNode children removed for index "+ i +" should be "+ op["r"], op["r"], lastLength - testNode.getLength());
		assertEquals("Previous: Focus offset should be 1", 1, selection.focusOffset);
		lastLength = testNode.getLength();
	}
}


function testDeletePrevious() {
	var component = mozileEditor;
	var selection = window.getSelection();
	
	var operations = [ // s = steps, r = number of children removed
		{"s": 6, "r": 1},
		{"s": 9, "r": 6},
		{"s": 6, "r": 3},
		{"s": 1, "r": 1},
		{"s": 6, "r": 2},
		{"s": 5, "r": 2},
		{"s": 1, "r": 1},
		{"s": 1, "r": 1},
		{"s": 2, "r": 2},
		{"s": 14, "r": 0},
	];
	var op;

	var step = InsertionPoint.prototype.PREVIOUS;
	resetTestNode();
	selection.collapse(testNode.lastChild, testNode.lastChild.textContent.length -1);
	var totalLength = testNode.getLength();
	var lastLength = totalLength;
	for(var i=0; i < operations.length; i++) {
		op = operations[i];
		for(var j=0; j < op["s"]; j++) component.deletion(step);
		assertEquals("Previous: Number of testNode children removed for index "+ i +" should be "+ op["r"], op["r"], lastLength - testNode.getLength());
		assertEquals("Previous: Focus offset should be 0", 0, selection.focusOffset);
		lastLength = testNode.getLength();
	}
}


// insertString
// insertFragment
// deletion
// splitBlock


/**
 *
 */
function resetSelection(id) {
	var node = document.getElementById(id).firstChild;
	var offset = 0;
	var selection = window.getSelection();
	var range = document.createRange();
	
	range.setStart(node, offset);
	selection.removeAllRanges();
	selection.addRange(range);
}

/**
 *
 */
function resetTestNode() {
	if(testNode) testNode.parentNode.removeChild(testNode);
	var parser = new DOMParser();
	var test = parser.parseFromString(testContent, "text/xml");
	testNode = document.getElementById("container").appendChild(test.firstChild);
	window.getSelection().collapse(testNode.firstChild, 1);
}