/** Mozile Component Test Script
 * @fileoverview This file contains JSUnit test functions for testing the MozileComponent object.
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


var name = "DummyModule";

/** Test - Constructor
 * Test the constructor and basic methods.
 */

function testConstructor() {
	var component = new MozileComponent(name);
	checkComponentBasics(component);
}



/** Test - Basic Parsing
 * Test the simplest module configuration string. Garbage text in inserted, but the result of getOptions() should still have some structure.
 */

function testBasicParsing() {
	var configString = "DummyModule garbage text";
	var component = new MozileComponent(configString);
	checkComponentBasics(component);
}


/** Test - Advanced Parsing
 * Test a module configuration string with lots of options. This checks minimum, maximum, required, and excluded version strings, and a few other options.
 */
function testAdvancedParsing() {
	var configString = "DummyModule: minVersion=1.0.2, maxVersion=1.1.2, notVersions=[1.1.0, 1.0.6], requireVersion=1.0.7, remoteVersion=1.0.7, forceRemote=false, remotePath='/path/to/module/' ";
	var component = new MozileComponent(configString);
	checkComponentBasics(component);
	
	var pairs = new Array();
	pairs['minVersion']="1.0.2";
	pairs['maxVersion']="1.1.2";
	pairs['requireVersion']="1.0.7";
	pairs['remoteVersion']="1.0.7";
	pairs['forceRemote']=false;
	pairs['remotePath']="/path/to/module/";

	// Loop over the array, checking each of the values	
	for(key in pairs) {
		assertNotNull("The "+key+" should exist", component.getOption(key));
		assertNotUndefined("The "+key+" should be defined", component.getOption(key));
		assertEquals("The "+key+" should be "+pairs[key], pairs[key], component.getOption(key));
	}
	
	var notVersions = ["1.1.0", "1.0.6"];
	assertEquals("There should be two values in the notVersions array", notVersions.length, component.getOption("notVersions").length);
	for(var i=0; i < notVersions.length; i++) {
		assertEquals("Values inside the notVersions array should also work", notVersions[i], component.getOption("notVersions")[i]);
	}

}


/** Test - Ugly Parsing
 * Test a module configuration string that is a mess, but still valid.
 */
function testUglyParsing() {
	var configString = "  DummyModule garbage:junk,, minVersion=1.0.2, maxVersion=1.1.2,  notVersions=[1.1.0,false, 1.0.6, the odore, frederic,, ,  7  ], requireVersion=1.0.7, remoteVersion=1.0.7, forceRemote=false, remotePath='/path/to/another module/' extra_stuff =ww";
	var component = new MozileComponent(configString);
	checkComponentBasics(component);
	
	var pairs = new Array();
	pairs['minVersion']="1.0.2";
	pairs['maxVersion']="1.1.2";
	pairs['requireVersion']="1.0.7";
	pairs['remoteVersion']="1.0.7";
	pairs['forceRemote']=false;
	pairs['remotePath']="/path/to/another module/";

	// Loop over the array, checking each of the values	
	for(key in pairs) {
		assertNotNull("The "+key+" should exist", component.getOption(key));
		assertNotUndefined("The "+key+" should be defined", component.getOption(key));
		assertEquals("The "+key+" should be "+pairs[key], pairs[key],component.getOption(key));
	}
	
	var notVersions = ["1.1.0", false, "1.0.6", "the odore", "frederic", 7];
	assertEquals("There should be two values in the notVersions array", notVersions.length, component.getOption("notVersions").length);
	for(var i=0; i < notVersions.length; i++) {
		assertEquals("Values inside the notVersions array should also work", notVersions[i], component.getOption("notVersions")[i]);
	}

}



/** Test - Options
 * Test getting and setting options.
 */
function testOptions() {
	var configString = "DummyModule garbage text";
	var component = new MozileComponent(configString);
	checkOptions(component);

}



