/** Mozile Command Test Script
 * @fileoverview This file contains JSUnit test functions for testing the MozileCommandSeparator object.
 * Requires MozileCommandUtils.js,MozileComponentUtils.js
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


var name = "DummyCommandList";
var id = "Mozile-TestCommand";
var label = "Test";
var tooltip = "Test Command";
var accelerator = "Command-T";
var accesskey = "T";
var image = "images/test.png";

var configString = name+": id="+id+", label="+label+", tooltip='"+tooltip+"', accesskey="+accesskey+", accelerator='"+accelerator+"', image='"+image+"'";


/** Test - Constructor
 * Test the constructor and basic methods.
 */

function testConstructor() {
	var component = new MozileCommandSeparator(name);
	checkComponentBasics(component);
}


/** Test - Command
 * Create a command and make sure it's working
 */
function testCommand() {
	var component = new MozileCommandSeparator(configString);
	checkComponentBasics(component);
	checkCommandOptions(component);
	checkOptions(component);
	assertFalse("This command is not undoable.", component.isUndoable());
}


/** Test - Elements
 * Check the elements created by the command.
 */
function testElements() {
	var component = new MozileCommandSeparator(configString);
	checkComponentBasics(component);

	checkToolbarseparator(component.getButton());
	checkMenuseparator(component.getMenuitem());
}




/** Check Button
 * Makes sure the button element attributes are properly set.
 */
function checkToolbarseparator(element) {
	assertEquals("The localName of element should be 'separator'", "separator", element.localName);
	assertEquals("The id of element should equal id-Separator", id+"-Separator", element.getAttribute("id"));
	assertEquals("The class of element should equal 'mozileSeparator'", "mozileSeparator", element.getAttribute("class"));
}


/** 
 * Makes sure the menuitem element attributes are properly set.
 */
function checkMenuseparator(element) {
	assertEquals("The localName of element should be 'menuseparator'", "menuseparator", element.localName);
	assertEquals("The id of element should equal id-Menuseparator", id+"-Menuseparator", element.getAttribute("id"));
	assertEquals("The class of element should equal 'mozileMenuseparator'", "mozileMenuseparator", element.getAttribute("class"));
}




