/** Mozile InsertionPoint Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's InsertionPoint object.
 * 
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */

mozile.setCurrentEditor(document.getElementById("target"));

var testNode;
var testContent = '<p id="testContent">_Content.          More.<img/> <img/><img/><img/>More.<!--Comment-->More.<img/><!--Comment--><img/>More.<img/><!--Comment--><!--Comment--><!--Comment--><!--Comment--><span>Content.</span><img/>More._</p>';

/**
 * 
 */
function testGetters() {
	var selection = window.getSelection();
	selection.removeAllRanges();
	assertNull("Without a selection the IP should be null.", selection.getInsertionPoint());
	
	resetSelection("target2");
	var IP = window.getSelection().getInsertionPoint();
	assertNotNull("The IP should not be null.", IP);
	assertNotUndefined("The IP should not be undefined.", IP);
	
	var node;
	node = document.getElementById("target2").firstChild;
	assertEquals("node should be 'target2'.", node, IP.getNode());
	assertEquals("offset should be '0'.", 0, IP.getOffset());
	
	node = document.getElementById("target");
	IP = node.getFirstInsertionPoint();
	assertEquals("node should be 'target[1]'.", node.firstChild, IP.getNode());
	assertEquals("offset should be '0'.", 0, IP.getOffset());

	IP = node.getLastInsertionPoint();
	assertEquals("node should be 'target's last child.", node.lastChild, IP.getNode());
	assertEquals("offset should be lastChild's length.", node.lastChild.textContent.length, IP.getOffset());
	
}

/**
 *
 */
function testSelect() {
	var node = document.getElementById("target2").firstChild;
	var offset = 5;
	var IP = new InsertionPoint(node, offset);
	
	assertNotNull("The IP should not be null.", IP);
	assertNotUndefined("The IP should not be undefined.", IP);
	assertEquals("node should be 'target2'.", node, IP.getNode());
	assertEquals("offset should be "+offset, offset, IP.getOffset());
	
	var selection = window.getSelection();
	selection.removeAllRanges();
	assertNull("anchorNode should be null", selection.anchorNode);
	assertEquals("anchorOffset should be 0", 0, selection.anchorOffset);
	assertNull("focusNode should be undefined", selection.focusNode);
	assertEquals("focusOffset should be 0", 0, selection.focusOffset);
	
	IP.select();
	assertEquals("anchorNode should be 'target2'", node, selection.anchorNode);
	assertEquals("anchorOffset should be "+offset, offset, selection.anchorOffset);
	assertEquals("focusNode should be 'target2'", node, selection.focusNode);
	assertEquals("focusOffset should be "+offset, offset, selection.focusOffset);
}

/**
 *
 */
function testExtend() {
	var selection = window.getSelection();
	resetSelection("target2");
	var IP = selection.getInsertionPoint();
	
	for(var i=0; i < 20; i++) IP.next();
	IP.extend();
	assertEquals("anchorNode should be 'target2'", document.getElementById("target2").firstChild, selection.anchorNode);
	assertEquals("anchorOffset should be 0", 0, selection.anchorOffset);
	assertEquals("focusNode should be the IP node", IP.getNode(), selection.focusNode);
	assertEquals("focusOffset should be the IP offset", IP.getOffset(), selection.focusOffset);
	
}


/**
 *
 */
function testSeek() {
	var selection = window.getSelection();
	resetSelection("target2");
	var IP = selection.getInsertionPoint();
	mozile.setCurrentEditor(document.getElementById("target"));
	var target = document.getElementById("target");

	var i;
	for(i=0; i < 20; i++) IP.next();
	assertEquals("The selection should now be in 'target[2]'", target.childNodes[2], IP.getNode());
	for(i=0; i < 20; i++) IP.previous();
	assertEquals("The selection should now be in 'target2'", document.getElementById("target2").firstChild, IP.getNode());
	
	// Seek next
	resetTestNode();
	IP = selection.getInsertionPoint();
	var offsets = [ // index-range, next expected action
		2,3,4,5,6,7,8,9, // 0-7, skip whitespace
		19,20,21,22,23,24, // 8-13, jump over one empty element
		0,1, // 14-15, jump over one and only one empty element
		4,5, // 16-17, enter next text node
		0,1,2,3,4,5, // 18-23, jump over comment
		1,2,3,4,5, // 24-28, jump over
		11, // 29, ignore comment
		0,1,2,3,4,5, // 30-35, jump over empty element and multiple comments into child's text
		0,1,2,3,4,5,6,7,8, // 36-44, jump out of child, past empty element, into text
		0,1,2,3,4,5 // 45-49
	];
	for(i=0; i < offsets.length; i++) {
		IP.next();
		assertEquals("Next: Focus offset for index "+ i +" should be "+ offsets[i], offsets[i], IP.getOffset());
	}
	
	IP.next();
	
	// Exceptions
	offsets[23] = 0;
	offsets[29] = 10;
	for(i = offsets.length - 1; i >= 0; i--) {
		IP.previous();
		assertEquals("Previous: Focus offset for index "+ i +" should be "+ offsets[i], offsets[i], IP.getOffset());
	}	
	
}


/**
 *
 */
function testSeekNode() {
	var selection = window.getSelection();

	// Seek next
	resetTestNode();
	var IP = selection.getInsertionPoint();
	var offsets = [
		1,2,3,4,5,6, // 0-5, skip one comment
		8,9, // 6-7, skip one comment
		11,12,13, // 8-10, skip four comments and jump into child's text
		0, // 11, jump out of child, past empty element, into text
		19 // 12
	];
	var i, offset;
	for(i=0; i < offsets.length; i++) {
		IP.seekNode(IP.NEXT);
		if(IP.getNode().nodeType == Node.ELEMENT_NODE) {
			IP = new InsertionPoint(IP.getNode().childNodes[IP.getOffset()], 0);
		}
		assertEquals("NEXT: Focus offset for index "+ i +" should be "+ offsets[i], offsets[i], IP.getNode().getPosition());
	}
	return;
	
	// Seek previous
	for(i = offsets.length-1; i >= 0; i--) {
		IP.seekNode(IP.PREVIOUS);
		if(IP.getNode() == testNode) {
			IP = new InsertionPoint(testNode.childNodes[IP.getOffset()], 0);
		}
		assertEquals("PREVIOUS: Focus offset for index "+ i +" should be "+ offsets[i], offsets[i], IP.getNode().getPosition());
	}	

}


/**
 *
 */
/*
function testOutsideCurrentEditor() {
	var node = document.documentElement;
	var offset = 5;
	var IP = new InsertionPoint(node, offset);
	
	IP.previous();
	assertNull("There should be no node", IP.getNode());
	assertNull("There should be no offset", IP.getOffset());
	
	IP = document.getElementById("target").getLastInsertionPoint();
	IP.next();
	assertNull("There should be no node", IP.getNode());
	assertNull("There should be no offset", IP.getOffset());
}
*/


/**
 *
 */
function resetSelection(id) {
	var anchorNode = document.getElementById(id).firstChild;
	var anchorOffset = 0;
	//var focusNode = document.getElementById("target2").firstChild;
	//var focusOffset = 5;
	var selection = window.getSelection();
	var range = document.createRange();
	
	range.setStart(anchorNode, anchorOffset);
	//range.setEnd(focusNode, focusOffset);
	selection.removeAllRanges();
	selection.addRange(range);
}



/**
 *
 */
function resetTestNode() {
	if(testNode) testNode.parentNode.removeChild(testNode);
	var parser = new DOMParser();
	var test = parser.parseFromString(testContent, "text/xml");
	testNode = document.getElementById("container").appendChild(test.firstChild);
	window.getSelection().collapse(testNode.firstChild, 1);
}