/** Mozile Document Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's addtions to the native Document object.
 * 
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


/*
 *
 */
function testInsertable() {
	var target = document.getElementById("target");
	var node, offset, IP;

	node = target.firstChild;
	offset = 0;
	IP = target.getFirstInsertionPoint();
	assertEquals("Node should be "+node, node, IP.getNode());
	assertEquals("Offset should be "+offset, offset, IP.getOffset());

	node = target.lastChild;
	offset = node.textContent.length;
	IP = target.getLastInsertionPoint();
	assertEquals("Node should be "+node, node, IP.getNode());
	assertEquals("Offset should be "+offset, offset, IP.getOffset());
}



/*
 *
 */
function testNotInsertable() {
	var target = document.getElementById("target4");
	assertNull("IP should be null", target.getFirstInsertionPoint());
	assertNull("IP should be null", target.getFirstInsertionPoint());
}

