/* Mozile Test Page Script
 * This script takes the URI of the current document, looks at everything after the first "?", and splits it by commas. Each comma separated block is given as the "src" of a new script tag, which is appended to the top (head) of the document. 
 */

var args = document.documentURI;
args = args.slice(args.indexOf('?')+1, args.length);
args = unescape(args);
args = args.split("&");

var type, pages, matchTest;
for(var a=0; a < args.length; a++) {
	matchTest = args[a].match(/test=\[(\w+):(.+)\]/);
	if(matchTest && matchTest.length == 3) {
		type = matchTest[1];
		pages = matchTest[2];
	}
}

if(pages) {
	pages = pages.split(",");
	
	// GUIUtils.js (and thus most functional tests) won't work in earlier versions of Gecko. If the version would not support it, check for that file. If it's found, throw an error.
	var mozillaVersion = navigator.userAgent.match(/rv\:(\d+\.\d+)/)[1];
	if(Number(mozillaVersion) < 1.8) {
		for(var p=0; p < pages.length; p++) {
			if(pages[p].indexOf("GUIUtils") >= 0) throw Error("Mozile test cannot be run because GUIUtils.js does not support Mozilla browsers before revision 1.8. This means Firefox 1.5+ and SeaMonkey 1.0+ are supported, earlier versions of Firefox and the Mozilla Suite are not.");
		}	
	}

	var scriptTag, src;
	var head = document.getElementsByTagName("head")[0];
	for(var i=0; i < pages.length; i++) {
		if(document.documentElement.tagName.toLowerCase() == "html") {
			scriptTag = document.createElement("script");
		}
		else {
			scriptTag = document.createElementNS("http://www.w3.org/1999/xhtml","html:script");
		}
		src = "../"+ type +"/"+ pages[i] +".js";
		scriptTag.setAttribute("src", src);

		scriptTag.setAttribute("type","application/x-javascript");
		if(head) {
			head.appendChild(scriptTag);
		}
		else { 
			document.documentElement.appendChild(scriptTag);
		}
	}
}