/* Mozile Test Page Script
 * This script takes the URI of the current document, looks at everything after the first "?", and splits it by commas. Each comma separated block is given as the "src" of a new script tag, which is appended to the top (head) of the document. 
 */

var args = document.documentURI;
args = args.slice(args.indexOf('?')+1, args.length);
args = unescape(args);
args = args.split("&");

var type, pages, matchTest;
for(var a=0; a < args.length; a++) {
	matchTest = args[a].match(/test=\[(\w+):(.+)\]/);
	if(matchTest && matchTest.length == 3) {
		type = matchTest[1];
		pages = matchTest[2];
	}
}

if(pages) {
	pages = pages.split(",");
	var scriptTag, src;
	for(var i=0; i < pages.length; i++) {
		src = "../"+ pages[i] +".js";
		addScript(src);
	}
}

function addScript(src) {
	if(document.documentElement.tagName.toLowerCase() == "html") {
		scriptTag = document.createElement("script");
	}
	else {
		scriptTag = document.createElementNS("http://www.w3.org/1999/xhtml", "html:script");
	}

	scriptTag.setAttribute("src", src);
	scriptTag.setAttribute("type","text/javascript");

	var head = document.getElementsByTagName("head")[0];
	if(head) {
		head.appendChild(scriptTag);
	}
	else { 
		document.documentElement.appendChild(scriptTag);
	}
}