<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!--
Mozile Documentation XSL: XML to XHTML

Revised: 2005-08-30
-->
	<xsl:output method="html" indent="yes"/>
	
	<xsl:template match="/">
<html>

	<head>

		<title>Mozile Tests: mozile.js</title>
		<script type="application/x-javascript" src="index.js"/>
		<style type="text/css">
		
body {
	font-family: Arial, Helvitica, sans-serif;	
}

table {
	width: 100%;
}

.tableHeader {
	font-size: larger;
	font-weight: bold;
	background-color: lightblue;
}

.component {
	font-size: larger;
	font-weight: bold;
	background-color: #EEEEEE;
}

.name {
	background-color: lightgray;
	padding: 5px;
}

.description {
	font-style: italic;
	padding: 10px 5px 10px 5px;
}

.test1 {
}

.test2 {
	font-size: small;
	color: #888888;
	background-color: #EFEFEF;
}

.depth0 .name { 
	border-right: solid white 20px;
}
.depth1 .name {
	border-left: solid white 10px;
	border-right: solid white 10px;
}
.depth2 .name {
	border-left: solid white 20px;
}

.button {
	text-align: center;
	background-color: #CCCCCC;
	color: white;
	-moz-border-radius: 4px;
	padding: 2px 5px 2px 5px;
}
.button:hover {
	background-color: gray;
	cursor: pointer;
}

.fullSuite {
	font-size: larger;
	font-weight: bold;
}

#fullSuite {
	font-size: 18pt;
	text-align: right;
	padding-right: 10px;
}

		</style>

	</head>

	<body>

		<h2>Mozile Test Suite</h2>
		
		<table>
			<tr class="fullSuite">
				<td id="fullSuite" colspan="2">Full Test Suite</td>				
				<xsl:call-template name="testsuiteButton">
					<xsl:with-param name="type">all</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="testsuiteButton">
					<xsl:with-param name="type">html</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="testsuiteButton">
					<xsl:with-param name="type">xhtml</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name="testsuiteButton">
					<xsl:with-param name="type">xml</xsl:with-param>
				</xsl:call-template>
				<!--
				<xsl:call-template name="testsuiteButton">
					<xsl:with-param name="testType">xul</xsl:with-param>
				</xsl:call-template>
				-->
			</tr>
			
			<tr class="tableHeader">
				<th colspan="2">Test</th>
				<th>ALL</th>
				<th>HTML</th>
				<th>XHTML</th>
				<th>XML</th>
				<!--<th>XUL</th>-->
			</tr>
			
			<xsl:apply-templates/>
		
		</table>
	</body>
</html>
	</xsl:template>
	
	<xsl:template match="component">
		<tr class="component">
			<td colspan="2">
				<a>
					<xsl:attribute name="href">
						<xsl:value-of select="@path"/>
					</xsl:attribute>
					<xsl:value-of select="@name"/>
				</a>
			</td>
			<xsl:call-template name="testsuiteButton">
				<xsl:with-param name="type">all</xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="testsuiteButton">
				<xsl:with-param name="type">html</xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="testsuiteButton">
				<xsl:with-param name="type">xhtml</xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="testsuiteButton">
				<xsl:with-param name="type">xml</xsl:with-param>
			</xsl:call-template>
			<!--
			<xsl:call-template name="testsuiteButton">
				<xsl:with-param name="testType">xul</xsl:with-param>
			</xsl:call-template>
			-->
		</tr>
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template match="test">
		<tr>
			<xsl:attribute name="class">
				<xsl:text>depth</xsl:text>
				<xsl:value-of select="count(ancestor::test)"/>
			</xsl:attribute>
			<th class="name" rowspan="2">
				<xsl:value-of select="@name"/>
			</th>
			<td class="description" colspan="6">
				<xsl:value-of select="@description"/>
			</td>
		</tr>
		<tr>
			<xsl:attribute name="class">
				<xsl:text>test2</xsl:text>
			</xsl:attribute>
			<td>
				<xsl:value-of select="@targets"/>
			</td>
			<xsl:call-template name="testallButton"/>
			<xsl:call-template name="testpageButton">
				<xsl:with-param name="type">html</xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="testpageButton">
				<xsl:with-param name="type">xhtml</xsl:with-param>
			</xsl:call-template>
			<xsl:call-template name="testpageButton">
				<xsl:with-param name="type">xml</xsl:with-param>
			</xsl:call-template>
			<!--
			<xsl:call-template name="testpageButton">
				<xsl:with-param name="type">xul</xsl:with-param>
			</xsl:call-template>
			-->
		</tr>
		<xsl:apply-templates/>
	</xsl:template>
	
	<!-- Creates a button pointing to a testsuite including all child tests and using the given file type. -->
	<xsl:template name="testsuiteButton">
		<xsl:param name="type"/>
		<td class="button">
			<xsl:attribute name="onclick">
				<xsl:text>javascript:openUnitTestPage('core/testsuite.html&amp;type=</xsl:text>
				<xsl:value-of select="$type"/>
				<xsl:text>&amp;pages=</xsl:text>
				<xsl:variable name="count" select="count(.//test)"/>
				<xsl:for-each select=".//test">
					<xsl:value-of select="@testpage"/>
					<xsl:if test="position() != $count">
						<xsl:text>;</xsl:text>
					</xsl:if>
				</xsl:for-each>
				<xsl:text>')</xsl:text>
			</xsl:attribute>
			<xsl:value-of select="translate($type, 'axuhtml', 'AXUHTML')"/>
		</td>
	</xsl:template>
	
	<!-- Creates a test suite button for this test, pointing to a testsuite which includes all file types. -->
	<xsl:template name="testallButton">
		<td class="button">
			<xsl:attribute name="onclick">
				<xsl:text>javascript:openUnitTestPage('core/testsuite.html&amp;type=all</xsl:text>
				<xsl:text>&amp;pages=</xsl:text>
				<xsl:value-of select="@testpage"/>
				<xsl:text>')</xsl:text>
			</xsl:attribute>
			<xsl:text>ALL</xsl:text>
		</td>
	</xsl:template>
	
	<!-- Creates a button for the current test, pointing to a testpage with the given file type. -->
	<xsl:template name="testpageButton">
		<xsl:param name="type"/>
		<xsl:param name="filetype">
			<xsl:choose>
				<xsl:when test="$type='html'">htm</xsl:when>
				<xsl:when test="$type='xhtml'">html</xsl:when>
				<xsl:otherwise><xsl:value-of select="$type"/></xsl:otherwise>
			</xsl:choose>
		</xsl:param>
		<td class="button">
			<xsl:attribute name="onclick">
				<xsl:text>javascript:openUnitTestPage('core/testpage.</xsl:text>
				<xsl:value-of select="$filetype"/>
				<xsl:text>&amp;pages=</xsl:text>
				<xsl:value-of select="@testpage"/>
				<xsl:text>')</xsl:text>
			</xsl:attribute>
			<xsl:value-of select="translate($type, 'axuhtml', 'AXUHTML')"/>
		</td>
	</xsl:template>
	
	
</xsl:stylesheet>