/** Mozile Command Test Script
 * @fileoverview This file contains JSUnit test functions for testing the MozileWrapCommand object.
 * Requires MozileCommandUtils.js, MozileComponentUtils.js
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */

var module = new MozileModule("XHTMLBasic");
module.load();

var name = "DummyCommand";
var id = "Mozile-TestCommand";
var tag = "test";
var mode = "inline";
var label = "Test";
var tooltip = "Test Command";
var accelerator = "Command-T";
var accesskey = "T";
var image = "images/test.png";

var configString = name+": id="+id+", tag="+tag+", mode="+mode+", label="+label+", tooltip='"+tooltip+"', accesskey="+accesskey+", accelerator='"+accelerator+"', image='"+image+"'";


/** Test - Constructor
 * Test the constructor and basic methods.
 */

function testConstructor() {
	var component = new MozileWrapCommand(name);
	checkComponentBasics(component);
}


/** Test - Command
 * Create a command and make sure it's working
 */
function testCommand() {
	var component = new MozileWrapCommand(configString);
	checkComponentBasics(component);
	assertEquals("Mode should be "+mode, mode, component.getMode());
	assertEquals("Tag should be "+tag, tag, component.getTag());
	checkCommandOptions(component);
	checkOptions(component);
}


/** Test - Elements
 * Create a command and make sure it's working
 */
function testElements() {
	var component = new MozileWrapCommand(configString);
	checkComponentBasics(component);

	checkButton(component.getButton());
	checkMenuitem(component.getMenuitem());
	
	assertEquals("The type of element should equal 'checkbox'", "checkbox", component.getMenuitem().getAttribute("type"));
}



