/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/license2.html
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */

/** 
 * @fileoverview Allows Mozile to store a stack of past document states, and restore them on command.
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7
 */



/** Mozile - Undo Stack -
 * An array which contains stored states for the document.
 */
MozileMediator.prototype.undoStack = new Array();

/** Mozile - Undo Counter -
 * An integer which tracks the current position in the undoStack.
 */
MozileMediator.prototype.undoCounter = 0;



/** Mozile - Store State -
 * Records the state of the document and adds it to the undoStack.
 * 
 * @return True if successful.
 */
MozileMediator.prototype.storeState = function(command) {
	var f = new Array();
	f["File"] = "UndoRedo/UndoRedo.js";
	f["Function"] = "Mozile.storeState()";
	this.debug(f,1,"Storing document");

	// If this is the first change after a save, then change the status message and set the changesSaved to false.
	if(this.changesSaved == true) {
		this.status(f,1,"Editing");
		this.changesSaved = false;
	}

	// Reset the key counter
	this.keyCounter = 0;

	var selection = window.getSelection();
	
	// For each editor in the document, add it and a clone of its contents to the states array.
	var states = new Array();
	var editorArray;
	this.debug(f,1,"Number of editors: " + this.getEditors().length);
	for(var i=0; i<this.getEditors().length; i++) {
		editorArray = new Array(this.getEditors()[i], this.getEditors()[i].cloneNode(true) );
		states.push(editorArray);
	}


	// If the undoCounter is less than the length of the undoStack-1, throw out all the entries above the undoCounter entry.
	if(this.undoCounter < this.undoStack.length - 1) {
		this.undoStack = this.undoStack.slice(0,this.undoCounter+1);
	}
	
	// Add the current state to the undoStack
	var stateArray = new Array(command, states, selection.store())
	this.undoStack.push(stateArray);
	this.undoCounter = this.undoStack.length - 1;
	
	return true;
}



/** Mozile - Restore State -
 * Replaces the contents of all editors in the document with their states as recoreded at a given index of the undoStack.
 * 
 * @param index. The index from the undoStack to be restored.
 * @return True if successful.
 */
MozileMediator.prototype.restoreState = function(index) {
	var f = new Array();
	f["File"] = "UndoRedo/UndoRedo.js";
	f["Function"] = "Mozile.restoreState()";
	this.debug(f,1,"Restoring state "+ index);
	
	var command = this.undoStack[index][0];
	var states = this.undoStack[index][1];
	var selection = this.undoStack[index][2];
	
	//dumpArray(states);
	
	var i,j=0;
	var editor, editorCopy;
	for(j=0; j<states.length; j++) {
		editor = states[j][0];
		editorCopy = states[j][1];
		
		// Remove all children of the editor element.
		while(editor.childNodes.length) {
			editor.removeChild(editor.firstChild);
		}
		
		// Append a clone of each child of the editorCopy.
		var children = editorCopy.childNodes;
		for(i=0; i<children.length; i++) {
			editor.appendChild(children[i].cloneNode(true));
		}
	}
	
	// Restore the selection.
	window.getSelection().restore(selection);
	window.getSelection().collapseToEnd();
	
	return true;
}



/**
 * Initialize the module.
 * @type Void
 */
mozile.getModule("UndoRedo").init = function() {
	var mozileUndo = mozile.getCommandList().createCommand("MozileCommand: id=Mozile-Undo, label=Undo, tooltip='Undo the previous action', accelerator='Command-Z', image='"+mozile.getRoot()+"images/undo.png'");
	mozileUndo.execute = function() {
		if(mozile.undoCounter <= 0) {
			//alert("Nothing to Undo!");
			return false;
		}
		else {
			mozile.undoCounter--;
			mozile.restoreState(mozile.undoCounter);
			return true;
		}
	}
	var mozileRedo = mozile.getCommandList().createCommand("MozileCommand: id=Mozile-Redo, label=Redo, tooltip='Redo the next action', accelerator='Command-Shift-Z', image='"+mozile.getRoot()+"images/redo.png'");
	mozileRedo.execute = function() {
		if(mozile.undoCounter >= mozile.undoStack.length - 1) {
			//alert("Nothing to Redo!");
			return false;
		}
		else {
			mozile.undoCounter++;
			mozile.restoreState(mozile.undoCounter);
			return true;
		}
	}
	
	mozile.getCommandList().createCommand("MozileCommandSeparator: id=Mozile-UndoSeparator");
}

