// Copyright (C) 2006 The Mozile Team. See http://mozile.mozdev.org/ for details.

MozileMediator.prototype.getSaveModules=function(){if(!this._saveModules){this._saveModules=new Object();var dialog=new MozileModule("Dialog");dialog.setOption("label","Save to Dialog");dialog.save=function(){mozile.getSourceInterface().show();}
this.addSaveModule(dialog);this.setDefaultSaveModule(dialog);this.setSaveOption("default","content",mozile.getOption("content"));this.setSaveOption("default","format",mozile.getMode());}
return this._saveModules;}
MozileMediator.prototype.getSaveModule=function(name){if(this.getSaveModules()[name])return this.getSaveModules()[name];else return undefined;}
MozileMediator.prototype.getSaveOption=function(mode,key,defaultValue){if(!this._saveOptions)this._saveOptions=new Object();if(mode=="default"||mode=="custom"){if(!this._saveOptions[mode])this._saveOptions[mode]=new Object();if(this._saveOptions[mode][key]!=undefined)return this._saveOptions[mode][key];else if(defaultValue!=undefined)return this.setSaveOption(mode,key,defaultValue);else if(this._saveOptions[mode]["module"]&&this._saveOptions[mode]["module"].getOption(key)!=undefined)
return this._saveOptions[mode]["module"].getOption(key);else return this.getOption(key);}
else if(mode=="current"){if(this.getSaveOption("custom",key)!=undefined)return this.getSaveOption("custom",key);else if(this.getSaveOption("default",key)!=undefined)return this.getSaveOption("default",key);else if(defaultValue!=undefined)return this.setSaveOption("custom",key,defaultValue);else return undefined;}
else throw Error("Invalid save mode");}
MozileMediator.prototype.setSaveOption=function(mode,key,value){if(!this._saveOptions)this._saveOptions=new Object();if(mode=="default"||mode=="custom"){if(!this._saveOptions[mode])this._saveOptions[mode]=new Object();this._saveOptions[mode][key]=value;return value;}
else if(mode=="current"){if(this._saveOptions["custom"])return this.setSaveOption("custom",key,value);else return this.setSaveOption("default",key,value);}
else throw Error("Invalid save mode");}
MozileMediator.prototype.useDefaultSaveOptions=function(){if(this._saveOptions["custom"])this._saveOptions["custom"]=null;}
MozileMediator.prototype.setDefaultSaveModule=function(module){this.setSaveOption("default","module",module);return module;}
MozileMediator.prototype.setCustomSaveModule=function(module){this.setSaveOption("custom","module",module);return module;}
MozileMediator.prototype.addSaveModule=function(module){if(module.getName())this.getSaveModules()[module.getName()]=module;else throw Error("Invalid module.");return module;}
MozileMediator.prototype.getCommands=function(){if(!this._commands)this._commands=new Object();return this._commands;}
MozileMediator.prototype.getCommand=function(id){if(this.getCommands()[id])return this.getCommands()[id];else return undefined;}
MozileMediator.prototype.addCommand=function(command){if(command.getId())this.getCommands()[command.getId()]=command;else throw Error("Invalid command.");return command;}
MozileMediator.prototype.getAccelerators=function(){if(!this._accelerators)this._accelerators=new Object();return this._accelerators;}
MozileMediator.prototype.getAccelerator=function(accel){if(this.getAccelerators()[accel])return this.getAccelerators()[accel];else return undefined;}
MozileMediator.prototype.addAccelerator=function(accel,command){this.getAccelerators()[accel]=command;return command;}
MozileMediator.prototype.getAboutInterface=function(){if(!this._aboutInterface){this._aboutInterface=new MozileInterface(this.getRoot()+"core/about.xml","MozileAboutInterface: width=450px");this._aboutInterface.init=function(){document.getElementById("mozileVersion").value=mozile.getVersion();}}
return this._aboutInterface;}
MozileMediator.prototype.getSaveInterface=function(){if(!this._saveInterface){this._saveInterface=new MozileInterface(this.getRoot()+"core/save.xml","MozileSaveInterface: width=330px");this._saveInterface.init=function(){this.savePreset=document.getElementById("mozileSavePresetList");this.saveContent=document.getElementById("mozileSaveContentList");this.saveFormat=document.getElementById("mozileSaveFormatList");this.saveMethod=document.getElementById("mozileSaveMethodList");while(this.saveMethod.length){this.saveMethod.removeChild(this.saveMethod.firstChild);}
var option;for(key in mozile.getSaveModules()){option=document.createElement("option");option.setAttribute("value",mozile.getSaveModule(key).getName());option.appendChild(document.createTextNode(mozile.getSaveModule(key).getOption("label")));this.saveMethod.appendChild(option);}
this.restore("current");}
this._saveInterface.methodFields=function(){var urlBox=document.getElementById("mozileSaveURLBox");var url=document.getElementById("mozileSaveToURL");if(mozile.getSaveModule(this.saveMethod.value).getOption("showURL")){urlBox.collapsed=false;if(url.value==""||url.value=="undefined")url.value=mozile.getSaveModule(this.saveMethod.value).getOption("url");}
else urlBox.collapsed=true;}
this._saveInterface.restore=function(mode){if(mode==undefined)mode=this.savePreset.value;try{this.saveMethod.value=mozile.getSaveOption(mode,"module").getName();this.saveContent.value=mozile.getSaveOption(mode,"content");this.saveFormat.value=mozile.getSaveOption(mode,"format");document.getElementById("mozileSaveToURL").value=mozile.getSaveOption(mode,"url");}
catch(e){}
this.methodFields();}
this._saveInterface.changed=function(){this.methodFields();this.storeCustom();this.savePreset.value="custom";}
this._saveInterface.done=function(){if(this.savePreset.value=="default"){mozile.useDefaultSaveOptions();}
else{this.storeCustom();}
this.hide();mozile.setSaveOption("current","prompt",true);mozile.getSaveOption("current","module").save();mozile.changesSaved=true;}
this._saveInterface.storeCustom=function(){mozile.setCustomSaveModule(mozile.getSaveModule(this.saveMethod.value));mozile.setSaveOption("custom","content",this.saveContent.value);mozile.setSaveOption("custom","format",this.saveFormat.value);if(mozile.getSaveModule(this.saveMethod.value).getOption("showURL")){mozile.setSaveOption("custom","url",document.getElementById("mozileSaveToURL").value);}}}
return this._saveInterface;}
MozileMediator.prototype.getSourceInterface=function(){if(!this._sourceInterface){this._sourceInterface=new MozileInterface(this.getRoot()+"core/source.xml","MozileSourceInterface: width=80%");this._sourceInterface.init=function(){document.getElementById("mozileSourceContent").value=mozile.getSaveOption("current","content");document.getElementById("mozileSourceFormat").value=mozile.getSaveOption("current","format");document.getElementById("mozileSourceText").value=mozile.content();}
this._sourceInterface.update=function(){var content=document.getElementById("mozileSourceContent").value;var format=document.getElementById("mozileSourceFormat").value;if(format=="XHTML")format="XML";var text=eval("mozile."+content+"To"+format+"()");if(text)document.getElementById("mozileSourceText").value=text;}}
return this._sourceInterface;}
MozileMediator.prototype.getMessageInterface=function(){if(!this._messageInterface){this._messageInterface=new MozileInterface(this.getRoot()+"core/message.xml","MozileMessageInterface: width=80%");this._messageInterface.init=function(){document.getElementById("mozileVersion").value=mozile.getVersion();}
this._messageInterface.init=function(){this.reset();}
this._messageInterface.reset=function(){document.getElementById("mozileFilterText").value="";document.getElementById("mozileFilterLevel").selectedIndex=0;this.filter();}
this._messageInterface.clear=function(){mozileDebugList=new Array();this.reset();}
this._messageInterface.filter=function(){var selected=document.getElementById("mozileFilterLevel").value;var text=document.getElementById("mozileFilterText").value;var vbox=document.getElementById("mozileMessageBox");while(vbox.childNodes.length){vbox.removeChild(vbox.firstChild);}
var count=0;for(var i=0;i<mozileDebugList.length;i++){var bug=mozileDebugList[i];if(selected=="status"&&!bug[1]["Status Message"])continue;if(selected>bug[2])continue;var pattern=new RegExp(text,"i");var search=pattern.test(bug[0])&&pattern.test(bug[1]["File"])&&pattern.test(bug[1]["Function"])&&pattern.test(bug[3]);if(pattern.test(bug[0])||pattern.test(bug[1]["File"])||pattern.test(bug[1]["Function"])||pattern.test(bug[3])){count++;vbox.appendChild(this.entry(mozileDebugList[i]));}}
document.getElementById("mozileMessageCount").value="Showing "+count+" of "+mozileDebugList.length+" Messages";}
this._messageInterface.entry=function(bug){var hbox=document.createElementNS(XULNS,"hbox");hbox.setAttribute("class","level"+bug[2]);hbox.setAttribute("align","center");var datestamp=document.createElementNS(XULNS,"description");datestamp.setAttribute("class","datestamp");datestamp.setAttribute("value",bug[0]);hbox.appendChild(datestamp);var button=document.createElementNS(XULNS,"button");button.setAttribute("class","functionButton");button.setAttribute("type","menu");button.setAttribute("image",mozile.getRoot()+"images/info.png");var menupopup=document.createElementNS(XULNS,"menupopup");var functions;for(key in bug[1]){functions=document.createElementNS(XULNS,"description");functions.setAttribute("class","functions");functions.appendChild(document.createTextNode(key+" = "+bug[1][key]));menupopup.appendChild(functions);}
functions=document.createElementNS(XULNS,"description");functions.setAttribute("class","functions");functions.appendChild(document.createTextNode("Level = "+bug[2]));menupopup.appendChild(functions);button.appendChild(menupopup);hbox.appendChild(button);var message=document.createElementNS(XULNS,"description");message.setAttribute("class","message");message.appendChild(document.createTextNode(bug[3]));hbox.appendChild(message);return hbox;}}
return this._messageInterface;}
MozileMediator.prototype.getCommandList=function(){if(!this._commandList){this._commandList=new MozileCommandList("MozileCommandList: id=Mozile-RootList, label='Mozile Root List'");var mozileList=this._commandList.createCommand("MozileCommandList: id=Mozile-firstList, label='Mozile First List', image='"+this.getRoot()+"images/Mozile-20.png', buttonPosition=0, menuPosition=0");var about=mozileList.createCommand("MozileCommand: id=Mozile-About, label='About Mozile'");about.execute=function(event){mozile.getAboutInterface().show();}
var accel=mozileList.createCommand("MozileCommand: id=Mozile-Accelerators, label='Keyboard Shortcuts'");accel.execute=function(event){if(mozile.getOption("keyboardShortcuts")){var message="Mozile defines the following keyboard shortcuts:";var accels=mozile.getAccelerators();for(key in accels){message=message+"\n"+mozile.getAccelerator(key).getOption("label")+" => "+key;}
alert(message);}
else{alert("Mozile keyboard shortcuts have been turned off.");}}
var debug=mozileList.createCommand("MozileCommand: id=Mozile-Debug, label=Debug");debug.execute=function(event){mozile.getMessageInterface().show();}
var report=mozileList.createCommand("MozileCommand: id=Mozile-ReportBugs, label='Report a Bug'");report.execute=function(event){window.open("http://mozile.mozdev.org/bugs.html","Mozile Bugs","");}
var home=mozileList.createCommand("MozileCommand: id=Mozile-Home, label='Mozile Home'");home.execute=function(event){window.open("http://mozile.mozdev.org","Mozile Home","");}
var help=mozileList.createCommand("MozileCommand: id=Mozile-Help, label='Help'");help.execute=function(event){window.open(mozile.getRoot()+"docs/index.html","Mozile Help","");}
var save=this._commandList.createCommand("MozileCommand: id=Mozile-Save, label=Save, tooltip='Save to a dialog', accelerator='Command-S', image='"+this.getRoot()+"images/filesave.png'");save.execute=function(event){mozile.save();}
var saveAs=this._commandList.createCommand("MozileCommand: id=Mozile-SaveAs, label='Save As', tooltip='Save as...', accelerator='Command-Shift-S', image='"+this.getRoot()+"images/filesaveas.png'");saveAs.execute=function(event){mozile.saveAs();}
this._commandList.createCommand("MozileCommandSeparator: id=Mozile-RootSeparator");}
return this._commandList;}
MozileMediator.prototype.getToolbar=function(){if(this.isExtension())return null;if(!this._toolbar){var link=new MozileLinkResource("Mozile-Core-interface.css",this.getRoot()+"core/interface.css")
link.load();var rule;if(document.documentElement.tagName.toLowerCase()=="html"){rule="body { -moz-binding: url("+this.getRoot()+"core/interface.xml#toolbar); }";}
else{rule="mozileToolbar { -moz-binding: url("+this.getRoot()+"core/interface.xml#toolbar); }";document.documentElement.insertBefore(document.createElement("mozileToolbar"),document.documentElement.firstChild);}
this.getStyleSheet().insertRule(rule,this.getStyleSheet().cssRules.length);return null;}
else return this._toolbar;}
MozileMediator.prototype.getStatusbar=function(){if(!this._statusbar){this.getToolbar();return null;}
return this._statusbar;}
MozileMediator.prototype.hideToolbar=function(){var f=new Array();f["File"]="core/interface.js";f["Function"]="Mozile.hideToolbar()";if(this.isExtension())return;if(!this.isEditable())return;if(this.getToolbar()==null)return;this.getToolbar().collapsed=true;this.getStatusbar().collapsed=true;if(this._toolbarInterval)window.clearInterval(this._toolbarInterval);}
MozileMediator.prototype.showToolbar=function(){var f=new Array();f["File"]="core/interface.js";f["Function"]="Mozile.showToolbar()";if(this.isExtension())return false;if(!this.isEditable())return false;if(this._firstToolbarShow){if(mozile.getToolbar()==null){return false;}
if(this.getOption("toolbarPosition")=="absolute"){this.getToolbar().style.position="absolute";this.getStatusbar().style.position="absolute";}
this.getToolbar().appendChild(this.getCommandList().getBox());this.storeState("Initial state");this._firstToolbarShow=false;}
if(this.getOption("toolbarUpdateFrequency")==2){this._toolbarInterval=window.setInterval("mozile.moveToolbar()",mozile.getOption("defaultInterval"));}
this.getToolbar().collapsed=false;this.getStatusbar().collapsed=false;this.moveToolbar();return true;}
MozileMediator.prototype.moveToolbar=function(){var f=new Array();f["File"]="core/interface.js";f["Function"]="Mozile.moveToolbar()";if(this.isExtension())return false;if(!this.isEditable())return false;if(this.getToolbar()==null)return false;if(!this.lastWindowSize){this.lastWindowSize=new Array();}
else{if(this.lastWindowSize["innerWidth"]==window.innerWidth&&this.lastWindowSize["innerHeight"]==window.innerHeight&&this.lastWindowSize["pageXOffset"]==window.pageXOffset&&this.lastWindowSize["pageYOffset"]==window.pageYOffset&&this.lastWindowSize["toolbarWidth"]==this.getToolbar().boxObject.width){return true;}}
this.getToolbar().style.left="0px";if(window.innerWidth-this.getToolbar().boxObject.width>=0){this.getToolbar().style.left=(window.innerWidth-this.getToolbar().boxObject.width)/2+"px";}
else{this.getToolbar().style.left="0px";}
if(window.innerWidth-this.getStatusbar().boxObject.width>=0){this.getStatusbar().style.left=(window.innerWidth-this.getStatusbar().boxObject.width)/2+"px";}
else{this.getStatusbar().style.left="0px";}
if(this.getToolbar().style.position=="absolute"){this.getToolbar().style.top=window.pageYOffset-1+"px";this.getStatusbar().style.top=window.pageYOffset+window.innerHeight-this.getStatusbar().boxObject.height+1+"px";}
this.lastWindowSize["innerWidth"]=window.innerWidth;this.lastWindowSize["innerHeight"]=window.innerHeight;this.lastWindowSize["pageXOffset"]=window.pageXOffset;this.lastWindowSize["pageYOffset"]=window.pageYOffset;this.lastWindowSize["toolbarWidth"]=this.getToolbar().boxObject.width;return true;}
MozileMediator.prototype.updateToolbar=function(){var f=new Array();f["File"]="core/interface.js";f["Function"]="Mozile.updateToolbar()";if(this.isExtension())return false;if(!this.isEditable())return false;if(this.getOption("toolbarUpdateFrequency")==0)return true;var force=false;if(arguments.length>0){force=arguments[0];}
var selection=mozile.getSelection();if(!force){if(selection.focusNode==this._lastFocusNode){return true;}}
this._lastFocusNode=selection.focusNode;for(var id in this.getCommands()){try{this.getCommand(id).update();}catch(e){}}
this.moveToolbar();return true;}
MozileMediator.prototype.save=function(){this.setSaveOption("current","prompt",false);this.getSaveOption("current","module").save();this.changesSaved=true;}
MozileMediator.prototype.saveAs=function(){mozile.getSaveInterface().show();}
MozileMediator.prototype.executeCommand=function(id,event){var f=new Array();f["File"]="core/interface.js";f["Function"]="Mozile.executeCommand()";var cleanId=/(.*)(\-Button|\-Menuitem)$/;var result=cleanId.exec(id);var commandId;if(result)commandId=result[1];else commandId=id;if(!this.getCommand(commandId))return false;else{var command=this.getCommand(commandId);if(this.keyCounter!=0)this.storeState(command);result=command.execute(event);if(result&&command.getId()!="Mozile-Undo"&&command.getId()!="Mozile-Redo")this.storeState(command);this.updateToolbar(true);return true;}}
function MozileCommand(configString){this._configString=String(configString);}
MozileCommand.prototype=new MozileComponent;MozileCommand.prototype.constructor=MozileCommand;MozileCommand.prototype.getId=function(){if(!this.getOption("id"))throw Error("Invalid configuration string.");return this.getOption("id");}
MozileCommand.prototype.getButton=function(){if(!this._button)this._createButton();return this._button;}
MozileCommand.prototype.getMenuitem=function(){if(!this._menuitem)this._createMenuitem();return this._menuitem;}
MozileCommand.prototype.isActive=function(){return false;}
MozileCommand.prototype.update=function(){var active=this.isActive();this.getButton().setAttribute("active",active);this.getMenuitem().setAttribute("checked",active);}
MozileCommand.prototype.execute=function(event){alert("Command "+this.getId()+" executed by event "+event);}
MozileCommand.prototype._createButton=function(){this._button=document.createElementNS(XULNS,"toolbarbutton");this._button.setAttribute("id",this.getId()+"-Button");this._button.setAttribute("class","mozileButton");this._button.setAttribute("image",this.getOption("image"));this._button.setAttribute("label",this.getOption("label"));if(this.getOption("tooltip"))this._button.setAttribute("tooltiptext",this.getOption("tooltip"));return this._button;}
MozileCommand.prototype._createMenuitem=function(){this._menuitem=document.createElementNS(XULNS,"menuitem");this._menuitem.setAttribute("id",this.getId()+"-Menuitem");this._menuitem.setAttribute("class","mozileMenuitem");this._menuitem.setAttribute("label",this.getOption("label"));if(this.getOption("tooltip"))this._menuitem.setAttribute("tooltiptext",this.getOption("tooltip"));if(this.getOption("accesskey"))this._menuitem.setAttribute("accesskey",this.getOption("accesskey"));return this._menuitem;}
function MozileCommandSeparator(configString){this._configString=String(configString);}
MozileCommandSeparator.prototype=new MozileCommand();MozileCommandSeparator.prototype.constructor=MozileCommandSeparator;MozileCommandSeparator.prototype.update=function(){}
MozileCommandSeparator.prototype._createButton=function(){this._button=document.createElementNS(XULNS,"separator");this._button.setAttribute("id",this.getId()+"-Separator");this._button.setAttribute("class","mozileSeparator");return this._button;}
MozileCommandSeparator.prototype._createMenuitem=function(){this._menuitem=document.createElementNS(XULNS,"menuseparator");this._menuitem.setAttribute("id",this.getId()+"-Menuseparator");this._menuitem.setAttribute("class","mozileMenuseparator");return this._menuitem;}
function MozileCommandList(configString){this._configString=String(configString);this._buttonArray=new Array();this._menuArray=new Array();}
MozileCommandList.prototype=new MozileCommand;MozileCommandList.prototype.constructor=MozileCommandList;MozileCommandList.prototype.getMenuitem=function(){return this.getMenu();}
MozileCommandList.prototype.getBox=function(){if(!this._box)this._createBox();return this._box;}
MozileCommandList.prototype.getMenu=function(){if(!this._menu)this._createMenu();return this._menu;}
MozileCommandList.prototype.getCommands=function(){if(!this._commands)this._commands=new Object;return this._commands;}
MozileCommandList.prototype.getCommand=function(id){if(this.getCommands()[id])return this.getCommands()[id];else return undefined;}
MozileCommandList.prototype.addCommand=function(command){if(command.getId())this.getCommands()[command.getId()]=command;else throw Error("Invalid command.");return command;}
MozileCommandList.prototype._getMenupopup=function(){if(!this._menupopup)this._createMenupopup();return this._menupopup;}
MozileCommandList.prototype.update=function(){for(var command in this.getCommands()){if(typeof(command)=="Object")command.update();}}
MozileCommandList.prototype.execute=function(event){}
MozileCommandList.prototype.createCommand=function(configString){var firstWord=/\s*(\w*)/;var name=firstWord.exec(configString)[1];if(!name)throw Error("Invalid configuration string.");var command=eval("new "+name+"(configString)");try{command.getId();}
catch(e){return undefined;}
this.addCommand(command);mozile.addCommand(command);if(command.getOption("accelerator")){var accel=command.getOption("accelerator");if(mozile.getOperatingSystem()=="Mac"){accel=accel.replace("Command","Meta");}
else{accel=accel.replace("Command","Control");}
mozile.addAccelerator(accel,command);}
var position=command.getOption("buttonPosition");if(position==undefined)this._buttonArray.push(command);else{if(this._buttonArray[position]==null)this._buttonArray[position]=command;else this._buttonArray.splice(position,0,command);}
position=command.getOption("menuPosition");if(position==undefined)this._menuArray.push(command);else{if(this._menuArray[position]==null)this._menuArray[position]=command;else this._menuArray.splice(position,0,command);}
return command;}
MozileCommandList.prototype._createButton=function(){this._button=document.createElementNS(XULNS,"toolbarbutton");this._button.setAttribute("id",this.getId()+"-Button");this._button.setAttribute("class","mozileButton");this._button.setAttribute("image",this.getOption("image"));this._button.setAttribute("label",this.getOption("label"));if(this.getOption("tooltip"))this._button.setAttribute("tooltiptext",this.getOption("tooltip"));this._button.setAttribute("type","menu");this._button.appendChild(this._getMenupopup());return this._button;}
MozileCommandList.prototype._createMenuitem=function(){return this.getMenu();}
MozileCommandList.prototype._createBox=function(){this._box=document.createElementNS(XHTMLNS,"div");this._box.setAttribute("id",this.getId()+"-Box");this._box.setAttribute("class","mozileBox");this._box.setAttribute("label",this.getOption("label"));if(this.getOption("tooltip"))this._box.setAttribute("tooltiptext",this.getOption("tooltip"));for(var i=0;i<this._buttonArray.length;i++){if(this._buttonArray[i]){this._box.appendChild(this._buttonArray[i].getButton());}}
return this._box;}
MozileCommandList.prototype._createMenu=function(){this._menu=document.createElementNS(XULNS,"menu");this._menu.setAttribute("id",this.getId()+"-Menu");this._menu.setAttribute("class","mozileMenu");this._menu.setAttribute("label",this.getOption("label"));if(this.getOption("tooltip"))this._menu.setAttribute("tooltiptext",this.getOption("tooltip"));if(this.getOption("accesskey"))this._menu.setAttribute("accesskey",this.getOption("accesskey"));this._menu.appendChild(this._getMenupopup());return this._menu;}
MozileCommandList.prototype._createMenupopup=function(){this._menupopup=document.createElementNS(XULNS,"menupopup");for(var i=0;i<this._menuArray.length;i++){if(this._menuArray[i]){this._menupopup.appendChild(this._menuArray[i].getMenuitem());}}
return this._menupopup;}
function MozileInterface(element,configString){if(!element)throw Error("Invalid element.");this._element=element;this._configString=String(configString);}
MozileInterface.prototype=new MozileComponent;MozileInterface.prototype.constructor=MozileInterface;MozileInterface.prototype.getElement=function(){if(!this._element||typeof(this._element)==typeof("")){if(mozileScriptSource.match("^chrome://")){try{this._element=document.getElementById(this.getName());this._element.collapsed=false;this._element.parentNode.removeChild(this._element);}
catch(e){throw Error("Failed to find preloaded interface with id '"+this.getName()+"'\n"+e);}}
else{try{this._url=this._element;var xmlDoc=document.implementation.createDocument("","",null);xmlDoc.async=false;var loaded=xmlDoc.load(this._url);if(!loaded)throw Error("Could not load interface.");this._element=document.importNode(xmlDoc.documentElement,true);}
catch(e){throw Error("Failed to load external interface at "+this._element+"\n"+e);}}}
return this._element;}
MozileInterface.prototype.getParent=function(){if(!this._parent){if(document.documentElement.tagName.toLowerCase()=="html")this._parent=document.getElementsByTagName("body")[0];else this._parent=document.documentElement;}
return this._parent;}
var mozileCurrentInterface;MozileInterface.prototype.show=function(){if(this.getElement().parentNode&&this.getElement().parentNode==this.getParent())return;try{if(this._nextSibling){this.getParent().insertBefore(this.getElement(),this._nextSibling);}
else{this.getParent().appendChild(this.getElement());}}
catch(e){}
this.getElement().position="fixed";if(mozileCurrentInterface)mozileCurrentInterface.hide();mozileCurrentInterface=this;if(!this._interval)this._interval=window.setInterval("mozileCurrentInterface.center()",mozile.getOption("defaultInterval"));this.init();}
MozileInterface.prototype.hide=function(){if(!this.getElement().parentNode)return;this._nextSibling=this.getElement().nextSibling;this.getParent().removeChild(this.getElement());mozileCurrentInterface=undefined;if(this._interval){window.clearInterval(this._interval);this._interval=undefined;}}
MozileInterface.prototype.center=function(){var options=["width","height","top","left","right","bottom"];for(var i=0;i<options.length;i++){if(this.getOption(options[i])){this.getElement().style[options[i]]=this.getOption(options[i]);}}
try{if(this.getElement().boxObject){var left=(window.innerWidth-this.getElement().boxObject.width)/window.innerWidth*50;if(left>0)this.getElement().style.left=left+"%";var top=(window.innerHeight-this.getElement().boxObject.height)/window.innerHeight*50;if(top>0)this.getElement().style.top=top+"%";}}catch(e){}}
MozileInterface.prototype.init=function(){}
mozile.getToolbar();