/** Mozile Component Test Script
 * @fileoverview This file contains JSUnit test functions for testing the MozileMediator object.
 * Requires MozileComponentUtils.js
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


var name = "MozileMediator";
var root = "/this/root/";
var warnBeforeUnload = false;
var configString = name+": root='"+root+"', warnBeforeUnload="+warnBeforeUnload;

/** Test - Constructor
 * Test the constructor and basic methods.
 */
function testConstructor() {
	var component = mozile;
	checkComponentBasics(component);
	checkMediatorBasics(component);
}


/** Test - Options
 * Test getting and setting options.
 */
function testOptions() {
	var component = mozile;
	checkOptions(component);
}




/** Test - Check Mediator Basics
 * Check basic getting methods.
 */
function checkMediatorBasics(component) {
	assertEquals("root should be '../../'", "../../", component.getRoot());
	assertEquals("mode should be 'XHTML'", "XHTML", component.getMode());
	assertEquals("debugLevel should be 5", 5, component.getDebugLevel());

	var methods = [
		["Resource", new MozileResource("script", "test"), "test"], 
		["Module", new MozileModule("Test"), "Test"], 
		["SaveModule", new MozileModule("SaveTest"), "SaveTest"], 
		["Command", new MozileCommand("Test: id=test"), "test"], 
	];
	var method, object, name;
	for(var m=0; m < methods.length; m++) {
		method = methods[m][0];
		object = methods[m][1];
		name = methods[m][2];
		assertNotNull("get"+method+"s() should not be null", component["get"+method+"s"]());
		assertNotUndefined("get"+method+"s() should be defined.", component["get"+method+"s"]());
		assertEquals("get"+method+"s() should return an object.", "[object Object]", component["get"+method+"s"]().toString());
		
		assertUndefined("No object should be returned by get"+method+"('"+name+"')", component["get"+method](name));
		assertEquals("The added object should be returned by add"+method+"()", object, component["add"+method](object));
		assertEquals("The object should be returned by get"+method+"('"+name+"')", object, component["get"+method](name));
		
	}

		// Accelerators
	assertNotNull("getAccelerators() should not be null", component.getAccelerators());
	assertNotUndefined("getAccelerators() should be defined.", component.getAccelerators());
	assertEquals("getAccelerators() should return an object.", "[object Object]", component.getAccelerators().toString());
	
	object = new MozileCommand("Test: id=test2, accel=Command-T");		
	assertUndefined("No object should be returned by getAccelerator('Command-T')", component.getAccelerator("Command-T"));
	assertEquals("The added object should be returned by add"+method+"()", object, component.addAccelerator("Command-T",object));
	assertEquals("The object should be returned by getAccelerator('Command-T')", object, component.getAccelerator("Command-T"));

	//	Test getEditors
	
	assertNotNull("getStyleSheet() should not be null", component.getOptions());
	assertNotUndefined("getStyleSheet() should be defined.", component.getOptions());
	assertEquals("getStyleSheet() should be a CSSStyleObject.", "[object CSSStyleSheet]", component.getStyleSheet().toString());
}
