/** Mozile Command Test Script
 * @fileoverview This file contains JSUnit test functions for testing the MozileCommand object.
 * Requires MozileCommandUtils.js, MozileComponentUtils.js
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


var name = "DummyCommand";
var id = "Mozile-TestCommand";
var label = "Test";
var tooltip = "Test Command";
var accelerator = "Command-T";
var accesskey = "T";
var image = "images/test.png";

var configString = name+": id="+id+", label="+label+", tooltip='"+tooltip+"', accesskey="+accesskey+", accelerator='"+accelerator+"', image='"+image+"'";


/** Test - Constructor
 * Test the constructor and basic methods.
 */
function testConstructor() {
	var component = new MozileCommand(name);
	checkComponentBasics(component);
}


/** Test - Command
 * Create a command and make sure it's working
 */
function testCommand() {
	var component = new MozileCommand(configString);
	checkComponentBasics(component);
	checkCommandOptions(component);
	checkOptions(component);
}


/** Test - Elements
 * Create a command and make sure it's working
 */
function testElements() {
	var component = new MozileCommand(configString);
	checkComponentBasics(component);

	checkButton(component.getButton());
	checkMenuitem(component.getMenuitem());
}


