/** Mozile Initialization Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's toolbar methods.
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


/** Test - Create Toolbar
 * Create the toolbar, and make sure that everything has succeeded. This involves inserting a link to an external CSS file, creating a new style element, finding the stylesheet object for this new style element, and adding CSS rules to the new stylesheet.
 */
function testCreateToolbar() {
	mozile.createToolbar();
	
	// Check for the external stylesheet.
	var interfaceSheet = document.getElementById("Mozile-Core-interface.css");
	assertNotNull("The interfaceSheet should exist.", interfaceSheet);
	assertNotUndefined("The interfaceSheet should be defined.", interfaceSheet);
	
	// Check for the internal style element.
	var style = document.getElementById("Mozile-Core-StyleSheet");
	assertNotNull("The style element should exist.", style);
	assertNotUndefined("The style element should be defined.", style);

	// Find the stylesheet object for the new style element.
	var sheets = document.styleSheets;
	var sheet;
	for(var i=0; i < sheets.length; i++) {
		if(sheets.item(i).ownerNode == style) {
			sheet = sheets.item(i);
			break;
		}
	}
	assertNotUndefined("The sheet should be defined.", sheet);

	// Make sure that Mozile has also found this stylesheet object.	
	assertNotNull("The mozile.styleSheet should be defined.", mozile.styleSheet);
	assertNotUndefined("The mozile.styleSheet should be defined.", mozile.styleSheet);

	// Make sure that only four rules have been added to this stylesheet object.
	assertEquals("There should be four rules", 4, mozile.styleSheet.cssRules.length);
	
	// Make sure that it's the right rule.
	var rule = mozile.styleSheet.cssRules[0];
	var text;
	if(document.documentElement.nodeName.toLowerCase()=="html") {
		text = "body { -moz-binding: url(" + mozile.root +"core/interface.xml#toolbar); }"
	}
	else {
		text = "moziletoolbar { -moz-binding: url(" + mozile.root +"core/interface.xml#toolbar); }"
	}
	assertEquals("The rule's text should be "+ text, text, rule.cssText);

}
