/** Mozile Link Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's script loading and unloading methods. 
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


/** Test - Load Script
 * Compare how many script tags there are in this page before and after the Mozile.loadScript() method is called.
 */
function loadScript() {
	var scripts1 = document.getElementsByTagName("script").length;
	//alert("Before LS:" + document.getElementsByTagName("script").length);
	mozile.loadScript("dummy.js","Mozile-Test-dummy.js");
	var scripts2 = document.getElementsByTagName("script").length;
	//alert("After LS: "+ document.getElementsByTagName("script").length);
	assertEquals("There should be one more script now.", scripts1+1, scripts2);

	var scripts = document.getElementsByTagName("script");
	var dummies = 0;
	for(i=0;i<scripts.length;i++) {
		if(scripts[i].getAttribute("src") == "dummy.js") dummies++;
	}
	assertEquals("There should be one dummy script element.",1,dummies);

}


/** Test - Unload Script
 * Compare how many script tags there are in this page before and after the Mozile.unloadScript() method is called.
 */
function unloadScript() {
	var scripts1 = document.getElementsByTagName("script").length;
	mozile.unloadScript("Mozile-Test-dummy.js");
	var scripts2 = document.getElementsByTagName("script").length;
	assertEquals("There should be one script fewer now.", scripts1-1, scripts2);

	var scripts = document.getElementsByTagName("script");
	var dummies = 0;
	for(i=0;i<scripts.length;i++) {
		if(scripts[i].getAttribute("src") == "dummies.js") dummies++;
	}
	
	assertEquals("There should be no dummy script elements.",0,dummies);
}

function testScripts() {
	loadScript();
	unloadScript();
}