/** Mozile Initialization Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's toolbar methods.
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */

var iterations;
if(!iterations) iterations = 100;


function formatNumber(value, places) {
	for(i=1; i < places; i++) {
		if( parseInt(value) < Math.pow(10,i) ) {
			value = "0" + value;
		}
	}
	return value;
}



function deleteTest(i) {
	// Get start time
	var startTime = new Date();
	
	var testString = "This is a test, using     real words."
	
	var event = document.createEvent("KeyEvents");
	//void initKeyEvent ( String typeArg , boolean canBubbleArg , boolean cancelableArg , AbstractView viewArg , boolean ctrlKeyArg , boolean altKeyArg , boolean shiftKeyArg , boolean metkeyArg , int keyCodeArg , int charCodeArg )
	event.initKeyEvent("keypress", true, true, null, false, false, false, false,  event.DOM_VK_BACK_SPACE, 33);
	
	// Run the test
	for(j=0; j < i; j++) {
		mozile.insertString(testString);
		for(k=0; k < testString.length; k++) {
			mozileHandleKeypress(event);
			//mozile.deletion("previous");
		}
	}
	
	// Get time difference
	var endTime = new Date();
	var timeDiff = endTime.getTime() - startTime.getTime();
	var delta = new Date(timeDiff);
	
	// Format result
	var result = "Delete Test: ";
	result += formatNumber(delta.getMinutes(), 2) +":";
	result += formatNumber(delta.getSeconds(), 2) +".";
	result += formatNumber(delta.getMilliseconds(), 3);
	
	return result;
}



// Run these functions
var selection = window.getSelection();
var range = document.createRange();
var target = document.getElementById("target");

range.setStart(target.firstChild, 12);
//range.setEnd(target.firstChild, 10);
range.collapse(true);
selection.removeAllRanges();
selection.addRange(range);

var prompt = prompt("Mozile Performance tests.\nHow many iterations?", iterations);
if(prompt && parseInt(prompt) ) {
	var results = "Test Results\n("+ prompt +" Iterations)\n\n";
	results += deleteTest(prompt);
	
	// Show results
	alert(results);
	window.close();
}
else {
	window.close();
}


