/** Mozile Module Test Script 5
 * @fileoverview This file contains JSUnit test functions for testing Mozile's module loading and unloading methods. It is the third of three such scripts, and it must be run after the first two scripts have completed.
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


/** Test - Loaded 2
 * Test Module 2 should be completely loaded now, so make sure that it is.
 */
function loaded2() {
	assertNotNull("The testModule2Loaded variable should exist", testModule2Loaded);
	assertNotUndefined("The testModule2Loaded variable should be defined", testModule2Loaded);
	assertEquals("The testModule2Loaded variable should be defined as 'Chimps'", "Chimps", testModule2Loaded);
	assertEquals("The version of TestModule2 should be set","2.0.0", mozile.moduleList['TestModule2']['version']);
	assertEquals("The result of testFunction should be '2'", 2, mozile.testFunction());
}


function testModules() {
	mozileConstructor();
	registration();
	checkRequirements();
	loadModule1();
	//loaded1();
	loadModule2();
	//loaded2();
}


// Now run removal tests
