/** Mozile Module Test Script 4
 * @fileoverview This file contains JSUnit test functions for testing Mozile's module loading and unloading methods. It is the second of three such scripts, and it must be run after the first script has completed.
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */

/** Test - Loaded Module 2
 * Now try loading Test Module 2, which depends upon Test Module 1. In order to be sure that it has completely loaded, we must switch to the final script: modules3.js
 */
function loadModule2() {
	var configString="TestModule2";
	var name="TestModule2";
	var id = "Mozile-TestModule1-TestModule1.js";
	mozile.loadModule(configString);
	
	// Make sure that the new script tag exists
	var tag = document.getElementById(id);
	assertNotNull("There should be a script tag with id "+id, tag);
	assertNotUndefined("There should be a script tag with id "+id, tag);
	
	// Make sure only one such element exists	
	var scripts = document.getElementsByTagName("script");
	var j=0;
	for(i=0; i < scripts.length; i++) {
		if(scripts[i].id == id) j++;
	}
	assertEquals("There should be only one script tag with id "+id, 1 ,j);
	
	assertNotNull("The moduleList should contain a "+ name +" entry", mozile.moduleList[name]);
	assertNotUndefined("The moduleList should contain a "+ name +" entry", mozile.moduleList[name]);
	assertEquals("The version of TestModule2 should be 'unknown version'","unknown version", mozile.moduleList[name]['version']);
	
	// Module will not be loaded yet. See next script tag.
}

