/** Mozile Module Test Script 2
 * @fileoverview This file contains JSUnit test functions for testing Mozile's module loading and unloading methods. It is the second of three such scripts, and it must be run after the first script has completed.
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */

/** Test - Load Module 1
 * Now try loading Test Module 1 for real. To make sure that this has completely succeeded, we must switch to another script: modules2.js
 */
function loadModule1() {
	var configString="TestModule1";
	var name="TestModule1";
	var id = "Mozile-TestModule1-TestModule1.js";
	
	// Try loading the module. This should succeed.
	var result = mozile.loadModule(configString);
	assertTrue("The first attempt to load the module should return true", result);
	
	// Make sure that the new script tag exists
	var tag = document.getElementById(id);
	assertNotNull("There should be a script tag with id "+id, tag);
	assertNotUndefined("There should be a script tag with id "+id, tag);
	
	// Make sure only one such element exists	
	scripts = document.getElementsByTagName("script");
	j=0;
	for(i=0; i < scripts.length; i++) {
		if(scripts[i].id == id) j++;
	}
	assertEquals("There should be only one script tag with id "+id,1,j);
	
	// Make sure that it has been added once to the moduleList
	assertNotNull("The moduleList should contain a "+ name +" entry", mozile.moduleList[name]);
	assertNotUndefined("The moduleList should contain a "+ name +" entry", mozile.moduleList[name]);
	assertEquals("The version of TestModule1 should be 'unknown version'","unknown version", mozile.moduleList[name]['version']);

	// Try loading the module a second time. This should fail.
	result = mozile.loadModule(configString);
	assertFalse("The second attempt to load the module should return false", result);
	
	// Make sure there is still only on script element with the given id
	scripts = document.getElementsByTagName("script");
	j=0;
	for(i=0; i < scripts.length; i++) {
		if(scripts[i].id == id) j++;
	}
	assertEquals("There should be only one script tag with id "+id,1,j);
	
	// Module will not be loaded yet. See next script tag.
}
