/** Mozile Link Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's link creation and removal methods. 
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


/** Test - Load Link
 * Compare how many links there are in this page before and after the Mozile.loadLink() method is called.
 */
function loadLink() {
	var links1 = document.getElementsByTagName("link").length;
	mozile.loadLink("dummy.css","Mozile-Test-dummy.css");
	var links2 = document.getElementsByTagName("link").length;
	assertEquals("There should be one more link now than before.", links1+1, links2);

	var links = document.getElementsByTagName("link");
	var dummies = 0;
	for(i=0;i<links.length;i++) {
		if(links[i].getAttribute("href") == "dummy.css") dummies++;
	}
	assertEquals("There should be exactly one dummy link element.",1,dummies);	
}


/** Test - Unload Link
 * Compare how many links there are in this page before and after the Mozile.unloadLink() method is called.
 */
function unloadLink() {
 	var links1 = document.getElementsByTagName("link").length;
	mozile.unloadLink("Mozile-Test-dummy.css");
	var links2 = document.getElementsByTagName("link").length;
	assertEquals("There should be one fewer link now.", links1-1, links2);

	var links = document.getElementsByTagName("link");
	var dummies = 0;
	for(i=0;i<links.length;i++) {
		if(links[i].getAttribute("href") == "dummies.js") dummies++;
	}
	assertEquals("There should be no dummy link elements.",0,dummies);
}


function testLinks() {
	loadLink();
	unloadLink();
}
