/** Mozile Initialization Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's initialization. The mozile.js script will already have been run, so the goal is to make sure that it added the MozileCore.js file, and that it's working fine.
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */

/** Test - Loading Mozile Document
 * Check to see that the MozileCore.js script tag has been inserted precisely once. Then check to see that the 'mozile' instance of the Mozile object has been instantiated, and that it has it's 'version' property set.
 */
function testLoadingMozileDocument() {
	var id = "Mozile-Core-core.js"
	
	// Make sure that the mozileDocument script element exists.
	var md = document.getElementById(id);
	assertNotNull("There should be a script tag with id "+id, md);
	assertNotUndefined("There should be a script tag with id "+id, md);
	
	// Make sure only one such element exists	.
	var scripts = document.getElementsByTagName("script");
	var j=0;
	for(var i=0; i < scripts.length; i++) {
		if(scripts[i].id == id) j++;
	}
	assertEquals("There should be only one script tag with id "+id,1,j);
	
	// Make sure that the mozile variable is defined.
	assertNotNull("The variable 'mozile' should be exist.", mozile);
	assertNotUndefined("The variable 'mozile' should be defined.", mozile);  
	
	// Make sure that the mozile variable has a version property.
	assertNotNull("The variable 'mozile' should have a 'version' property.", mozile.version);
	assertNotUndefined("The variable 'mozile' should have its 'version' property  defined.", mozile.version);

}