/** Mozile Configuration Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's option and configuration string parsing. 
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


/** Test - Basic Parsing
 * Test the simplest module configuration string. Garbage text in inserted, but the result of parseConfig() should still have some structure.
 */
function testBasicParsing() {
	var configString = "DummyModule garbage text";
	var arr = mozile.parseConfig(configString);

	assertNotNull("The configuration array should exist", arr);
	assertNotUndefined("The configuration array should be defined.", arr);

	assertNotNull("The configString key should exist", arr['configString']);
	assertNotUndefined("The configString key should be defined", arr['configString']);
	assertEquals("The configString should be returned", configString, arr['configString']);

	assertNotNull("The 'name' key should exist", arr['name']);
	assertNotUndefined("The 'name' key should be defined", arr['name']);
	assertEquals("The 'name' should be DummyModule","DummyModule",arr['name']);

	assertEquals("The result of testFunction should be '0'", 0, mozile.testFunction());
}


/** Test - Advanced Parsing
 * Test a module configuration string with lots of options. This checks minimum, maximum, required, and excluded version strings, and a few other options.
 */
function testAdvancedParsing() {
	var configString = "DummyModule: minVersion=1.0.2, maxVersion=1.1.2, notVersion=1.1.0, notVersion=1.0.6, requireVersion=1.0.7, remoteVersion=1.0.7, forceRemote=false, remotePath='/path/to/module/' ";
	var arr = mozile.parseConfig(configString);
	assertNotNull("The configuration array should exist", arr);
	assertNotUndefined("The configuration array should be defined.", arr);
	
	var pairs = new Array();
	pairs['configString']=configString;
	pairs['name']="DummyModule";
	pairs['minVersion']="1.0.2";
	pairs['maxVersion']="1.1.2";
	pairs['requireVersion']="1.0.7";
	pairs['remoteVersion']="1.0.7";
	pairs['forceRemote']='false';
	pairs['remotePath']="/path/to/module/";

	// Loop over the array, checking each of the values	
	for(key in pairs) {
		assertNotNull("The "+key+" should exist", arr[key]);
		assertNotUndefined("The "+key+" should be defined", arr[key]);
		assertEquals("The "+key+" should be "+pairs[key], pairs[key],arr[key]);
	}
	
	// TODO: test notVersion

}


/** Test - Ugly Parsing
 * Test a module configuration string that is a mess, but still valid.
 */
function testUglyParsing() {
	var configString = "  DummyModule garbage:junk,, minVersion=1.0.2, maxVersion=1.1.2,  notVersion=1.1.0,trash notVersion=1.0.6, requireVersion=1.0.7, remoteVersion=1.0.7, forceRemote=false, remotePath='/path/to/another module/' extra_stuff =ww";
	var arr = mozile.parseConfig(configString);

	assertNotNull("The configuration array should exist", arr);
	assertNotUndefined("The configuration array should be defined", arr);
	
	var pairs = new Array();
	pairs['configString']=configString;
	pairs['name']="DummyModule";
	pairs['minVersion']="1.0.2";
	pairs['maxVersion']="1.1.2";
	pairs['requireVersion']="1.0.7";
	pairs['remoteVersion']="1.0.7";
	pairs['forceRemote']='false';
	pairs['remotePath']="/path/to/another module/";

	// Loop over the array, checking each of the values	
	for(key in pairs) {
		assertNotNull("The "+key+" should exist", arr[key]);
		assertNotUndefined("The "+key+" should be defined", arr[key]);
		assertEquals("The "+key+" should be "+pairs[key], pairs[key],arr[key]);
	}
	
	// TODO: test notVersion

}