/** Mozile Commands Test Script
 * @fileoverview This file contains JSUnit test functions for testing Mozile's command creation methods. 
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


// Define a global testCommand variable.
var testCommand;


/** Test - Registration
 * Test the module registration methods. This includes registering a module, making sure it is loaded, and the unregistering it and making sure it is no longer loaded.
 */
function createCommand() {
 	var configString = "MozileCommand: id=Mozile-TestCommand, label=Test, tooltip='Test Command', accesskey=T, accelerator='Command-T', image='images/test.png'";
 	
 	// Create the command, and make sure that it worked.
 	testCommand = mozile.createCommand(configString);
 	
 	assertNotUndefined("The testCommand should be defined.", testCommand);
 	
 	// Now test some of the basic of the MozileCommand object.
 	var tests = new Array();
 	tests['id']="Mozile-TestCommand";
 	tests['label']="Test";
 	tests['tooltip']="Test Command";
 	tests['accesskey']="T";
 	tests['accelerator']="Command-T";
 	tests['image']="images/test.png";

	// Loop over the array, checking each of the values	
	for(key in tests) {
		assertNotNull("The "+key+" should exist", eval("testCommand."+key) );
		assertNotUndefined("The "+key+" should be defined", eval("testCommand."+key) );
		assertEquals("The "+key+" should be "+tests[key], tests[key], eval("testCommand."+key) );
	}
	
	// TODO: Test button and menuitem creation

}


/** Test - Registration
 * Test the module registration methods. This includes registering a module, making sure it is loaded, and the unregistering it and making sure it is no longer loaded.
 */
function registration() {	
	// Try to register the a fake command. This should fail.
	var result = mozile.registerCommand('fakeCommand');	
	assertFalse("The registerCommand function should return true", result);
	
	// Register the testCommand, and check to make sure that it worked.
	result = mozile.registerCommand(testCommand);	
	assertTrue("The registerCommand function should return true", result);
	
	// Get the command's id.
	var testCommandId = testCommand.id;
	assertNotNull("The testCommand's id should exist", testCommandId);
	assertNotUndefined("The testCommand's id should be defined", testCommandId);
	assertNotUndefined("There should be now be a testCommand entry in the commandList", mozile.commandList[testCommandId]);

	// Make sure that the test module is loaded, and that we aren't getting false positives.	
	assertTrue("Now the testCommand should be registered", mozile.commandIsRegistered(testCommandId));
	assertFalse("But the 'fakeCommand' should not be resgistered", mozile.commandIsRegistered('fakeCommand'));
	
	// Unregister the moudles, and check that it is no longer loaded.
	result = mozile.unregisterCommand(testCommandId);
	assertTrue("The unregisterModule function should succeed", result);
	assertFalse("Now the testCommand should not be loaded", mozile.commandIsRegistered(testCommandId));

	// Try to unregister a module which has not been registered.
	result = mozile.unregisterCommand('fakeCommand');
	assertFalse("The unregisterModule function should fail with 'fakeCommand'.", result);

}


function testCommands() {
	createCommand();
	registration();
}