/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
 

/** Local File
 * @fileoverview This module is used for saving to the local file system.
 * 
 * @link http://mozile.mozdev.org 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */

// Define a new Mozile.saveList entry.
mozile.saveList["LocalFile"] = new Array();
mozile.saveList["LocalFile"]["value"] ="LocalFile";
mozile.saveList["LocalFile"]["label"] ="Save to File";
mozile.saveList["LocalFile"]["function"] = "mozile.saveToFile";
mozile.saveList["LocalFile"]["file"] = "";


// If the configuration of this modules gives a filepath, then set it
if(mozile.moduleList["LocalFile"]["file"]) {
	mozile.saveList["LocalFile"]["file"] = mozile.moduleList["LocalFile"]["file"];
}

// If the configuration of this modules says it's the default, then set it as the default.
if(mozile.moduleList["LocalFile"]["default"] && mozile.moduleList["LocalFile"]["default"] == "true") {
	mozile.saveList["default"] = mozile.saveList["LocalFile"];
}

/*
var save = mozile.commandList["Mozile-SaveToDialog"];
save.command = function(event) {
	var f = new Array();
	f["File"] = "HTTPPost/HTTPPost.js";
	f["Function"] = "save.command";
	
	mozile.status(f,2,"Starting to save document.");
	var result = mozileSaveToFile();
	if(result) mozile.status(f,2,"Document saved.", 100);
	else mozile.status(f,2,"Error saving document!");
}
*/



/** Mozile - Save To File -
 * Using the configuration details in the Mozile.saveConfig array, save the current document to a file on the local system.
 * 
 * @return True if successful, false otherwise.
 */
Mozile.prototype.saveToFile = function() {
	var f = new Array();
	f["File"] = "LocalFile/LocalFile.js";
	f["Function"] = "mozileSaveToFile()";
	
	var file;
	var text = this.content();

	
	//Get privileges
	try{
		netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect UniversalBrowserWrite ");
	}	catch(e){
		this.debug(f,3,"Universal Connect denied: "+e);
		this.status(f,3,"Save failed! Insufficient privileges.");
		return false;
	}
	
	try {
		if(!this.saveConfig["file"]) {
			this.debug(f,1,"No stored path.");
			var filePicker = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
		
			filePicker.init(window, "Save As", filePicker.modeSave);
			
			//filePicker.defaultString = document.location.href;
			filePicker.appendFilters(filePicker.filterText);
			filePicker.appendFilters(filePicker.filterHTML);
			filePicker.appendFilters(filePicker.filterXML);
			filePicker.appendFilters(filePicker.filterAll);
			filePicker.defaultExtension = "txt";
				
			var result = filePicker.show();
			if(result == filePicker.returnOK || result == filePicker.returnReplace) {
				file = filePicker.file;
				this.saveConfig["file"] = file.path;
			}
			else {
				return false;
			}
		}
		else {
			this.debug(f,1,"Stored path: "+mozile.saveConfig["file"]);
			file = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
			file.initWithPath(this.saveConfig["file"]);
		}
		
		
		if(!file.exists()) {
			file.create(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 444);
		}
		
		if(!file.isWritable()) {
			this.status(f,3,"Can't write to file!!");
		}
	
		var outputStream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);   
		outputStream.init(file, 0x04 | 0x08 | 0x20, 0444, null);
		outputStream.write(text, text.length);
		outputStream.close();
		
	} catch(e) {
		alert("Some sort of output error "+e);
	}
   
  
	this.status(f,1,"File saved.");
	return true;

}




mozile.registerModule("LocalFile","1.0.0");