/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/license.html
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Playsophy code (www.playsophy.com).
 *
 * The Initial Developer of the Original Code is Playsophy
 * Portions created by the Initial Developer are Copyright (C) 2002-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *		David Palm <dvdplm@iperbole.bologna.it>
 *
 * ***** END LICENSE BLOCK ***** */


/** Copy Cut Paste Module
 * @fileoverview Allows Mozile to do some basic Copy&Paste operations. Requires above-normal privileges and will not work in server-seide version without setting the pref "signed.applets.codebase_principal_support" to "true" using the "about:config" GUI in Firefox. Doing this has serious security implications and should only be done in a controlled environment.
 * 
 * @link http://mozile.mozdev.org 
 * @author David Palm <dvdplm@iperbole.bologna.it>
 * @version 0.0.1
 */
var f = new Array();
	f["File"] = "CopyCutPaste/CopyCutPaste.js";
	f["Function"] = "";
mozile.debug(f,0,"CutCopyPaste.js:: LOADED");


// A string which contains the clipboard contents
Mozile.prototype.clipboard = "";


/** Mozile - Do Copy -
 * Copy the current selection to system clipboard. Makes use of the nsIClipboardHelper interface and is not a "full-scale" copy-to-clipboard method; this means the selection will be copied as a unicode string and all formatting will be stripped (try copying an unordered list and watch how gecko turns it into a string with newlines, tabs and "*" instead of bullets :-)
 * 
 * @return The string that was copied to the clipboard when successful, false otherwise.
 */
Mozile.prototype.doCopy		=	function(){
	var f = new Array();
	f["File"] = "CopyCutPaste/CopyCutPaste.js";
	f["Function"] = "Mozile.doCopy()";
	this.debug(f,0,"START");

	// Get the selected string
	var	copyStr	=	this.getSelection().toString();	

	// If the "requestPermissions" option has not been set to "true", then use the document's clipboard and not the system clipboard.
	if(!mozile.extension && (!this.moduleList["CopyCutPaste"]["requestPermissions"] || this.moduleList["CopyCutPaste"]["requestPermissions"]!="true") ) {
		this.clipboard = copyStr;
	}

	// Otherwise, ask for permission to use the system clipboard.
	else {
		//Get privileges
		try{netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect UniversalBrowserWrite ");}
		catch(e){
			this.debug(f,3,"Universal Connect non concesso"+e);
			return false;
		}
		
		//Instantiate clipboardHelper service (text-only copying)	
		const	gClipboardHelper	=	Components.classes["@mozilla.org/widget/clipboardhelper;1"].getService(Components.interfaces.nsIClipboardHelper);
		
		//Put string on clipboard
		if(gClipboardHelper) {
			gClipboardHelper.copyString(copyStr);		
		}
		else {
			this.clipboard = copyStr;
		}
	}
	
	return copyStr;
}


/** Mozile - Do Cut -
 * Cut the current selection to system clipboard. Calls Mozile.doCopy to do the copy then deletes the current selection (using MozileCore.js's deleteContents() method)
 * 
 * @return The string that was cut to the clipboard when successful, false otherwise.
 */
Mozile.prototype.doCut		=	function(){
	var f = new Array();
	f["File"] = "CopyCutPaste/CopyCutPaste.js";
	f["Function"] = "Mozile.doCut()";
	this.debug(f,0,"START");	
	var copyStr  = this.doCopy() ;
	if(copyStr){
		this.getSelection().deleteContents();
		return copyStr;
	}
	else{
		this.debug(f,0,"Cut command failed. Maybe a problem in doCopy()?");
		return false;
	}
}

/** Mozile - Do Paste -
 * Paste from clipboard, replacing selectin if any. The implementation uses the full nsIClipboard interface. Should probably be improved/extended to handle at least URLs.
 * 
 * @return The string that was pasted when successful, false otherwise.
 */
Mozile.prototype.doPaste	=	function(){
	var f = new Array();
	f["File"] = "CopyCutPaste/CopyCutPaste.js";
	f["Function"] = "Mozile.doPaste()";
	this.debug(f,0,"START");
	
	// If the "requestPermissions" option has not been set to "true", then use the document's clipboard and not the system clipboard.
	if(!mozile.extension && (!this.moduleList["CopyCutPaste"]["requestPermissions"] || this.moduleList["CopyCutPaste"]["requestPermissions"]!="true") ) {
		if(this.clipboard) this.insertString(this.clipboard);
		return this.clipboard;
	}
	// Otherwise use the system clipboard.
	
	
	//Get privileges
	try{netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect UniversalBrowserWrite ");}
	catch(e){
		this.debug(f,3,"Universal Connect non concesso"+e);
		return false;
	}	
	
	//Get clipboard
	var clip = Components.classes["@mozilla.org/widget/clipboard;1"].createInstance(Components.interfaces.nsIClipboard);
	if (!clip) return false;
	
	this.debug(f,0,"Got clipboard: "+clip);	
	var trans = Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);
	if (!trans) return false;
	
	this.debug(f,0,"Got transferable: "+trans);
	
	trans.addDataFlavor("text/unicode");
	this.debug(f,0,"Added data flavour (text/unicode)")
	
	clip.getData(trans,clip.kGlobalClipboard);
	this.debug(f,0,"Copied clipboard data into clip var")
	
	var str			=	new Object();
	var strLength	=	new Object();

	trans.getTransferData("text/unicode",str,strLength);
	this.debug(f,0,"Got data. Converting to js string...")
	
	if(str)
		str			=	str.value.QueryInterface(Components.interfaces.nsISupportsString);
	else{
		this.debug(f,0,"str is false, so I could not QueryInterface the str var's value");
		return false;
	}
	if (str)
		pasteText	=	str.data.substring(0,strLength.value / 2);
	else{
		this.debug(f,0,"str is false, so I could not grab the js string from clipboard");
		return false;
	}
		
	this.debug(f,0,"Js string to be pasted: "+pasteText)
	
	this.insertString(pasteText)
	
	return pasteText;	
}


//Set up copy, cut and paste commands

var mozileCopy = mozile.rootCommandList.createCommand("MozileCommand: id=Mozile-Copy, label=Copy, tooltip='Copy selection', accelerator='Command-C', image='"+mozile.root+"images/copy.png'");
mozileCopy.command = function() {
	var f = new Array();
	f["File"] = "CopyCutPaste/CopyCutPaste.js";
	f["Function"] = "mozileCopy.command";
	this.debug(f,0,"START");
	mozile.doCopy();
	
}

var mozileCut = mozile.rootCommandList.createCommand("MozileCommand: id=Mozile-Cut, label=Cut, tooltip='Cut selection', accelerator='Command-X', image='"+mozile.root+"images/cut.png'");
mozileCut.command = function() {
	var f = new Array();
	f["File"] = "CopyCutPaste/CopyCutPaste.js";
	f["Function"] = "mozileCut.command";
	this.debug(f,0,"START");
	mozile.doCut();
}

var mozilePaste = mozile.rootCommandList.createCommand("MozileCommand: id=Mozile-Paste, label=Paste, tooltip='Paste selection', accelerator='Command-V', image='"+mozile.root+"images/paste.png'");
mozilePaste.command = function() {
	var f = new Array();
	f["File"] = "CopyCutPaste/CopyCutPaste.js";
	f["Function"] = "mozilePaste.command";
	this.debug(f,0,"START");
	mozile.doPaste();
}

mozile.registerModule("CopyCutPaste","0.0.1");