/* ***** BEGIN LICENSE BLOCK *****
 * Licensed under Version: MPL 1.1/GPL 2.0/LGPL 2.1
 * Full Terms at http://mozile.mozdev.org/license.html
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Playsophy code (www.playsophy.com).
 *
 * The Initial Developer of the Original Code is Playsophy
 * Portions created by the Initial Developer are Copyright (C) 2002-2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *	James A. Overton <james@overton.ca>
 *
 * ***** END LICENSE BLOCK ***** */
 

/** Mozile Loader  
 * @fileoverview This file is used to configure and load Mozile. Mozile is a collection of JavaScripts which allow inline editing of XHTML/XML documents in Mozilla browsers. See the "INSTRUCTIONS" section below for more details on configuring this file.
 * 
 * Project Homepage: http://mozile.mozdev.org
 * For details on configuration, see: 
 *   http://mozile.mozdev.org/docs/mozileDocs.html
 * 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


/**** INSTRUCTIONS ****/

/**
 * This file allows you to configure how Mozile will operate in your webpages.
 * There are two sections to this file:
 *   - Configuration
 *   - Initialization
 * In order for Mozile to function, you will likely have to change
 * the Configuration options.
 * You probably should NOT change anything in the Initialization section.
 */



/**** CONFIGURATION ****/



/**
 * Mozile Script Source
 * If this file "mozile.js" is inside the "core" directory of the main Mozile directory (which is its default location), then set mozileScriptSource to "" (an empty string). The actual path will be automatically detected.
 * If the Mozile scripts should be found somewhere else, then set mozileScriptSource to the path to the main Mozile directory. An absolute path is simplest. If you use a relative path, it must be relative to the document which loads this file "mozile.js". In either case, set the mozileScriptSource such that this file "mozile.js" can be reached at: [mozileScriptSource]core/mozile.js
 *
 * Examples:
var mozileScriptSource = "http://somewhere.com/path/to/mozile/"
var mozileScriptSource = "chrome://mozile/content/"
 */
var mozileScriptSource = "../../";



/**
 * Prefer Mozile Extension
 * When this is "true" Mozile will attempt to use the Mozile Extension 
 * installed in the user's browser.
 * TODO: This setting currently has no effect.
 */
var preferMozileExtension = false;



// Define the default XHTML namespace to use in XML documents
var XHTMLNS = "http://www.w3.org/1999/xhtml";

// Do not edit the following two lines:
var mozile;
function mozileConfiguration() {


/**
 * Declare Modules
 * Comment out any unwanted modules.
 * Add modules by carefully following one of the given patterns.
 * Examples of all options (some are incompatible):
 * "CopyCutPaste: minVersion=1.0.2, maxVersion=1.1.2, notVersion=1.0.6, notVersion=1.1.0, requireVersion=1.0.7, remoteVersion=1.0.7, forceRemote=false, remotePath='/path/to/module/' "
 */

var modules = [
//	"TestModule1",
//	"TestModule2",
		"UndoRedo",
		"CopyCutPaste: requestPrivileges=No",
		"XHTMLBasic",
		"LocalFile: default=true",
//		"HTTPPost: default=true, url='http://overton.ca/james/mozile/php/save_dump.php'",
//	"Debugging: remoteVersion=1.0.4",
//	"UndoRedo: remoteVersion=2.6, remotePath='/root/path/' ",
]; // end of modules array


// Do not edit the following 10 lines:
	// Instantiate the global Mozile object
	mozile = new Mozile("root='"+mozileScriptSource+"', debugLevel=4, warnBeforeUnload=false");

	// Create the Mozile toolbar
	mozile.createToolbar("type");

	// Load every entry in the module array
	for(var m=0; m < modules.length; m++){
			mozile.loadModule(modules[m]);
	}



/**** COMMANDS ****/

/**
 * Now that the Mozile code is loaded, you can specify commands which will create Mozile editors.
 */

/**
 * Create Mozile Editor
 * Use this command to change an existing element into a Mozile Editor.
 *   - The first parameter is the id of an element.
 *   - The second paramter is a string which specifies some Mozile Editor 
 *     options. 
 *	TODO: No editor options are currently implemented.
 */
// mozile.createEditor("someElementId","copyCutPaste=system, ");
//mozile.createEditor("catch","");
//mozile.createEditor("throw","");



/**
 * Create Mozile Editors
 * Use this command to change existing elements into Mozile Editors.
 *   - The first parameter is a CSS selector.
 *   - The second paramter is a string which specifies some Mozile Editor 
 *     options. 
 *	TODO: No editor options are currently implemented.
 */
//mozile.createEditors("div","");
//mozile.createEditors("div > p","");
mozile.createEditors("section","");



/**
 * Replace Textarea
 * TODO: This functionality if not currently implemented
 *
 * Use this command to replace HTML <textarea> elements with powerful
 * Mozile Editors. This will allow the user to easily edit XHTML, 
 * without changing the HTML form system for the page.
 *   - Specify a particular <textarea> by its id (string), or node (DOM node).
 *   - If no argument is specified, all of the textareas will be replaced.
 */
// mozile.replaceTextarea("someTextareaId");




} // end of mozileConfiguration()





/**** INITIALIZATION ****/

/**
 * Mozile Initialization
 * DO NOT EDIT THIS SECTION!
 * This function inserts a <script> tag into the document. The <script> tag load the MozileCore.js JavaScript file, which makes Mozile work. Once MozileCore is loaded, it will call the mozileConfiguration() function above, while will continue the loading process.
 */
function mozileInitialization() {

// CHECK FOR THE EXTENSION
// TODO: Currently the extension is not automatically detected. To use code from the extension, you must declare: mozileScriptSource="chrome://mozile/content/"

/**
 * Browser Detection
 * Mozile only works in Mozilla browsers: Firefox and Mozilla (Seamonkey). ALthough Apple's Safari browser might report that it is Gecko compatible, it does not include all the necessary functionality for Mozile, so it is not supported.
 */
	if((navigator.product == 'Gecko') && (navigator.userAgent.indexOf("Safari") == -1))
	{
		
		var scriptTag ="";
		
		// Check to see if this is an X/HTML or an XUL document.
		var rootName = document.documentElement.tagName.toLowerCase();
		if(rootName=="html" || rootName=="xul") {
			// Build the required script tag in the default namespace
			scriptTag = document.createElement("script");
		}
		// If it's not X/HTML or XUL, assume it's generic XML
		else {
			// Build the required script tag in the XHTML namespace
			scriptTag = document.createElementNS(XHTMLNS,"script");
		}
		
		// Try to get the head tag for the document
		var head = document.getElementsByTagName("head")[0];
		
		// If no mozileScriptSource is given, try to get the src attribute of the script tag in the original document which points to this file.
		if(mozileScriptSource=="") {
			var mozileRE = /(.*)mozile.js$/;
			var source, result;
			var scripts = document.getElementsByTagName("script");
			
			for(var i=0; i<scripts.length; i++) {
				source = scripts[i].getAttribute("src");
				result = mozileRE.exec(source);
				if(result && result[1]) {
					mozileScriptSource = result[1] + "../";
					break;
				}
			}
		}		
		
		// Finish building the script tag
		scriptTag.setAttribute("id","Mozile-Core-MozileCore.js");
		scriptTag.setAttribute("type","application/x-javascript");
		var src = mozileScriptSource +"core/MozileCore.js";
		scriptTag.setAttribute("src",src);
			
		// If the head is defined, append the script tag to the head.
		if(head) {
			head.appendChild(scriptTag);
		}
		// If the head is not defined, insert the tag at the very top of the document.
		else {
			document.documentElement.insertBefore(scriptTag,document.documentElement.firstChild);
		}
	
	// MozileCore.js should now load when this script is finished running

	}

	// If the browser detection fails, throw an error. 
	// TODO; It might be better to die silently.
	else {
		alert("Mozile Error: This browser is not supported! Only Mozilla and Mozilla Firefox browsers are currently supported.");
	}


} // end of mozileInitialization()


// Finally, call the initialization function.
mozileInitialization();


