/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is James A. Overton's code (james@overton.ca).
 *
 * The Initial Developer of the Original Code is James A. Overton.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
 

/** Mozile Loader  
 * @fileoverview This file is used to configure and load Mozile. Mozile is a collection of JavaScripts which allow inline editing of XHTML/XML documents in Mozilla browsers. See the "INSTRUCTIONS" section below for more details on configuring this file.
 * 
 * Project Homepage: http://mozile.mozdev.org
 * For details on configuration, see: 
 *   http://mozile.mozdev.org/docs/mozileDocs.html
 * 
 * @author James A. Overton <james@overton.ca>
 * @version 0.7.0
 */


/**** INSTRUCTIONS ****/

/**
 * This file allows you to configure how Mozile will operate in your webpages.
 * There are two sections:
 *   - Configuration
 *   - Commands
 *   - Initialization
 * In order for Mozile to function, you will may have to change the Configuration options. In order to specify which parts of your document should be editable you may have to add or remove Commands.
 * You probably should NOT change anything in the Initialization section.
 */



/**** CONFIGURATION ****/

/**
 * Mozile Script Source
 * If this file "mozile.js" is inside the "core" directory of the main Mozile directory (which is its default location), then set mozileScriptSource to "" (an empty string). The actual path will be automatically detected.
 * If the Mozile scripts should be found somewhere else, then set mozileScriptSource to the path to the main Mozile directory. An absolute path is simplest. If you use a relative path, it must be relative to the document which loads this file "mozile.js". In either case, set the mozileScriptSource such that this file "mozile.js" can be reached at: [mozileScriptSource]core/mozile.js
 */
// Examples:
// var mozileScriptSource = "http://somewhere.com/path/to/mozile/";
// var mozileScriptSource = "chrome://mozile/content/";
var mozileScriptSource = "";


/**
 * Mozile Options
 * Additional Mozile options can be specified here. For more details see the documentation and the Mozile object in "core.js".
 */
//var mozileOptions = "debugLevel=0, warnBeforeUnload=false";
var mozileOptions = "";


/**
 * Mozile Interface
 * By default, Mozile loads a toolbar and status bar which provide an appropriate user interface for editing documents. If you only want to use the core editing functionality of Mozile, which includes inserting and deleting text, and no Mozile modules, then set this variable to "false". 
 */
// var mozileInterface = false; // Do not load interface code.
var mozileInterface = true; // Load interface code.


/**
 * Declare Modules
 * Comment out any unwanted modules.
 * Add modules by carefully following one of the given patterns.
 * Example including all options (some are incompatible):
 * "CopyCutPaste: minVersion=1.0.2, maxVersion=1.1.2, notVersion=1.0.6, notVersion=1.1.0, requireVersion=1.0.7, remoteVersion=1.0.7, forceRemote=false, remotePath='/path/to/module/' "
 */
var modules = [
		//"UnwantedModule",
		"UndoRedo",
		"CopyCutPaste: requestPermissions=false",
		"XHTMLBasic",
		"LocalFile",
]; // end of modules array



// Define the default XHTML namespace to use in XML documents. 
// TODO: Not currently implemented.
var XHTMLNS = "http://www.w3.org/1999/xhtml";


/**** END OF CONFIGURATION ****/




// DO NOT edit the following lines. They declare and create the main Mozile object instance.
var mozile;


/**
 * Mozile Configuration
 * DO NOT EDIT THIS SECTION!
 * This function creates the main Mozile object and loads the modules.
 */
function mozileConfiguration() {

	// Instantiate the global Mozile object
	mozile = new Mozile("root='"+mozileScriptSource+"'," + mozileOptions);
	
	if(mozileInterface) {
		// Create the Mozile toolbar
		mozile.createToolbar("type");
		// Load every entry in the module array
		for(var m=0; m < modules.length; m++){
				mozile.loadModule(modules[m]);
		}
	}



/**** COMMANDS ****/

/**
 * Now that the Mozile code is loaded, you can specify commands which will create Mozile editors.
 */

/**
 * Create Mozile Editor
 * Use this command to change an existing element into a Mozile Editor.
 *   - The first parameter is the id of an element.
 *   - The second paramter is a string which specifies some Mozile Editor 
 *     options. 
 *	TODO: No editor options are currently implemented.
 */
// mozile.createEditor("someElementId","");




/**
 * Create Mozile Editors
 * Use this command to change existing elements into Mozile Editors.
 *   - The first parameter is a CSS selector.
 *   - The second paramter is a string which specifies some Mozile Editor 
 *     options. 
 *	TODO: No editor options are currently implemented.
 */
//mozile.createEditors("div","");
//mozile.createEditors("div > p","");
// Use the following command for IE compatibility.
//mozile.createEditors("*[contentEditable=true]",""); 
mozile.createEditors(".editor","");



/**
 * Replace Textarea
 * TODO: This functionality if not currently implemented
 *
 * Use this command to replace HTML <textarea> elements with powerful
 * Mozile Editors. This will allow the user to easily edit XHTML, 
 * without changing the HTML form system for the page.
 *   - Specify a particular <textarea> by its id (string), or node (DOM node).
 *   - If no argument is specified, all of the textareas will be replaced.
 */
// mozile.replaceTextarea("someTextareaId");


/**** END OF COMMANDS ****/

} // end of mozileConfiguration()


/**** INITIALIZATION ****/

/**
 * Mozile Initialization
 * DO NOT EDIT THIS SECTION!
 * This function inserts a <script> tag into the document. The <script> tag load the core.js JavaScript file, which makes Mozile work. Once core.js is loaded, it will call the mozileConfiguration() function above, while will continue the loading process.
 */
function mozileInitialization() {

/**
 * Browser Detection
 * Mozile only works in Mozilla browsers: Firefox and Mozilla (Seamonkey). Although Apple's Safari browser might report that it is Gecko compatible, it does not include all the necessary functionality for Mozile, so it is not supported.
 */
	if((navigator.product == 'Gecko') && (navigator.userAgent.indexOf("Safari") == -1))
	{
		
		var scriptTag ="";
		
		// Check to see if this is an X/HTML or an XUL document.
		var rootName = document.documentElement.tagName.toLowerCase();
		if(rootName=="html" || rootName=="xul") {
			// Build the required script tag in the default namespace
			scriptTag = document.createElement("script");
		}
		// If it's not X/HTML or XUL, assume it's generic XML
		else {
			// Build the required script tag in the XHTML namespace
			scriptTag = document.createElementNS(XHTMLNS,"script");
		}
		
		// Try to get the head tag for the document
		var head = document.getElementsByTagName("head")[0];
		
		// If no mozileScriptSource is given, try to get the src attribute of the script tag in the original document which points to this file.
		if(mozileScriptSource=="") {
			var mozileRE = /(.*)mozile.js$/;
			var source, result;
			var scripts = document.getElementsByTagName("script");
			
			for(var i=0; i<scripts.length; i++) {
				source = scripts[i].getAttribute("src");
				result = mozileRE.exec(source);
				if(result && result[1]) {
					mozileScriptSource = result[1] + "../";
					break;
				}
			}
		}		
		
		// Finish building the script tag
		scriptTag.setAttribute("id","Mozile-Core-core.js");
		scriptTag.setAttribute("type","application/x-javascript");
		var src = mozileScriptSource +"core/core.js";
		scriptTag.setAttribute("src",src);
			
		// If the head is defined, append the script tag to the head.
		if(head) {
			head.appendChild(scriptTag);
		}
		// If the head is not defined, insert the tag at the very top of the document.
		else {
			document.documentElement.insertBefore(scriptTag,document.documentElement.firstChild);
		}
	
	// core.js should now load when this script is finished running

		// If the mozileInterface variable is "true", set up the interface.js script.
		if(mozileInterface) {
			if(rootName=="html" || rootName=="xul") {
				scriptTag2 = document.createElement("script");
			}
			else {
				scriptTag2 = document.createElementNS(XHTMLNS,"script");
			}
			scriptTag2.setAttribute("id","Mozile-Core-interface.js");
			scriptTag2.setAttribute("type","application/x-javascript");
			src = mozileScriptSource +"core/interface.js";
			scriptTag2.setAttribute("src",src);
			scriptTag.parentNode.insertBefore(scriptTag2, scriptTag);
		}

	}

	// If the browser detection fails, throw an error. 
	// TODO; It might be better to die silently.
	else {
		alert("Mozile Error: This browser is not supported! Only Mozilla and Mozilla Firefox browsers are currently supported.");
	}


} // end of mozileInitialization()


// Finally, call the initialization function.
mozileInitialization();


