/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import java.util.concurrent.Callable;
import org.mozilla.dom.DocumentTypeImpl;
import org.mozilla.dom.NodeFactory;
import org.mozilla.dom.ThreadProxy;
import org.mozilla.dom.UnsupportedException;
import org.mozilla.dom.WeakValueHashMap;
import org.mozilla.interfaces.nsIDOMDOMImplementation;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMDocumentType;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class DOMImplementationImpl
implements DOMImplementation {
    protected nsISupports moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();

    public nsIDOMDOMImplementation getInstance() {
        return this.getInstanceAsnsIDOMDOMImplementation();
    }

    protected DOMImplementationImpl(nsISupports mozInst) {
        this.moz = mozInst;
        instances.put(mozInst, this);
    }

    public DOMImplementationImpl(nsIDOMDOMImplementation mozInst) {
        this((nsISupports)mozInst);
    }

    public static DOMImplementationImpl getDOMInstance(nsIDOMDOMImplementation mozInst) {
        DOMImplementationImpl node = (DOMImplementationImpl)instances.get(mozInst);
        return node == null ? new DOMImplementationImpl(mozInst) : node;
    }

    public nsIDOMDOMImplementation getInstanceAsnsIDOMDOMImplementation() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMDOMImplementation)this.moz.queryInterface("{a6cf9074-15b3-11d2-932e-00805f8add32}");
    }

    public boolean hasFeature(final String feature, final String version) {
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = DOMImplementationImpl.this.getInstanceAsnsIDOMDOMImplementation().hasFeature(feature, version);
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Document createDocument(final String namespaceURI, final String qualifiedName, DocumentType doctype) {
        final nsIDOMDocumentType mozDoctype = doctype != null ? ((DocumentTypeImpl)doctype).getInstance() : null;
        Callable<Document> c = new Callable<Document>(){

            @Override
            public Document call() {
                nsIDOMDocument result = DOMImplementationImpl.this.getInstanceAsnsIDOMDOMImplementation().createDocument(namespaceURI, qualifiedName, mozDoctype);
                return (Document)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Object getFeature(String feature, String version) {
        throw new UnsupportedException();
    }

    public DocumentType createDocumentType(final String qualifiedName, final String publicId, final String systemId) {
        Callable<DocumentType> c = new Callable<DocumentType>(){

            @Override
            public DocumentType call() {
                nsIDOMDocumentType result = DOMImplementationImpl.this.getInstanceAsnsIDOMDOMImplementation().createDocumentType(qualifiedName, publicId, systemId);
                return (DocumentType)NodeFactory.getNodeInstance((nsIDOMNode)result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }
}

