/*** -*- Mode: Javascript; tab-width: 2;
  
The contents of this file are subject to the Mozilla Public
License Version 1.1 (the "License"); you may not use this file
except in compliance with the License. You may obtain a copy of
the License at http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS
IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
implied. See the License for the specific language governing
rights and limitations under the License.

The Original Code is jslib team code.  
The Initial Developer of the Original Code is jslib team.

Portions created by jslib team are
Copyright (C) 2000 jslib team.  All
Rights Reserved.
  
Original Author: Pete Collins <pete@mozdevgroup.com>
Contributor(s):
    
***/


if (typeof(JS_LIB_LOADED)=='boolean') 
{

  const JS_AUTOUPDATE_LOADED   = true;
  const JS_AUTOUPDATE_FILE     = 'autoupdate.js';


  // Constructor
  function AutoUpdate (aRemoteFile, aPackageName, aContent, aCallback)
  {
    // jslibTurnDumpOn();
    // pull in dependent libs
    include (jslib_remotefile);
    include (jslib_dir);
    include (jslib_file);
    include (jslib_dirutils);
    include (jslib_prefs);

    if (!(aRemoteFile && aPackageName))
      throw "Missing: aRemoteFile or aPackageName";

    var ext = aRemoteFile.substring(aRemoteFile.lastIndexOf(".")+1, aRemoteFile.length);

    switch (ext)
    {
      case "xpi":
      case "jar":
      case "rdf":
        break;
      default:
        jslibDebug("Bad Remote File");
        throw "Invalid Mozilla package file";
    }

    this.mPackageExt = ext;
    this.mRemoteFile = aRemoteFile;
    this.mPackageName = aPackageName;

    if (aContent)
      this.mContent = aContent;
    else if (typeof(_content) == "object")
      this.mContent = _content;
    else
      throw "no dom window context found ...";

    this.mCallback = aCallback;
  } 

  AutoUpdate.prototype = 
  {
    mRemoteFile:null,
    mPackageName:null,
    mPackageExt:null,
    mRemoteVersion:null,
    mLocalVersion:null,
    mRemoteURL:null,
    mContent:null,
    mDataSource:null,
    mCallback:null,
    CHROME_NS:"http://www.mozilla.org/rdf/chrome#",

    // main API use to check for updates
    checkForUpdate : function () 
    {
      var rv;
      switch (this.mPackageExt)
      {
        case "xpi":
          rv = this.checkByTimeStamp();
          break;
        case "rdf":
          rv = this.checkByRDF();
          break;
      }
      return rv;
    },

    // checking by time stamp is one way to do it
    // not necessarily the best
    checkByTimeStamp : function () 
    {
      var rf = new RemoteFile (this.mRemoteFile);

      if (!rf.exists()) 
        throw this.mRemoteFile + " wasn't found";

      // get the remote xpi time stamp
      var lastModified = new Date(rf.lastModified);

      // check and see what and where the package file is
      var pkgTS = this.packageTimeStamp();

      var remoteTS = lastModified.getTime();
      var localTS = pkgTS.getTime() + 200000; // fuzz add two hours 
                                              // local and server clocks
                                              // are never exact so we ballpark

      jslibDebug("Remote Package Time Stamp: "+remoteTS);
      jslibDebug("Local Package Time Stamp: "+localTS);

      var rv = (remoteTS > localTS);

      return rv;
    },
    
    packageTimeStamp : function () 
    {
      var du = new DirUtils();
      var fTest = du.getChromeDir()+"/"+this.mPackageName;
      var d = new Dir(fTest);
      var dateModified;
      // check global chrome first
      if (d.isDir()) {
        dateModified = d.dateModified;
      } else {
        fTest += ".jar";
        var f = new File(fTest);
        if (f.exists())
          dateModified = f.dateModified;
      }

      // check user chrome 
      if (!dateModified) {
        fTest = du.getUserChromeDir()+"/"+this.mPackageName+".jar";
        f = new File(fTest);
        if (f.exists())
          dateModified = f.dateModified;
        jslibDebug(dateModified);
        jslibDebug(f.path);
      }

      return dateModified;
    },

    checkByRDF : function () 
    {
      var RDF = this.RDF;

      var observer = {
        onBeginLoad : function (sink) {},
        onInterrupt : function (sink) {},
        onResume : function (sink) {},
        onError : function (sink,status,msg) {},
 
        onEndLoad : function (sink) {
          var RDF = this.o.RDF;
          var packres = RDF.GetResource("urn:mozilla:package:" + this.o.mPackageName);
          var packageVersionPred = RDF.GetResource(this.o.CHROME_NS + "packageVersion")
          var version = this.o.mDataSource.GetTarget(packres, packageVersionPred, true);
          var packageURLPred = RDF.GetResource(this.o.CHROME_NS + "packageURL")
          var url = this.o.mDataSource.GetTarget(packres, packageURLPred, true);

          if (version instanceof jslibI.nsIRDFLiteral)
            var packageVersion = version.Value;

          this.o.mRemoteVersion = packageVersion;

          if (url instanceof jslibI.nsIRDFLiteral)
            var packageURL = url.Value;

          this.o.mRemoteURL = packageURL;
          jslibDebugMsg("packageURL", packageURL);

          // callback function
          if (typeof(this.o.mCallback)=="function")
            this.o.mCallback();

          this.o.verifyVersions();

          sink.removeXMLSinkObserver(this);
          jslibQI(sink, "nsIRDFDataSource");
        }
      };

      var ds = RDF.GetDataSource(this.mRemoteFile);
      this.mDataSource = ds;
      jslibQI(ds, "nsIRDFXMLSink");
      ds.addXMLSinkObserver(observer);
      // add autoupdate object as property to observer
      observer.o = this;
    },
    verifyVersions : function () 
    {
      this.mLocalVersion = this.getLocalVersion();
      // strip out any version dots. 
      // rv = remote version, lv = local version
      var rv = parseInt(this.mRemoteVersion.replace(/\./g, ""), 10);
      var lv = parseInt(this.mLocalVersion.replace(/\./g, ""), 10);

      if (rv > lv) {
        var message = this.mPackageName
                    + " version: "
                    + this.mRemoteVersion
                    + " is now available for download"
                    + "\nWould you like to update now?";
        var ps = jslibGetService("@mozilla.org/embedcomp/prompt-service;1", "nsIPromptService");
        // check to see if Ignore Updates is set
        var prefs = new Prefs();
        const pref = "jslib.autoupdate.checkForUpdates";
        var prefValue;
        if (prefs.getType(pref) == 0)
          prefValue = true;
        else
          prefValue = prefs.getBool(pref);
          
        jslibPrint("type: "+prefValue);
        jslibPrint("check: "+prefs.getBool(pref));

        // if no pref value we bolt
        if (!prefValue)
          return;
        var checkValue = { value:prefValue };
        try {
          // XXX yes, I know these strings need localizaton
          // Brian, you are good at that! :)
          var conf = ps.confirmCheck(this.mContent,
                                     "AutoUpdate",
                                     message,
                                     "Always Check for New Updates",
                                     checkValue);
        } catch(e) { jslibDebug(e); }

        jslibPrint("checkValue: "+checkValue.value);
        // XXX if checkbox is set let's set the pref
        prefs.setBool(pref, checkValue.value);
        prefs.save();

        jslibPrint("confirm: "+conf);
        if (checkValue.value && conf)
          this.autoupdate();
        else
          jslibDebug("No Update Made");
      } else {
        jslibDebug("Local Version: "+this.mLocalVersion);
        jslibDebug("Remote Version: "+this.mRemoteVersion);
        jslibDebug("No Update Necessary");
      }
    },
    // returns the installed local package version from chrome/chrome.rdf
    getLocalVersion : function () 
    {
      var rv;
      var du = new DirUtils();
      var f = "file://"+du.getChromeDir()+"/chrome.rdf";
      var RDF = this.RDF;
      var ds = RDF.GetDataSourceBlocking(f);
      var packres = RDF.GetResource("urn:mozilla:package:" + this.mPackageName);
      var packageVersionPred = RDF.GetResource(this.CHROME_NS + "packageVersion")
      var version = ds.GetTarget(packres, packageVersionPred, true);

      if (version instanceof jslibI.nsIRDFLiteral)
        rv = version.Value;

      return rv;
      
    },
    get RDF ()
    {
      return jslibGetService("@mozilla.org/rdf/rdf-service;1", "nsIRDFService");
    },
    get datasource ()
    {
      return this.mDataSource;
    },
    autoupdate : function () 
    {
      if (typeof(loadURI) == "function")
        loadURI(this.mRemoteURL);
      else
        this.mContent.location = this.mRemoteURL;
    }
  }


} // END BLOCK JS_LOADED CHECK
    
// If jslib base library is not loaded, dump this error.
else
{  
    dump("JS_AUTOUPDATE library not loaded:\n"                     +
         " \tTo load use: chrome://jslib/content/jslib.js\n"       +
         " \tThen: include (jslib_autoupdate);\n\n");
}
