/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.ui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Iterator;
import org.mozdev.MacroTracker.classes.*;
import org.mozdev.MacroTracker.toolkit.*;
import org.mozdev.MacroTracker.toolkit.guiPanels.*;

import com.trfenv.rlk.Debug;

/**
 *A Database Creation form that provides a GUI for the user to create a new
 *MacroTrackerDatabase from.
 *
 *@author R.J. Keller <rlk@trfenv.com>
 */
public class frmDatabaseCreation extends JFrame implements ActionListener
{
	private MTextField txtDatabaseName;
	
	private addRemovePanel pnlStatus;
	private addRemovePanel pnlResolution;
	private addRemovePanel pnlPriority;
	private addRemovePanel pnlSeverity;
	
	private JButton btnSave;
	private JButton btnCancel;
	
	private void saveDatabase()
	{
		JFileChooser fileChooser = new JFileChooser();
		fileChooser.showSaveDialog(this);
		
		iBugDatabase newDatabase = new MacroTrackerDatabase();
		
		newDatabase.setName(txtDatabaseName.getText());
		
		//Add Statuses to bug database.
		for (Iterator i = pnlStatus.getData(); i.hasNext();)
		{
			newDatabase.status.add((String)i.next());
		}
		
		//Add Resolution's to Bug Database
		for (Iterator i = pnlResolution.getData(); i.hasNext();)
		{
			newDatabase.resolution.add((String)i.next());
		}
	}
	
	public frmDatabaseCreation()
	{
		super("Bug Database Creation");

		setSize(414, 448);
		org.mozdev.MacroTracker.main.MacroTracker.centerFrame(this);

		//simpleButtonPanel class creates a JPanel with a left-aligned
		//FlowLayout and adds a single component to it. This is used for
		//convincence instead of having to make the same panel over and over
		//again.
		class simpleButtonPanel extends JPanel
		{
			public simpleButtonPanel(Component component)
			{
				this.setLayout(new FlowLayout(FlowLayout.LEFT));
				this.add(component);
			}
		}
		
		getContentPane().setLayout(new BorderLayout());
		
		JTabbedPane tbpMain = new JTabbedPane();
		getContentPane().add(tbpMain, BorderLayout.CENTER);
		
		//-- BEGIN GENERAL TAB --//
		JPanel pnlGeneral = new JPanel();
		pnlGeneral.setLayout( new BorderLayout() );
		
		//adding txtDatabaseName
		JPanel pnlGeneralTop = new JPanel();
		pnlGeneralTop.setLayout( new BorderLayout() );

		pnlGeneralTop.add( new JLabel("Name of database: "), BorderLayout.WEST );
		
		txtDatabaseName = new MTextField();
		pnlGeneralTop.add(txtDatabaseName, BorderLayout.CENTER);

		pnlGeneral.add(pnlGeneralTop, BorderLayout.NORTH);

		//Status and Resolution panel. The GUI for this is automatically
		//generated by the org.mozdev.MacroTracker.toolkit.guiPanels.addRemovePanel
		//class.
		//
		//Adding pnlStatus and pnlResolution
		JPanel pnlGeneralCenter = new JPanel(new GridLayout(4,1));
		pnlStatus = new addRemovePanel("Status", new String[] {
			"UNCONFIRMED",
			"NEW",
			"ASSIGNED",
			"REOPENED",
			"RESOLVED",
			"VERIFIED",
			"CLOSED"
			} );
		pnlResolution = new addRemovePanel("Resolution", new String[] {
			"FIXED",
			"INVALID",
			"WONTFIX",
			"DUPLICATE",
			"WORKSFORME",
			"MOVED"
			});
		pnlPriority = new addRemovePanel("Priority", new String[] {
			"P1",
			"P2",
			"P3",
			"P4",
			"P5"
		});
		pnlSeverity = new addRemovePanel("Severity", new String[] {
			"Blocker",
			"Critical",
			"Major",
			"Minor",
			"Trivial",
			"Enhancement"
		});
		
		
		pnlGeneralCenter.add(pnlStatus);
		pnlGeneralCenter.add(pnlResolution);
		pnlGeneralCenter.add(pnlPriority);
		pnlGeneralCenter.add(pnlSeverity);
		
		pnlGeneral.add(pnlGeneralCenter, BorderLayout.CENTER);
		
		tbpMain.addTab("General", new MScrollPane(pnlGeneral));
		
		//-- END GENERAL TAB --//
		
		//-- BEGIN USERS TAB --//
		
		JPanel pnlUsers = new UserEditorPanel();
		JPanel innerPanel = new JPanel(new FlowLayout());
		innerPanel.add(pnlUsers);
		
		JScrollPane scroller = new JScrollPane(innerPanel);
		scroller.setBorder(null);
		tbpMain.addTab("Users", scroller);
		
		//-- END USERS TAB --//
		
		//-- BEGIN PRODUCT TAB --//

		//-- END PRODUCT TAB --//
		
		//-- BOTTOM BUTTONS --//
		btnSave = new JButton("Save");
		btnCancel = new JButton("Cancel");
		
		JPanel pnlBottom = new JPanel(new FlowLayout());
		pnlBottom.add(btnSave);
		pnlBottom.add(btnCancel);
		
		btnCancel.addActionListener(this);
		btnSave.addActionListener(this);
		
		getContentPane().add(pnlBottom, BorderLayout.SOUTH);
		

		Debug.createObject(this);
	}
	
	public void actionPerformed(ActionEvent event)
	{
		if (event.getSource() == btnCancel)
		//click event: btnCancel
		{
			//The user wants to cancel, so hide the form.
			setVisible(false);
		}
		else if (event.getSource() == btnSave)
		{
			JFileChooser fileChooser = new JFileChooser();
			fileChooser.setFileFilter(StandardComponents.generateFileFilter());
			int success = fileChooser.showSaveDialog(this);
			
			if (success == JFileChooser.APPROVE_OPTION)
			{
			}			
		}
	}
}