/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.classes;

import java.util.*;
import org.mozdev.MacroTracker.classes.*;
import org.mozdev.MacroTracker.classes.bug.*;

/**
 *Bug Database class is a Database of Bugs, Products, Users and other
 *information that can help a software developer effectively track bugs
 *in an open-source, public environment.
 *
 *Other classes used:
 *<ul>
 *<li><strong>User</strong>: Permissions for each user and their name and email address.</li>
 *<li><strong>Bug</strong>: This is where individual bug information is held. The list of
 *bugs is held in this class.</li>
 *<li><strong>Product</strong>: All of the products that MacroTracker has bugs
 *for.</li>
 *</ul>
 *
 *In order to save the database to a file, you need to run the saveDatabase(Database)
 *function in org.mozdev.MacroTracker.main.MacroTracker class. There is also
 *a openDatabase(String fileName) function that can be used to open a bugDatabase.
 *
 *The master bug database that should be modified is at org.mozdev.MacroTracker.main.MacroTracker.masterBugDatabase.
 *You should not make a new database object unless you want to create a brand new
 *database to save to a file.
 *
 *@author R.J. Keller <rlk@trfenv.com>
 *@see Bug
 *@see User
 *@see Product
 */
public interface iBugDatabase
{
	String getName();
	void setName(String aName);

	public void addUser(User aUser);
	public User getUser(int aIndex);
	public int userCount();
	public Iterator userIterator();

	public void addBug(Bug aUser);
	public Bug getBug(int aIndex);
	public int bugCount();

//ToDo: Removing for now so MacroTracker compiles. Need to set this up later.
//	String getUserName(String aUserName);
	boolean isValidUser(String aUser);

	public void addProduct(Product aUser);
	public Product getProduct(int aIndex);
	public int productCount();
	public Iterator productIterator();
	
	StatusManager status = new StatusManager();
	StatusManager resolution = new StatusManager();
}