/*
 * Decompiled with CFR 0.152.
 */
package org.mozdev.MacroTracker.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class frmMiniBrowser
extends JFrame
implements ActionListener {
    private JEditorPane mContentsArea = new JEditorPane();
    private Stack forwardURL;
    private Stack backURL;
    private JButton forwardButton;
    private JButton backButton;
    private JButton homeButton;

    public frmMiniBrowser(String string) {
        super("Browser");
        this.mContentsArea.setEditable(false);
        this.mContentsArea.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                frmMiniBrowser.this.backURL.push(frmMiniBrowser.this.mContentsArea.getPage().toString());
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    frmMiniBrowser.this.loadURL(hyperlinkEvent.getURL().toString());
                }
            }
        });
        this.forwardURL = new Stack();
        this.backURL = new Stack();
        this.loadURL(string);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.mContentsArea), "Center");
        JToolBar jToolBar = new JToolBar();
        this.backButton = new JButton();
        this.forwardButton = new JButton();
        this.backButton.addActionListener(this);
        this.forwardButton.addActionListener(this);
        try {
            this.forwardButton.setIcon(new ImageIcon(frmMiniBrowser.class.getResource("/images/Forward24.gif"), "New Database"));
            this.backButton.setIcon(new ImageIcon(frmMiniBrowser.class.getResource("/images/Back24.gif"), "Open Database"));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "An error has occured when loading the MacroTracker MiniBrowser. Try reinstalling the software.");
            exception.printStackTrace();
        }
        jToolBar.add(this.backButton);
        jToolBar.add(this.forwardButton);
        this.getContentPane().add((Component)jToolBar, "North");
        this.setSize(700, 500);
    }

    private void loadURL(String string) {
        System.err.println("Loading MiniBrowser URL: " + string);
        try {
            this.mContentsArea.setPage(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.forwardButton) {
            if (!this.forwardURL.isEmpty()) {
                String string = (String)this.forwardURL.pop();
                this.backURL.push(string);
                this.loadURL(string);
            }
        } else if (actionEvent.getSource() == this.backButton && !this.backURL.isEmpty()) {
            String string = (String)this.backURL.pop();
            this.forwardURL.push(string);
            this.loadURL(string);
        }
    }
}

