const LEVEL_ERROR = 1
const LEVEL_WARN = 2
const LEVEL_INFO = 3
const LEVEL_DEBUG = 4

function LogManager(){}
	
LogManager.prototype = {

	allLoggers : new Array(),
	
	defaultLogger : new Logger('default', 'info', new ConsoleAppender()),
	
	getLogger : function(name){
		for(i=0; i < this.allLoggers.length; i++){
				if(name == this.allLoggers[i].name)
					return this.allLoggers[i];
			}
			
		return this.defaultLogger;
	},
		
	error : function(name, msg){
		this.getLogger(name).error(msg);
	},
	
	warn : function(name, msg){
		this.getLogger(name).warn(msg);
	},
		
	info : function(name, msg){
		this.getLogger(name).info(msg);
	},
		
	debug : function(name, msg){
		this.getLogger(name).debug(msg);
	},
		
	QueryInterface: function(aIID)
  	{
   	 	if (!aIID.equals(nsILogManager) &&    
     	   !aIID.equals(nsISupports))
      	throw Components.results.NS_ERROR_NO_INTERFACE;
    	return this;
  	}
}

function Logger(name, levelString, appender){
	this.name = name;
	this.appender = appender;
	this.level = LEVEL_ERROR;
	if("warn" == levelString){
		this.level = LEVEL_WARN;
	}else if("info" == levelString){
		this.level = LEVEL_INFO;
	}else if("debug" == levelString){
		this.level = LEVEL_DEBUG;
	}
		
	this.error = function(msg){
		if(this.level >= LEVEL_ERROR)
			this.appender.write(this.name + ' --- ERROR: ' + msg);
	}
	
	this.warn = function(msg){
		if(this.level >= LEVEL_WARN)
			this.appender.write(this.name + ' --- WARN: ' + msg);
	}
	
	this.info = function(msg){
		if(this.level >= LEVEL_INFO)
			this.appender.write(this.name + ' --- INFO: ' + msg);
	}
		
    this.debug = function(msg){
		if(this.level >= LEVEL_DEBUG)
			this.appender.write(this.name + ' --- DEBUG: ' + msg);
	}	
}


function ConsoleAppender(){
	this.write = function(msg){
		print(msg);
	}
}

function FileAppender(fileName){
	this.fileName = fileName;
	this.write = function(msg){
		var file = Components.classes["@mozilla.org/file/directory_service;1"]
		                 .getService(Components.interfaces.nsIProperties)
	                     .get("ProfD", Components.interfaces.nsIFile);
	                     
		file.append(this.fileName);
		
		// file is nsIFile, data is a string
		var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
                         .createInstance(Components.interfaces.nsIFileOutputStream);

		var fileOption = file.exists()? (0x02 | 0x10) : (0x02 | 0x08 | 0x20);
		foStream.init(file, fileOption, 0664, 0); 
		foStream.write(msg + '\n', msg.length + 1);
		foStream.close();
	}
}

function print(msg){
	var consoleService = Components.classes["@mozilla.org/consoleservice;1"]
                                 .getService(Components.interfaces.nsIConsoleService);
  	consoleService.logStringMessage(msg);
}


function parseConfigFile(){
	try{
		var file = Components.classes["@mozilla.org/file/directory_service;1"]
	                     .getService(Components.interfaces.nsIProperties)
	                     .get("ProfD", Components.interfaces.nsIFile);
	                     
		file.append('log4m.config');
		if(!file.exists() || file.isDirectory())
			return [];
		print('found log4m.config');
		// open an input stream from file
		var istream = Components.classes["@mozilla.org/network/file-input-stream;1"]
	                        .createInstance(Components.interfaces.nsIFileInputStream);
		istream.init(file, 0x01, 0444, 0);
		istream.QueryInterface(Components.interfaces.nsILineInputStream);

		// read and parse file
		var line = {}, loggers = [], hasmore;
		do {
	  		hasmore = istream.readLine(line);
			var logger = stringToLogger(line.value);
			if(logger)	  		
	  			loggers.push(logger); 
		} while(hasmore);
		
		istream.close();
		print('find ' + loggers.length + ' loggers.');
		return loggers;
	}catch(anError){
		return [];
	}
}

function stringToLogger(s){
	print(s);
	if(null == s) 
		return null;
	
	var str = deleteWhiteSpace(s);
	try{
		var parts = str.split('=');
		var name = parts[0].split('.')[1].toLowerCase();
		var levelAppender = parts[1].split(',');
		var level = levelAppender[0];
		var appenderStr = levelAppender[1];
		var appender = new ConsoleAppender();
		if(0 == appenderStr.indexOf('file')){
			var logFile = appenderStr.split(':')[1];
			appender = new FileAppender(logFile);
		}
		
		print(name + ' ' + level + ' ' + appender);
		return new Logger(name, level, appender);
	}catch(e){
		return null;
	}
}

function deleteWhiteSpace(str){
	return str.replace(/\s/g, '');
}

/********************************************************/
const nsILogManager = Components.interfaces.nsILogManager;
const nsISupports = Components.interfaces.nsISupports;
const CLASS_ID = Components.ID("{F4EE1D15-4EC8-4753-9A1B-3BCBD35E1563}");
const CLASS_NAME = "Log Manager Javascript XPCOM Component";
const CONTRACT_ID = "@log4m/logmanager;1";

var LogManagerFactory = {
  createInstance: function (aOuter, aIID)
  {
    if (aOuter != null)
      throw Components.results.NS_ERROR_NO_AGGREGATION;
    
    print('generate a new instance of LogManager');
    var logManager = (new LogManager()).QueryInterface(aIID);
	logManager.allLoggers = parseConfigFile();
    return logManager;
  }
};

/***********************************************************
module definition (xpcom registration)
***********************************************************/
var LogManagerModule = {
  _firstTime: true,
  registerSelf: function(aCompMgr, aFileSpec, aLocation, aType)
  {
    aCompMgr = aCompMgr.
        QueryInterface(Components.interfaces.nsIComponentRegistrar);
    aCompMgr.registerFactoryLocation(CLASS_ID, CLASS_NAME, 
        CONTRACT_ID, aFileSpec, aLocation, aType);
  },

  unregisterSelf: function(aCompMgr, aLocation, aType)
  {
    aCompMgr = aCompMgr.
        QueryInterface(Components.interfaces.nsIComponentRegistrar);
    aCompMgr.unregisterFactoryLocation(CLASS_ID, aLocation);        
  },
  
  getClassObject: function(aCompMgr, aCID, aIID)
  {
  	var consoleService = Components.classes["@mozilla.org/consoleservice;1"]
                                 .getService(Components.interfaces.nsIConsoleService);
    if (!aIID.equals(Components.interfaces.nsIFactory))
      throw Components.results.NS_ERROR_NOT_IMPLEMENTED;

    if (aCID.equals(CLASS_ID))
      return LogManagerFactory;

    throw Components.results.NS_ERROR_NO_INTERFACE;
  },

  canUnload: function(aCompMgr) { return true; }
};

/***********************************************************
module initialization

When the application registers the component, this function
is called.
***********************************************************/
function NSGetModule(aCompMgr, aFileSpec) { return LogManagerModule; }