/****************************************************************************
**  LatchWordBB - Vocabulary retention and reinforcement toolbar for Mozilla
**  Copyright (c) 2003  Charles Melhorn
**
**  This file is part of LatchWordBB.
**
**  LatchWordBB is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  LatchWordBB is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**
**  Or see the GNU web site at: http://www.gnu.org
**
****************************************************************************/ 

const gLWVersion = "version 0.4"; 

const gLWconstants =
{
  PT_BOOL:         0,  // preference types
  PT_INT:          1,
  PT_STR:          2,
  PT_UNICHAR:      3,
  PT_UNICHARLOCAL: 4,
  PT_FILE:         5,

  OM_SAMEWIN:      0,  // open method - for lookup results
  OM_NEWWIN:       1,
  OM_NEWTAB:       2,

  QT_DRILL:        0,  // quiz types
  QT_BYDEF:        1,
  QT_BYWORD:       2,

  QM_MANUAL:       0,  // quiz modes
  QM_AUTO:         1,

  QS_WAIT_FOR_HINT:      0,  // quiz states
  QS_WAIT_FOR_QUESTION_TO_EXPIRE: 1,
  QS_PAUSE_AFTER_ANSWER:    2
}


var RDFC = '@mozilla.org/rdf/container;1';
RDFC = Components.classes[RDFC].createInstance();
RDFC = RDFC.QueryInterface(Components.interfaces.nsIRDFContainer);

var RDFCUtils = '@mozilla.org/rdf/container-utils;1';
RDFCUtils = Components.classes[RDFCUtils].getService();
RDFCUtils = RDFCUtils.QueryInterface(Components.interfaces.nsIRDFContainerUtils);

var RDF = '@mozilla.org/rdf/rdf-service;1'
RDF = Components.classes[RDF].getService();
RDF = RDF.QueryInterface(Components.interfaces.nsIRDFService);


var gLWPrefService = Components.classes["@mozilla.org/preferences-service;1"]
                            .getService(Components.interfaces.nsIPrefService);

const gLWUserPreferenceInfo = 
{
  lookup_openmethod: {defvalue: gLWconstants.OM_SAMEWIN, prefname: "lookupopenmethod", preftype: gLWconstants.PT_INT},
  lookup_name1:      {defvalue: "M-W.com Dictionary", prefname: "lookupname1", preftype: gLWconstants.PT_STR},
  lookup_URL1:       {defvalue: "http://www.m-w.com/cgi-bin/dictionary?va=", prefname: "lookupurl1", preftype: gLWconstants.PT_STR},
  lookup_pref1:      {defvalue: true, prefname: "lookuppref1", preftype: gLWconstants.PT_BOOL},
  lookup_name2:      {defvalue: "M-W.com Thesaurus", prefname: "lookupname2", preftype: gLWconstants.PT_STR},
  lookup_URL2:       {defvalue: "http://www.m-w.com/cgi-bin/thesaurus?book=Thesaurus&va=", prefname: "lookupurl2", preftype: gLWconstants.PT_STR},
  lookup_pref2:      {defvalue: false, prefname: "lookuppref2", preftype: gLWconstants.PT_BOOL},
  lookup_name3:      {defvalue: "Bartleby.com Amer. Her. Dict.", prefname: "lookupname3", preftype: gLWconstants.PT_STR},
  lookup_URL3:       {defvalue: "http://www.bartleby.com/cgi-bin/texis/webinator/sitesearch?FILTER=col61&x=16&y=9&query=", prefname: "lookupurl3", preftype: gLWconstants.PT_STR},
  lookup_pref3:      {defvalue: true, prefname: "lookuppref3", preftype: gLWconstants.PT_BOOL},
  lookup_name4:      {defvalue: "Bartleby.com Quotations", prefname: "lookupname4", preftype: gLWconstants.PT_STR},
  lookup_URL4:       {defvalue: "http://www.bartleby.com/cgi-bin/texis/webinator/sitesearch?FILTER=colQuotations&x=0&y=0&query=", prefname: "lookupurl4", preftype: gLWconstants.PT_STR},
  lookup_pref4:      {defvalue: false, prefname: "lookuppref4", preftype: gLWconstants.PT_BOOL},
  lookup_name5:      {defvalue: "WordNet", prefname: "lookupname5", preftype: gLWconstants.PT_STR},
  lookup_URL5:       {defvalue: "http://www.cogsci.princeton.edu/cgi-bin/webwn2.0?stage=1&word=", prefname: "lookupurl5", preftype: gLWconstants.PT_STR},
  lookup_pref5:      {defvalue: false, prefname: "lookuppref5", preftype: gLWconstants.PT_BOOL},

  wod_openmethod:    {defvalue: gLWconstants.OM_SAMEWIN, prefname: "wodopenmethod", preftype: gLWconstants.PT_INT},
  wod_name1:         {defvalue: "M-W.com", prefname: "wodname1", preftype: gLWconstants.PT_STR},
  wod_URL1:          {defvalue: "http://www.m-w.com/cgi-bin/mwwod.pl", prefname: "wodurl1", preftype: gLWconstants.PT_STR},
  wod_pref1:         {defvalue: true, prefname: "wodpref1", preftype: gLWconstants.PT_BOOL},
  wod_name2:         {defvalue: "dictionary.com", prefname: "wodname2", preftype: gLWconstants.PT_STR},
  wod_URL2:          {defvalue: "http://dictionary.reference.com/wordoftheday/", prefname: "wodurl2", preftype: gLWconstants.PT_STR},
  wod_pref2:         {defvalue: true, prefname: "wodpref2", preftype: gLWconstants.PT_BOOL},
  wod_name3:         {defvalue: "A.Word.A.Day", prefname: "wodname3", preftype: gLWconstants.PT_STR},
  wod_URL3:          {defvalue: "http://www.wordsmith.org/words/today.html", prefname: "wodurl3", preftype: gLWconstants.PT_STR},
  wod_pref3:         {defvalue: true, prefname: "wodpref3", preftype: gLWconstants.PT_BOOL},
  wod_name4:         {defvalue: "Bartleby Daily", prefname: "wodname4", preftype: gLWconstants.PT_STR},
  wod_URL4:          {defvalue: "http://www.bartleby.com/", prefname: "wodurl4", preftype: gLWconstants.PT_STR},
  wod_pref4:         {defvalue: false, prefname: "wodpref4", preftype: gLWconstants.PT_BOOL},
  wod_name5:         {defvalue: "New York Times", prefname: "wodname5", preftype: gLWconstants.PT_STR},
  wod_URL5:          {defvalue: "http://www.nytimes.com/learning/students/wordofday/", prefname: "wodurl5", preftype: gLWconstants.PT_STR},
  wod_pref5:         {defvalue: false, prefname: "wodpref5", preftype: gLWconstants.PT_BOOL},

  quiz_type:         {defvalue: gLWconstants.QT_BYDEF, prefname: "quiztype", preftype: gLWconstants.PT_INT},
  quiz_mode:         {defvalue: gLWconstants.QM_MANUAL, prefname: "quizmode", preftype: gLWconstants.PT_INT},
  drill_font_size:   {defvalue: "small", prefname: "drillfontsize", preftype: gLWconstants.PT_STR},
  hintbox_color:     {defvalue: "#00FFFF", prefname: "hintboxcolor", preftype: gLWconstants.PT_STR},
  auto_interval:     {defvalue: 10, prefname: "autointerval", preftype: gLWconstants.PT_INT},
  auto_answer_pause: {defvalue: 4, prefname: "autoanswerpause", preftype: gLWconstants.PT_INT},
  autohint:          {defvalue: true, prefname: "autohint", preftype: gLWconstants.PT_BOOL},
  ignore_quiz_mode:  {defvalue: false, prefname: "ignorequizmode", preftype: gLWconstants.PT_BOOL},

  default_wordlist:  {defvalue: "", prefname: "defwordlist", preftype: gLWconstants.PT_STR},
  prefNode:          gLWPrefService.getBranch("extensions.lw."),

  getPrefValue:      function(prefId_str)
  {
    return (getLWUserPreference(this[prefId_str].prefname,
                                this[prefId_str].defvalue,
                                this[prefId_str].preftype,
                                this.prefNode));
  },

  getPrefDefValue:   function(prefId_str)
  {
    return this[prefId_str].defvalue;
  },

  setPrefValue:      function(prefId_str, value)
  {
    setLWUserPreference(this[prefId_str].prefname,
                        value,
                        this[prefId_str].preftype,
                        this.prefNode);
  }

}


function lwVocabWord(word, definition)
{
  this.word = word;
  this.definition = definition;
}


var gDefWordList = [];  // main word list array
var gWordPtrArr = [];   // used to index into word list array
var gWdIdx = 0;         // current word index

gQuizController =
{
  waiting_for_answer: false,
  quiz_type:          gLWconstants.QT_BYDEF,
  quiz_mode:          gLWconstants.QM_AUTO,
  quiz_state:         gLWconstants.QS_WAIT_FOR_QUESTION_TO_EXPIRE,
  autohint:           true,
  time_per_word:      10,
  pause_per_word:     4,
  timercount:         0,
  timerID:            null
}


function displayLatchWordBar(bChecked_str)  // takes attribute value as argument
{
  if (bChecked_str == "true")
   { 
     document.getElementById('latchwordBB-tbar').setAttribute("hidden", "false");
   }
  else
   { 
     document.getElementById('latchwordBB-tbar').setAttribute("hidden", "true");

     // need to set menu item attribute 'checked' to false to persist it - if not
     // explicitly set false, the attribute is simply removed.
     document.getElementById('latchwordBB-menuitem').setAttribute("checked", "false");
   }

}


function lwBuildLookupMenu(mpopup)
{
  var name_pref, url_pref, preferred_pref, bPref_str, name;
  var nodesArr = mpopup.getElementsByTagName("menuitem");

  for (var i=0; i < nodesArr.length; i++)
   { 
     if (nodesArr[i].id != "lw-search-all-mitem")
      {
        name_pref = "lookup_name" + (i+1);
        name = gLWUserPreferenceInfo.getPrefValue(name_pref);
        nodesArr[i].label = name;
        nodesArr[i].setAttribute("tooltiptext", name);
        url_pref = "lookup_URL" + (i+1);
        nodesArr[i].value = gLWUserPreferenceInfo.getPrefValue(url_pref);
        preferred_pref = "lookup_pref" + (i+1);
        bPref_str = (gLWUserPreferenceInfo.getPrefValue(preferred_pref) ? "true" : "false");
        nodesArr[i].setAttribute("checked", bPref_str);
      }
   }
}



function lwBuildWodMenu(mpopup)
{
  var name_pref, url_pref, preferred_pref, bPref_str, name;
  var nodesArr = mpopup.getElementsByTagName("menuitem");

  for (var i=0; i < nodesArr.length; i++)
   { 
     if (nodesArr[i].id != "lw-wod-all-mitem")
      {
        name_pref = "wod_name" + (i+1);
        name = gLWUserPreferenceInfo.getPrefValue(name_pref);
        nodesArr[i].label = name;
        nodesArr[i].setAttribute("tooltiptext", name);
        url_pref = "wod_URL" + (i+1);
        nodesArr[i].value = gLWUserPreferenceInfo.getPrefValue(url_pref);
        preferred_pref = "wod_pref" + (i+1);
        bPref_str = (gLWUserPreferenceInfo.getPrefValue(preferred_pref) ? "true" : "false");
        nodesArr[i].setAttribute("checked", bPref_str);
      }
   }
}


function lwGetSelectedText()
{   
    // derived from googlebarPaste() routine

    var textBox;

    // attempt to grab selected text from the current document (tab)
    var text = _content.document.getSelection();

    // if nothing selected in the document then perhaps there is a
    // selection contained within a frame of the current document
    if (!text) {
        for (var i = 0; i < _content.frames.length; i++) {
            text = _content.frames[i].document.getSelection();
            if (text) break;
        }
    }

    // sanitize the selection
    if (text)
     {
       text = text.replace(/^\W+/, ''); // trim leading non-alnum chars
       text = text.replace(/\W+$/, ''); // trim trailing non-alnum chars
       text = text.replace(/\s+/, ' '); // conflate whitespace runs
     }

    // if still no text has been found then check the
    // lookup text box
    if (!text) {
        textBox = document.getElementById("lw-lookup-tbox");
        text = textBox.value;
    }

    return text;
}


function lwSearchWebReference(target)
{ 
  var query_prefix_str = "";
  var lookup_value = lwGetSelectedText();

  if (lookup_value == "")
    lookup_value = prompt("Please enter word");
 

  if ((lookup_value) && (lookup_value != ""))
   {
     if (target == document.getElementById("lw-search-all-mitem"))
      {
         // used OpenBookmarkGroupFromResource() in navigator.js
         // and openNewTabWith() in contentAreaUtils.js as references
         // for opening new tab(s)

         var ref_array = document.getElementById("lw-lookup-menupopup").childNodes;
         var browser = getBrowser();
         var tabPanels = browser.mPanelContainer.childNodes;
         var tabCount = tabPanels.length;

         for (var i = 0; i < ref_array.length; i++)
          {
             if ( (ref_array[i].hasAttribute("checked")) &&
                  (ref_array[i].getAttribute("checked") == "true") )
               {
                 query_prefix_str = ref_array[i].getAttribute("value");
                 browser.addTab(query_prefix_str + lookup_value); // open link in new tab
               }
          }
            
         // Select the first tab in the group if we aren't loading in the background.
         if (!pref.getBoolPref("browser.tabs.loadInBackground")) {
           var tabs = browser.mTabContainer.childNodes;
           browser.selectedTab = tabs[tabCount];
         }
      }
     else 
      {
        var open_method = gLWUserPreferenceInfo.getPrefValue("lookup_openmethod");
        query_prefix_str = target.value;

        switch(open_method)
         {
           case gLWconstants.OM_SAMEWIN:
             loadURI(query_prefix_str + lookup_value);
             break;
  
           case gLWconstants.OM_NEWWIN:
             window.open(query_prefix_str + lookup_value, "_blank");
             break;

           case gLWconstants.OM_NEWTAB:
           default:
             var browser = getBrowser();
             var tabPanels = browser.mPanelContainer.childNodes;
             var tabCount = tabPanels.length;
             browser.addTab(query_prefix_str + lookup_value); // open link in new tab

             // Select the first tab in the group if we aren't loading in the background.
             if (!pref.getBoolPref("browser.tabs.loadInBackground"))
              {
                var tabs = browser.mTabContainer.childNodes;
                browser.selectedTab = tabs[tabCount];
              }
             break;
         }
      }
   }

  var lw_lookup_tbox = document.getElementById("lw-lookup-tbox");
  lw_lookup_tbox.value = lookup_value;
  lw_lookup_tbox.select();
}


function lwSearchDefaultReference()
{ 
  // no 'value' property for toolbarbuttons - need to
  // use getAttribute() to retrieve value
  var lookup_tbar_btn = document.getElementById("lw-lookup-menu-btn");
  var ref_index = parseInt(lookup_tbar_btn.getAttribute("value"));

  var reference_menu = document.getElementById("lw-lookup-menupopup");

  var default_ref_target = reference_menu.childNodes[ref_index];

  lwSearchWebReference(default_ref_target);

}


function lwOnSearchboxKeypress(e)
{
  // if 'Enter' key, perform default search or
  // submit quiz answer, depending on drill state

  if (e.keyCode == 13)    // enter key
   {
    var bDrill = document.getElementById("lw-drill-menuitem").getAttribute("checked");

    // hitting 'Enter' in lookup box while a quiz
    // is running will submit a quiz answer unless
    // "ignore_quiz_mode" override is true.

    if ( (bDrill != "true") ||
         (gLWUserPreferenceInfo.getPrefValue("ignore_quiz_mode") == true) )
      lwSearchDefaultReference();
    else
      lwSubmitAnswer();
   }
}


function lwGetWOD(wod_mitem)
{ 
  var wod_url_str = "";
 
  if (wod_mitem == document.getElementById("lw-wod-all-mitem"))
   {
     var ref_array = document.getElementById("lw-wod-menupopup").childNodes;
     var browser = getBrowser();
     var tabPanels = browser.mPanelContainer.childNodes;
     var tabCount = tabPanels.length;

     for (var i = 0; i < ref_array.length; i++)
      {
        if ( (ref_array[i].hasAttribute("checked")) &&
             (ref_array[i].getAttribute("checked") == "true") )
         {
           wod_url_str = ref_array[i].getAttribute("value");
           browser.addTab(wod_url_str); // open link in new tab
         }
      }
            
     // Select the first tab in the group if we aren't loading in the background.
     if (!pref.getBoolPref("browser.tabs.loadInBackground")) {
       var tabs = browser.mTabContainer.childNodes;
       browser.selectedTab = tabs[tabCount];
     }
   }
  else 
   {
     var open_method = gLWUserPreferenceInfo.getPrefValue("wod_openmethod");
     wod_url_str = wod_mitem.value;

     switch(open_method)
      {
        case gLWconstants.OM_SAMEWIN:
          loadURI(wod_url_str);
          break;

        case gLWconstants.OM_NEWWIN:
          window.open(wod_url_str, "_blank");
          break;

        case gLWconstants.OM_NEWTAB:
        default:
          var browser = getBrowser();
          var tabPanels = browser.mPanelContainer.childNodes;
          var tabCount = tabPanels.length;
          browser.addTab(wod_url_str); // open link in new tab

          // Select the first tab in the group if we aren't loading in the background.
          if (!pref.getBoolPref("browser.tabs.loadInBackground"))
           {
             var tabs = browser.mTabContainer.childNodes;
             browser.selectedTab = tabs[tabCount];
           }
          break;
      }
   }

}


function lwGetDefaultWOD()
{ 
  // no 'value' property for toolbarbuttons - need to
  // use getAttribute() to retrieve value
  var WOD_tbar_btn = document.getElementById("lw-WOD-menu-btn");
  var wod_index = parseInt(WOD_tbar_btn.getAttribute("value"));

  var wod_menu = document.getElementById("lw-wod-menupopup");

  var default_WOD_mitem = wod_menu.childNodes[wod_index];

  lwGetWOD(default_WOD_mitem);

}


function lwFocusLookupBox()
{
  var lookup_tbox = document.getElementById("lw-lookup-tbox");
  
  if (lookup_tbox.value)
    lookup_tbox.select();
  else
    lookup_tbox.focus();
}


function lwAddWordToVocabList()
{ 

  // initialize dialog input with currently selected
  // word, if any

  var new_word = lwGetSelectedText();  

  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
  var myWindow = windowManager.getMostRecentWindow("latchwordbb:wordlist");

  if (myWindow)
    myWindow.focus();
  else 
    window.openDialog('chrome://latchwordbb/content/dialogWordList.xul',
                      'lwWordList','chrome,centerscreen,resizable', 
                      gLWUserPreferenceInfo, new_word);

}


function lwOpenWordList()
{
  var windowManager = Components.classes['@mozilla.org/appshell/window-mediator;1'].getService(Components.interfaces.nsIWindowMediator);
  var myWindow = windowManager.getMostRecentWindow("latchwordbb:wordlist");

  if (myWindow)
    myWindow.focus();
  else 
    window.openDialog('chrome://latchwordbb/content/dialogWordList.xul',
                      'lwWordList','chrome,centerscreen,resizable', gLWUserPreferenceInfo);
}


function lwEnableQuizBox(bEnable_str)
{ 
  var iRand, temp_value = 0;

  if (bEnable_str == "true")
   {
     gQuizController.quiz_type = gLWUserPreferenceInfo.getPrefValue("quiz_type");
     gQuizController.quiz_mode = gLWUserPreferenceInfo.getPrefValue("quiz_mode");

     //
     // Configure quiz box
     //
     document.getElementById("lw-definition-tbox").disabled = false;
     document.getElementById("lw-hint-tbox").disabled = false;
     document.getElementById("lw-pass-btn").disabled = false;

     if (gQuizController.quiz_type == gLWconstants.QT_BYDEF)
      {
        document.getElementById("lw-hint-btn").disabled = false;
        document.getElementById("lw-answer-btn").disabled = false;
      }

     var pref_color = gLWUserPreferenceInfo.getPrefValue("hintbox_color");
     var hint_style_str = "margin-left: 0; margin-right: 0; background-color: " + pref_color;
     document.getElementById("lw-hint-tbox").setAttribute("style", hint_style_str);

     var pref_fontsize = gLWUserPreferenceInfo.getPrefValue("drill_font_size");
     document.getElementById("lw-hint-tbox").setAttribute("fontsize", pref_fontsize);
     document.getElementById("lw-hint-tbox").setAttribute("size", "12");

     // read-only=true makes background color gray, unless
     // explicitly set to another color
     var def_style_str = "margin-right: 0; background-color: white"
     document.getElementById("lw-definition-tbox").setAttribute("style", def_style_str);

     //
     // Load vocabulary database
     //

     var dsURI_str = gLWUserPreferenceInfo.getPrefValue("default_wordlist");

     if (dsURI_str == "")  // if no wordlist specified, use default which
                           // should reside in "UserProfileDir/Latchwordbb"
      {
        var dirServCID = '@mozilla.org/file/directory_service;1';
        var propIF = Components.interfaces.nsIProperties;
        var dirServ = Components.classes[dirServCID].getService(propIF);

        var userProfileDir = dirServ.get("ProfD", Components.interfaces.nsIFile);
        userProfileDir.append("Latchwordbb");
        userProfileDir.append("defVocab.rdf");

        // Get IOService to convert file path to URI
        var serv = Components.classes["@mozilla.org/network/io-service;1"].
                   getService(Components.interfaces.nsIIOService);
        if (!serv) {
          throw Components.results.ERR_FAILURE;
        }
        var uri = serv.newFileURI(userProfileDir);
        dsURI_str = uri.spec;
      }

     // Create an RDF/XML datasource using the XPCOM Component Manager
     var v_dsource = Components.classes['@mozilla.org/rdf/datasource;1?name=xml-datasource']
       .createInstance(Components.interfaces.nsIRDFDataSource);

     // The nsIRDFRemoteDataSource interface has the interfaces
     // that we need to setup the datasource.
     v_dsource = v_dsource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);

     try {
       v_dsource.Init(dsURI_str); // throws an exception if URL already in use
     }
     catch(err) {
       v_dsource = RDF.GetDataSource(dsURI_str);
     }     
    
     var v_dsource = v_dsource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
     v_dsource.Refresh(true);

     //
     // initialize wordlist array with database entries
     //

     gDefWordList.splice(0, gDefWordList.length);      // reset Wordlist and Ptr arrays
     gWordPtrArr.splice(0, gWordPtrArr.length);

     var rootnode = RDF.GetResource("urn:words:data");
     RDFC.Init(v_dsource,rootnode);
     var elems = RDFC.GetElements();

     var target, entryword, entrydefinition;
     while (elems.hasMoreElements())
      {
        var elem = elems.getNext();
        elem = elem.QueryInterface(Components.interfaces.nsIRDFResource);
        target = v_dsource.GetTarget(elem, RDF.GetResource("http://latchwordbb.mozdev.org/rdf#word"), true);
        if(target)
         {
           try {
             target = target.QueryInterface(Components.interfaces.nsIRDFLiteral);
           }
           catch(e) {
             target = target.QueryInterface(Components.interfaces.nsIRDFResource);
           }
           entryword = target.Value;
         }
        target = v_dsource.GetTarget(elem, RDF.GetResource("http://latchwordbb.mozdev.org/rdf#definition"), true);
        if(target)
         {
           try {
             target = target.QueryInterface(Components.interfaces.nsIRDFLiteral);
           }
           catch(e) {
             target = target.QueryInterface(Components.interfaces.nsIRDFResource);
           }
           entrydefinition = target.Value;
         }

        gDefWordList.push(new lwVocabWord(entryword, entrydefinition));
      }

     //
     // Initialize pointer array (used to index into wordlist array)
     //
     for (var i=0; i < gDefWordList.length; i++)
      {
        gWordPtrArr[i] = i;
      }
      
     for (I=0; I < gWordPtrArr.length; I++) 
      {
        iRand = (Math.random())*(gWordPtrArr.length);
        iRand = Math.floor(iRand);
        temp_value = gWordPtrArr[I];
        gWordPtrArr[I] = gWordPtrArr[iRand];
        gWordPtrArr[iRand] = temp_value;
      }  
  
     //
     // Start quiz/drill and initialize auto-quiz state and flags, if necessary 
     //

     gWdIdx = gDefWordList.length;
     gQuizController.waiting_for_answer = false;

     lwNextDrillWord();

     if (gQuizController.quiz_mode == gLWconstants.QM_AUTO)
      {
        gQuizController.timercount = 0;
        gQuizController.autohint = gLWUserPreferenceInfo.getPrefValue("autohint");
        gQuizController.time_per_word = gLWUserPreferenceInfo.getPrefValue("auto_interval");
        gQuizController.pause_per_word = gLWUserPreferenceInfo.getPrefValue("auto_answer_pause");

        if ( (gQuizController.quiz_type == gLWconstants.QT_BYDEF) && 
                (gQuizController.autohint == true) )
           gQuizController.quiz_state = gLWconstants.QS_WAIT_FOR_HINT;
        else
           gQuizController.quiz_state = gLWconstants.QS_WAIT_FOR_QUESTION_TO_EXPIRE;

        gQuizController.timerID = setInterval( "lwAutoQuizManager()", 1000 );
      }
   }
  else
   {
     document.getElementById("lw-definition-tbox").disabled = true;
     document.getElementById("lw-hint-tbox").disabled = true;
     document.getElementById("lw-hint-btn").disabled = true;
     document.getElementById("lw-answer-btn").disabled = true;
     document.getElementById("lw-pass-btn").disabled = true;

     var hint_style_str = "margin-left: 0; margin-right: 0"
     document.getElementById("lw-hint-tbox").setAttribute("style", hint_style_str);

     var def_style_str = "margin-right: 0"
     document.getElementById("lw-definition-tbox").setAttribute("style", def_style_str);

     document.getElementById("lw-hint-tbox").value = "";
     document.getElementById("lw-definition-tbox").value = "";

     if (gQuizController.timerID != null)
       clearInterval(gQuizController.timerID);
   }

}


function lwNextDrillWord()
{
  gWdIdx++;

  if (gWdIdx >= gDefWordList.length)
    gWdIdx = 0;
  
  var wdPtr = gWordPtrArr[gWdIdx];

  switch(gQuizController.quiz_type)
   {
     case gLWconstants.QT_DRILL:

        document.getElementById("lw-hint-tbox").value = gDefWordList[wdPtr].word;
        document.getElementById("lw-definition-tbox").value = gDefWordList[wdPtr].definition;
        document.getElementById("lw-defpopup-desc").value = gDefWordList[wdPtr].definition;
        break;

     case gLWconstants.QT_BYDEF:

        document.getElementById("lw-definition-tbox").value = gDefWordList[wdPtr].definition;
        document.getElementById("lw-defpopup-desc").value = gDefWordList[wdPtr].definition;

        var iRand = 0;
        var hint_str = "";
        for (var i=0; i < gDefWordList[wdPtr].word.length; i++)
          hint_str += "-";

        // reveal a random letter, other than the first, in the
        // hint string
        iRand = (Math.random())*(gDefWordList[wdPtr].word.length - 1);
        iRand = Math.floor(iRand);

        hint_str = hint_str.substring(0,iRand+1) + gDefWordList[wdPtr].word[iRand+1] +
                   hint_str.substring(iRand+2); 

        document.getElementById("lw-hint-tbox").value = hint_str;

        gQuizController.waiting_for_answer = true;
        break;

     case gLWconstants.QT_BYWORD:

        document.getElementById("lw-hint-tbox").value = gDefWordList[wdPtr].word;
        document.getElementById("lw-definition-tbox").value = "";
        document.getElementById("lw-defpopup-desc").value = "";
        gQuizController.waiting_for_answer = true;
        break;

     default:

   }

  gQuizController.timercount = 0;

  if ( (gQuizController.quiz_type == gLWconstants.QT_BYDEF) && 
        (gQuizController.autohint == true) )
    gQuizController.quiz_state = gLWconstants.QS_WAIT_FOR_HINT;
  else
    gQuizController.quiz_state = gLWconstants.QS_WAIT_FOR_QUESTION_TO_EXPIRE;
}


function lwProvideHint()
{ 
  var old_hint_str, hint_str;

  var wdPtr = gWordPtrArr[gWdIdx];
  var hint_tbox = document.getElementById("lw-hint-tbox");

  old_hint_str = hint_tbox.value;
  hint_str = gDefWordList[wdPtr].word[0] + old_hint_str.substring(1);
  hint_tbox.value = hint_str;
}


function lwPass(e)
{
  if (e.shiftKey == true)
    lwNextDrillWord();

  else
   {
    if (gQuizController.waiting_for_answer == true)
      lwShowAnswer();
    else
      lwNextDrillWord();
   }
}


function lwSubmitAnswer()
{ 
  // submitting an answer is only supported for
  // prompt-by-definition quiz type

  if (gQuizController.quiz_type == gLWconstants.QT_BYDEF)
   {
     if (gQuizController.waiting_for_answer == true)
      {       
        var wdPtr = gWordPtrArr[gWdIdx];
        var answer_box = document.getElementById("lw-lookup-tbox");

        if (answer_box.value == gDefWordList[wdPtr].word)
         {
           answer_box.value = "";
           lwShowAnswer();      
         }
      }
     else
       lwNextDrillWord();
   }
}


function lwShowAnswer()
{
  var wdPtr = gWordPtrArr[gWdIdx];

  switch(gQuizController.quiz_type)
   {
     case gLWconstants.QT_BYDEF:
        document.getElementById("lw-hint-tbox").value = gDefWordList[wdPtr].word;
        break;
     case gLWconstants.QT_BYWORD:
        document.getElementById("lw-definition-tbox").value = gDefWordList[wdPtr].definition;
        document.getElementById("lw-defpopup-desc").value = gDefWordList[wdPtr].definition;
        break;
     default:
        alert("Unexpected quiz type in lwShowAnswer()");
        break;
   }

  gQuizController.waiting_for_answer = false;
  gQuizController.quiz_state = gLWconstants.QS_PAUSE_AFTER_ANSWER;
  gQuizController.timercount = 0;
}


function lwDisplayDefinitionPopup(anchor_element)
{
  if (anchor_element.disabled != true)
   {
     var definition_popup = document.getElementById("lw-definition-popup");
     definition_popup.showPopup(anchor_element, -1, -1, 'tooltip', 'bottomleft', 'topleft');
   }
}


function lwAutoQuizManager()
{
  gQuizController.timercount++;

  switch(gQuizController.quiz_state)
   {
     case gLWconstants.QS_WAIT_FOR_HINT:

        if (gQuizController.timercount >= gQuizController.time_per_word/2)
         {
           lwProvideHint();
           gQuizController.quiz_state = gLWconstants.QS_WAIT_FOR_QUESTION_TO_EXPIRE;
         }
        break;

     case gLWconstants.QS_WAIT_FOR_QUESTION_TO_EXPIRE:

        if (gQuizController.timercount >= gQuizController.time_per_word)
         {
           if (gQuizController.quiz_type == gLWconstants.QT_DRILL)
              lwNextDrillWord();
           else
            {
              lwShowAnswer();
            }
         }
        break;

     case gLWconstants.QS_PAUSE_AFTER_ANSWER:
       
        if (gQuizController.timercount >= gQuizController.pause_per_word)
         {
           lwNextDrillWord();
         }
        break;

     default:
   }
      
}


//function initLatchWord()
//{
//document.getElementById("lw-hotlist-btn").setAttribute("disabled", "true");
//window.removeEventListener("load", initLatchWord, true);
//
//}
//
//
//function lwWatchFocus(event)
//{
//var lookup_tbox = document.getElementById("lw-lookup-tbox");
//
//if ((event.target != lookup_tbox)  && (glwRefocus == false))
// {
//  setTimeout("lwStickyFocusLookupBox()", 100);
// }
//
////lookup_tbox.value += event.target.tagName;
//
//}
//
//glwRefocus = false;
//function lwStickyFocusLookupBox()
//{
//var lookup_tbox = document.getElementById("lw-lookup-tbox");
//glwRefocus = true;
//lookup_tbox.focus();
//glwRefocus = false;
//
//}

