/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.mozilla.jrex.JRexFactory;
import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.ui.JRexCanvas;
import org.mozilla.jrex.ui.JRexFindConfig;
import org.mozilla.jrex.ui.JRexMenuBar;
import org.mozilla.jrex.ui.JRexPrintPreviewToolBar;
import org.mozilla.jrex.ui.JRexResource;
import org.mozilla.jrex.window.JRexBrowserData;
import org.mozilla.jrex.window.JRexWindowManager;

public class JRexMenuBarImpl
implements JRexMenuBar {
    private static final String className = JRexMenuBarImpl.class.getName();
    private static final String FL_FILE = JRexResource.getString("FL_FILE");
    private static final String FL_NEW_WINDOW = JRexResource.getString("FL_NEW_WINDOW");
    private static final String FL_NEW_TAB = JRexResource.getString("FL_NEW_TAB");
    private static final String FL_OPEN_FILE = JRexResource.getString("FL_OPEN_FILE");
    private static final String FL_CLOSE = JRexResource.getString("FL_CLOSE");
    private static final String FL_CLOSE_TAB = JRexResource.getString("FL_CLOSE_TAB");
    private static final String FL_CLOSE_WINDOW = JRexResource.getString("FL_CLOSE_WINDOW");
    private static final String FL_SAVE_PAGE = JRexResource.getString("FL_SAVE_PAGE");
    private static final String FL_SEND_PAGE = JRexResource.getString("FL_SEND_PAGE");
    private static final String FL_PAGE_SETUP = JRexResource.getString("FL_PAGE_SETUP");
    private static final String FL_PRINT_PREVIEW = JRexResource.getString("FL_PRINT_PREVIEW");
    private static final String FL_PRINT = JRexResource.getString("FL_PRINT");
    private static final String FL_EXIT = JRexResource.getString("FL_EXIT");
    private static final String ED_EDIT = JRexResource.getString("ED_EDIT");
    private static final String ED_UNDO = JRexResource.getString("ED_UNDO");
    private static final String ED_REDO = JRexResource.getString("ED_REDO");
    private static final String ED_CUT = JRexResource.getString("ED_CUT");
    private static final String ED_COPY = JRexResource.getString("ED_COPY");
    private static final String ED_PASTE = JRexResource.getString("ED_PASTE");
    private static final String ED_DELETE = JRexResource.getString("ED_DELETE");
    private static final String ED_SELECT_ALL = JRexResource.getString("ED_SELECT_ALL");
    private static final String ED_SELECT_NONE = JRexResource.getString("ED_SELECT_NONE");
    private static final String ED_FIND = JRexResource.getString("ED_FIND");
    private static final String ED_FIND_AGAIN = JRexResource.getString("ED_FIND_AGAIN");
    private static final String VW_VIEW = JRexResource.getString("VW_VIEW");
    private static final String VW_TOOLBARS = JRexResource.getString("VW_TOOLBARS");
    private static final String VW_TOOL_NAV = JRexResource.getString("VW_TOOL_NAV");
    private static final String VW_TOOL_BOOKMARK = JRexResource.getString("VW_TOOL_BOOKMARK");
    private static final String VW_TOOL_CUST = JRexResource.getString("VW_TOOL_CUST");
    private static final String VW_STATUS_BAR = JRexResource.getString("VW_STATUS_BAR");
    private static final String VW_SIDE_BAR = JRexResource.getString("VW_SIDE_BAR");
    private static final String VW_SIDE_DOWNLOAD = JRexResource.getString("VW_SIDE_DOWNLOAD");
    private static final String VW_SIDE_BOOKMARK = JRexResource.getString("VW_SIDE_BOOKMARK");
    private static final String VW_SIDE_HISTORY = JRexResource.getString("VW_SIDE_HISTORY");
    private static final String VW_STOP = JRexResource.getString("VW_STOP");
    private static final String VW_RELOAD = JRexResource.getString("VW_RELOAD");
    private static final String VW_INC_TEXT_SIZE = JRexResource.getString("VW_INC_TEXT_SIZE");
    private static final String VW_DEC_TEXT_SIZE = JRexResource.getString("VW_DEC_TEXT_SIZE");
    private static final String VW_PAGE_SRC = JRexResource.getString("VW_PAGE_SRC");
    private static final String VW_FULL_SCREEN = JRexResource.getString("VW_FULL_SCREEN");
    private static final String GO_GO = JRexResource.getString("GO_GO");
    private static final String GO_BACK = JRexResource.getString("GO_BACK");
    private static final String GO_FORWARD = JRexResource.getString("GO_FORWARD");
    private static final String GO_HOME = JRexResource.getString("GO_HOME");
    private static final String GO_HISTORY = JRexResource.getString("GO_HISTORY");
    private static final int GO_DYN_INDEX = 4;
    private static final String BOOKMARK = JRexResource.getString("BOOKMARK");
    private static final String ADD_TO_BOOKMARK = JRexResource.getString("ADD_TO_BOOKMARK");
    private static final String MANAGE_BOOKMARK = JRexResource.getString("MANAGE_BOOKMARK");
    private static final String TOOLS = JRexResource.getString("TOOLS");
    private static final String TOOL_JS_CONSOLE = JRexResource.getString("TOOL_JS_CONSOLE");
    private static final String TOOL_PAGE_INFO = JRexResource.getString("TOOL_PAGE_INFO");
    private static final String TOOL_OPTIONS = JRexResource.getString("TOOL_OPTIONS");
    private static final String HELP = JRexResource.getString("HELP");
    private static final String HELP_REL_NOTES = JRexResource.getString("HELP_REL_NOTES");
    private static final String HELP_ABOUT = JRexResource.getString("HELP_ABOUT");
    private static final String HELP_OK = JRexResource.getString("HELP_OK");
    private FileMenuActionListener fileMenuAL;
    private EditMenuActionListener editMenuAL;
    private ViewMenuActionListener viewMenuAL;
    private GoMenuActionListener goMenuAL;
    private BookmarksMenuActionListener bookmarksMenuAL;
    private ToolsMenuActionListener toolsMenuAL;
    private HelpMenuActionListener helpMenuAL;
    private JRexCanvas browser;
    private int mode;
    private JRexWindowManager windowManager = (JRexWindowManager)JRexFactory.getInstance().getImplInstance("WindowManager");
    private JMenuBar menuBar;
    static /* synthetic */ Class class$org$mozilla$jrex$ui$JRexMenuBarImpl$FileMenuActionListener;
    static /* synthetic */ Class class$org$mozilla$jrex$ui$JRexMenuBarImpl$EditMenuActionListener;

    public JRexMenuBarImpl() {
        this.fileMenuAL = new FileMenuActionListener(this);
        this.editMenuAL = new EditMenuActionListener(this);
        this.viewMenuAL = new ViewMenuActionListener();
        this.goMenuAL = new GoMenuActionListener();
        this.bookmarksMenuAL = new BookmarksMenuActionListener();
        this.toolsMenuAL = new ToolsMenuActionListener();
        this.helpMenuAL = new HelpMenuActionListener(this);
    }

    public synchronized void setBrowser(JRexCanvas browser) {
        this.browser = browser;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.createMenuBar();
        }
        return this.menuBar;
    }

    private void createMenuBar() {
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.createFileMenu());
        this.menuBar.add(this.createEditMenu());
        this.menuBar.add(this.createViewMenu());
        this.menuBar.add(this.createGoMenu());
        this.menuBar.add(this.createBookmarksMenu());
        this.menuBar.add(this.createToolsMenu());
        this.menuBar.add(this.createHelpMenu());
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu(FL_FILE);
        JMenuItem menuItem = new JMenuItem(FL_NEW_WINDOW);
        menuItem.addActionListener(this.fileMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(FL_NEW_WINDOW));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(FL_NEW_WINDOW), 2));
        fileMenu.add(menuItem);
        menuItem = new JMenuItem(FL_NEW_TAB);
        menuItem.addActionListener(this.fileMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(FL_NEW_TAB));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(FL_NEW_TAB), 2));
        fileMenu.add(menuItem);
        menuItem = new JMenuItem(FL_OPEN_FILE);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(FL_OPEN_FILE));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(FL_OPEN_FILE), 2));
        menuItem.addActionListener(this.fileMenuAL);
        fileMenu.add(menuItem);
        menuItem = new JMenuItem(FL_CLOSE);
        menuItem.addActionListener(this.fileMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(FL_CLOSE));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(FL_CLOSE), 2));
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        menuItem = new JMenuItem(FL_SAVE_PAGE);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(FL_SAVE_PAGE));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(FL_SAVE_PAGE), 2));
        menuItem.addActionListener(this.fileMenuAL);
        fileMenu.add(menuItem);
        menuItem = new JMenuItem(FL_SEND_PAGE);
        menuItem.addActionListener(this.fileMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(FL_SEND_PAGE));
        fileMenu.add(menuItem);
        menuItem = new JMenuItem(FL_PAGE_SETUP);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(FL_PAGE_SETUP));
        menuItem.addActionListener(this.fileMenuAL);
        fileMenu.add(menuItem);
        menuItem = new JMenuItem(FL_PRINT_PREVIEW);
        menuItem.addActionListener(this.fileMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(FL_PRINT_PREVIEW));
        fileMenu.add(menuItem);
        menuItem = new JMenuItem(FL_PRINT);
        menuItem.addActionListener(this.fileMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(FL_PRINT));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(FL_PRINT), 2));
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        menuItem = new JMenuItem(FL_EXIT);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(FL_EXIT));
        menuItem.addActionListener(this.fileMenuAL);
        fileMenu.add(menuItem);
        return fileMenu;
    }

    private JMenu createEditMenu() {
        JMenu editMenu = new JMenu(ED_EDIT);
        editMenu.setMnemonic(JRexResource.getMnemonicChar(ED_EDIT));
        JMenuItem menuItem = new JMenuItem(ED_UNDO);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(ED_UNDO));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(ED_UNDO), 2));
        menuItem.addActionListener(this.editMenuAL);
        editMenu.add(menuItem);
        menuItem = new JMenuItem(ED_REDO);
        menuItem.addActionListener(this.editMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(ED_REDO));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(ED_REDO), 2));
        editMenu.add(menuItem);
        editMenu.addSeparator();
        menuItem = new JMenuItem(ED_CUT);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(ED_CUT));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(ED_CUT), 2));
        menuItem.addActionListener(this.editMenuAL);
        editMenu.add(menuItem);
        menuItem = new JMenuItem(ED_COPY);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(ED_COPY));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(ED_COPY), 2));
        menuItem.addActionListener(this.editMenuAL);
        editMenu.add(menuItem);
        menuItem = new JMenuItem(ED_PASTE);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(ED_PASTE));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(ED_PASTE), 2));
        menuItem.addActionListener(this.editMenuAL);
        editMenu.add(menuItem);
        menuItem = new JMenuItem(ED_DELETE);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(ED_DELETE));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        menuItem.addActionListener(this.editMenuAL);
        editMenu.add(menuItem);
        editMenu.addSeparator();
        menuItem = new JMenuItem(ED_SELECT_ALL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(ED_SELECT_ALL));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(ED_SELECT_ALL), 2));
        menuItem.addActionListener(this.editMenuAL);
        editMenu.add(menuItem);
        menuItem = new JMenuItem(ED_SELECT_NONE);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(ED_SELECT_NONE));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(ED_SELECT_NONE), 2));
        menuItem.addActionListener(this.editMenuAL);
        editMenu.add(menuItem);
        editMenu.addSeparator();
        menuItem = new JMenuItem(ED_FIND);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(ED_FIND));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(ED_FIND), 2));
        menuItem.addActionListener(this.editMenuAL);
        editMenu.add(menuItem);
        menuItem = new JMenuItem(ED_FIND_AGAIN);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(ED_FIND_AGAIN));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(ED_FIND_AGAIN), 2));
        menuItem.addActionListener(this.editMenuAL);
        editMenu.add(menuItem);
        return editMenu;
    }

    private JMenu createViewMenu() {
        JMenu viewMenu = new JMenu(VW_VIEW);
        viewMenu.setMnemonic(JRexResource.getMnemonicChar(VW_VIEW));
        JMenu viewToolMenu = new JMenu(VW_TOOLBARS);
        viewToolMenu.setMnemonic(JRexResource.getMnemonicChar(VW_TOOLBARS));
        viewMenu.add(viewToolMenu);
        JMenuItem menuItem = new JCheckBoxMenuItem(VW_TOOL_NAV);
        menuItem.addActionListener(this.viewMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(VW_TOOL_NAV));
        viewToolMenu.add(menuItem);
        menuItem = new JCheckBoxMenuItem(VW_TOOL_BOOKMARK);
        menuItem.addActionListener(this.viewMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(VW_TOOL_BOOKMARK));
        viewToolMenu.add(menuItem);
        viewToolMenu.addSeparator();
        menuItem = new JMenuItem(VW_TOOL_CUST);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(VW_TOOL_CUST));
        menuItem.addActionListener(this.viewMenuAL);
        viewToolMenu.add(menuItem);
        menuItem = new JCheckBoxMenuItem(VW_STATUS_BAR);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(VW_STATUS_BAR));
        menuItem.addActionListener(this.viewMenuAL);
        viewMenu.add(menuItem);
        JMenu viewSideBarMenu = new JMenu(VW_SIDE_BAR);
        viewSideBarMenu.setMnemonic(JRexResource.getMnemonicChar(VW_SIDE_BAR));
        viewMenu.add(viewSideBarMenu);
        viewMenu.addSeparator();
        menuItem = new JCheckBoxMenuItem(VW_SIDE_DOWNLOAD);
        menuItem.addActionListener(this.viewMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(VW_SIDE_DOWNLOAD));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(VW_SIDE_DOWNLOAD), 2));
        viewSideBarMenu.add(menuItem);
        menuItem = new JCheckBoxMenuItem(VW_SIDE_BOOKMARK);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(VW_SIDE_BOOKMARK));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(VW_SIDE_BOOKMARK), 2));
        menuItem.addActionListener(this.viewMenuAL);
        viewSideBarMenu.add(menuItem);
        viewMenu.addSeparator();
        menuItem = new JCheckBoxMenuItem(VW_SIDE_HISTORY);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(VW_SIDE_HISTORY));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(VW_SIDE_HISTORY), 2));
        menuItem.addActionListener(this.viewMenuAL);
        viewSideBarMenu.add(menuItem);
        menuItem = new JMenuItem(VW_STOP);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(VW_STOP));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        menuItem.addActionListener(this.viewMenuAL);
        viewMenu.add(menuItem);
        menuItem = new JMenuItem(VW_RELOAD);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(VW_RELOAD));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(VW_RELOAD), 2));
        menuItem.addActionListener(this.viewMenuAL);
        viewMenu.add(menuItem);
        viewMenu.addSeparator();
        menuItem = new JMenuItem(VW_INC_TEXT_SIZE);
        menuItem.addActionListener(this.viewMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(VW_INC_TEXT_SIZE));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(VW_INC_TEXT_SIZE), 2));
        viewMenu.add(menuItem);
        menuItem = new JMenuItem(VW_DEC_TEXT_SIZE);
        menuItem.addActionListener(this.viewMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(VW_DEC_TEXT_SIZE));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(VW_DEC_TEXT_SIZE), 2));
        viewMenu.add(menuItem);
        viewMenu.addSeparator();
        menuItem = new JMenuItem(VW_PAGE_SRC);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(VW_PAGE_SRC));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(VW_PAGE_SRC), 2));
        menuItem.addActionListener(this.viewMenuAL);
        viewMenu.add(menuItem);
        menuItem = new JMenuItem(VW_FULL_SCREEN);
        menuItem.addActionListener(this.viewMenuAL);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        viewMenu.add(menuItem);
        return viewMenu;
    }

    private JMenu createGoMenu() {
        JMenu goMenu = new JMenu(GO_GO);
        goMenu.setMnemonic(JRexResource.getMnemonicChar(GO_GO));
        JMenuItem menuItem = new JMenuItem(GO_BACK);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(GO_BACK));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(226, 8));
        menuItem.addActionListener(this.goMenuAL);
        goMenu.add(menuItem);
        menuItem = new JMenuItem(GO_FORWARD);
        menuItem.addActionListener(this.goMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(GO_FORWARD));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(227, 8));
        goMenu.add(menuItem);
        menuItem = new JMenuItem(GO_HOME);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(GO_HOME));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(36, 8));
        menuItem.addActionListener(this.goMenuAL);
        goMenu.add(menuItem);
        goMenu.addSeparator();
        goMenu.addSeparator();
        menuItem = new JMenuItem(GO_HISTORY);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(GO_HISTORY));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(GO_HISTORY), 2));
        menuItem.addActionListener(this.goMenuAL);
        goMenu.add(menuItem);
        return goMenu;
    }

    private void addDynamicGoMenu(JMenu goMenu) {
    }

    private void removeDynamicGoMenu(JMenu goMenu) {
    }

    private JMenu createBookmarksMenu() {
        JMenu bookMarksMenu = new JMenu(BOOKMARK);
        bookMarksMenu.setMnemonic(JRexResource.getMnemonicChar(BOOKMARK));
        JMenuItem menuItem = new JMenuItem(ADD_TO_BOOKMARK);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(ADD_TO_BOOKMARK));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(ADD_TO_BOOKMARK), 2));
        menuItem.addActionListener(this.bookmarksMenuAL);
        bookMarksMenu.add(menuItem);
        menuItem = new JMenuItem(MANAGE_BOOKMARK);
        menuItem.addActionListener(this.bookmarksMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(MANAGE_BOOKMARK));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(MANAGE_BOOKMARK), 2));
        bookMarksMenu.add(menuItem);
        bookMarksMenu.addSeparator();
        this.addDynamicBookmarksMenu(bookMarksMenu);
        return bookMarksMenu;
    }

    private void addDynamicBookmarksMenu(JMenu bookMarksMenu) {
    }

    private JMenu createToolsMenu() {
        JMenu toolsMenu = new JMenu(TOOLS);
        toolsMenu.setMnemonic(JRexResource.getMnemonicChar(TOOLS));
        JMenuItem menuItem = new JMenuItem(TOOL_JS_CONSOLE);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(TOOL_JS_CONSOLE));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(TOOL_JS_CONSOLE), 2));
        menuItem.addActionListener(this.toolsMenuAL);
        toolsMenu.add(menuItem);
        menuItem = new JMenuItem(TOOL_PAGE_INFO);
        menuItem.addActionListener(this.toolsMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(TOOL_PAGE_INFO));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(TOOL_PAGE_INFO), 2));
        toolsMenu.add(menuItem);
        toolsMenu.addSeparator();
        menuItem = new JMenuItem(TOOL_OPTIONS);
        menuItem.addActionListener(this.toolsMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(TOOL_OPTIONS));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(TOOL_OPTIONS), 2));
        toolsMenu.add(menuItem);
        return toolsMenu;
    }

    private JMenu createHelpMenu() {
        JMenu helpMenu = new JMenu(HELP);
        helpMenu.setMnemonic(JRexResource.getMnemonicChar(HELP));
        JMenuItem menuItem = new JMenuItem(HELP_REL_NOTES);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(HELP_REL_NOTES));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(HELP_REL_NOTES), 2));
        menuItem.addActionListener(this.helpMenuAL);
        helpMenu.add(menuItem);
        menuItem = new JMenuItem(HELP_ABOUT);
        menuItem.addActionListener(this.helpMenuAL);
        menuItem.setMnemonic(JRexResource.getMnemonicChar(HELP_ABOUT));
        menuItem.setAccelerator(KeyStroke.getKeyStroke((int)JRexResource.getAcceleratorChar(HELP_ABOUT), 2));
        helpMenu.add(menuItem);
        helpMenu.addSeparator();
        return helpMenu;
    }

    private static class HelpMenuActionListener
    implements ActionListener {
        JRexMenuBarImpl menuBar;

        HelpMenuActionListener(JRexMenuBarImpl menuBar) {
            this.menuBar = menuBar;
        }

        public void actionPerformed(ActionEvent ae) {
            String action = ae.getActionCommand();
            if (JRexL.on) {
                JRexL.log(className, "**** actionPerformed() -->action <" + action + "> HELP_ABOUT <" + HELP_ABOUT + "> ****");
            }
            if (action.equals(HELP_ABOUT)) {
                Frame frame = (Frame)this.menuBar.windowManager.getBrowserWindow(this.menuBar.browser.getJRexPeer());
                JDialog hlpDlg = new JDialog(frame, "About JRex", true);
                hlpDlg.setDefaultCloseOperation(2);
                JPanel panel = new JPanel(new BorderLayout());
                panel.add(new JLabel(JRexResource.getIcon("jrex_main")));
                JButton btn = new JButton(HELP_OK);
                btn.addActionListener(new ActionListener(this, hlpDlg){
                    private final /* synthetic */ JDialog val$hlpDlg;
                    private final /* synthetic */ HelpMenuActionListener this$0;
                    {
                        this.this$0 = this$0;
                        this.val$hlpDlg = val$hlpDlg;
                    }

                    public void actionPerformed(ActionEvent ae) {
                        this.val$hlpDlg.dispose();
                    }
                });
                JPanel btnPanel = new JPanel();
                btnPanel.setBackground(Color.white);
                btn.setBackground(Color.white);
                btnPanel.add(btn);
                panel.add((Component)btnPanel, "South");
                hlpDlg.setContentPane(panel);
                hlpDlg.pack();
                hlpDlg.setLocationRelativeTo(frame);
                hlpDlg.setVisible(true);
            }
        }
    }

    private static class ToolsMenuActionListener
    implements ActionListener {
        ToolsMenuActionListener() {
        }

        public void actionPerformed(ActionEvent ae) {
        }
    }

    private static class BookmarksMenuActionListener
    implements ActionListener {
        BookmarksMenuActionListener() {
        }

        public void actionPerformed(ActionEvent ae) {
        }
    }

    private static class GoMenuActionListener
    implements ActionListener {
        GoMenuActionListener() {
        }

        public void actionPerformed(ActionEvent ae) {
        }
    }

    private static class ViewMenuActionListener
    implements ActionListener {
        ViewMenuActionListener() {
        }

        public void actionPerformed(ActionEvent ae) {
        }
    }

    private static class EditMenuActionListener
    implements ActionListener {
        String className = (class$org$mozilla$jrex$ui$JRexMenuBarImpl$EditMenuActionListener == null ? (class$org$mozilla$jrex$ui$JRexMenuBarImpl$EditMenuActionListener = JRexMenuBarImpl.class$("org.mozilla.jrex.ui.JRexMenuBarImpl$EditMenuActionListener")) : class$org$mozilla$jrex$ui$JRexMenuBarImpl$EditMenuActionListener).getName();
        JRexMenuBarImpl menuBar;

        EditMenuActionListener(JRexMenuBarImpl menuBar) {
            this.menuBar = menuBar;
        }

        public void actionPerformed(ActionEvent ae) {
            String action = ae.getActionCommand();
            if (JRexL.on) {
                JRexL.log(this.className, "**** actionPerformed() -->action <" + action + "> ****");
            }
            try {
                if (action.equals(ED_UNDO)) {
                    this.menuBar.browser.undo();
                } else if (action.equals(ED_REDO)) {
                    this.menuBar.browser.redo();
                } else if (action.equals(ED_CUT)) {
                    this.menuBar.browser.cut();
                } else if (action.equals(ED_COPY)) {
                    this.menuBar.browser.copy();
                } else if (action.equals(ED_PASTE)) {
                    this.menuBar.browser.paste();
                } else if (action.equals(ED_DELETE)) {
                    this.menuBar.browser.delete();
                } else if (action.equals(ED_SELECT_ALL)) {
                    this.menuBar.browser.selectAll();
                } else if (action.equals(ED_SELECT_NONE)) {
                    this.menuBar.browser.selectNone();
                } else if (action.equals(ED_FIND)) {
                    JRexFindConfig conf = new JRexFindConfig("to");
                    boolean found = this.menuBar.browser.find(conf);
                    if (JRexL.on) {
                        JRexL.log(this.className, "**** actionPerformed() -->ED_FIND found<" + found + "> ****");
                    }
                } else if (action.equals(ED_FIND_AGAIN)) {
                    boolean found = this.menuBar.browser.findAgain();
                    if (JRexL.on) {
                        JRexL.log(this.className, "**** actionPerformed() -->ED_FIND_AGAIN found<" + found + "> ****");
                    }
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }

    private static class FileMenuActionListener
    implements ActionListener {
        String className = (class$org$mozilla$jrex$ui$JRexMenuBarImpl$FileMenuActionListener == null ? (class$org$mozilla$jrex$ui$JRexMenuBarImpl$FileMenuActionListener = JRexMenuBarImpl.class$("org.mozilla.jrex.ui.JRexMenuBarImpl$FileMenuActionListener")) : class$org$mozilla$jrex$ui$JRexMenuBarImpl$FileMenuActionListener).getName();
        JRexMenuBarImpl menuBar;

        FileMenuActionListener(JRexMenuBarImpl menuBar) {
            this.menuBar = menuBar;
        }

        public void actionPerformed(ActionEvent ae) {
            String action = ae.getActionCommand();
            if (JRexL.on) {
                JRexL.log(this.className, "**** actionPerformed() -->action <" + action + "> ****");
            }
            try {
                if (action.equals(FL_NEW_WINDOW)) {
                    this.menuBar.windowManager.openNewWindow(this.menuBar.browser.getJRexPeer(), "", 0);
                } else if (action.equals(FL_NEW_TAB)) {
                    this.menuBar.windowManager.openNewTab(this.menuBar.browser.getJRexPeer(), "", 0);
                } else if (!(action.equals(FL_OPEN_FILE) || action.equals(FL_CLOSE) || action.equals(FL_CLOSE_TAB) || action.equals(FL_CLOSE_WINDOW))) {
                    if (action.equals(FL_SAVE_PAGE)) {
                        this.menuBar.browser.saveCurrentDocument("C:\\boot.html", "C:\\boot", null, 0, 0, null);
                    } else if (!action.equals(FL_SEND_PAGE)) {
                        if (action.equals(FL_PAGE_SETUP)) {
                            this.menuBar.browser.pageSetup();
                        } else if (action.equals(FL_PRINT_PREVIEW)) {
                            this.menuBar.browser.printPreview(true, false);
                            boolean isPrev = this.menuBar.browser.isPrintPreviewing();
                            while (isPrev && this.menuBar.browser.getPrintPreviewNumPages() == 0) {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (Exception ex) {}
                            }
                            JRexBrowserData data = this.menuBar.windowManager.getBrowserData(this.menuBar.browser.getJRexPeer());
                            ((JRexPrintPreviewToolBar)JRexFactory.getInstance().getImplInstance("JRexPrintPreviewToolBar")).show(this.menuBar.browser, data.getRootParent(), data.getWindow());
                        } else if (action.equals(FL_PRINT)) {
                            this.menuBar.browser.print(true, true);
                        } else if (action.equals(FL_EXIT)) {
                            JRexFactory.getInstance().shutdownEngine();
                            System.exit(0);
                        }
                    }
                }
            }
            catch (JRexException ex) {
                JRexL.printStackTrace(ex);
            }
        }
    }
}

