/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.event.window;

import org.mozilla.jrex.JRexFactory;
import org.mozilla.jrex.event.JRexEvent;
import org.mozilla.jrex.event.JRexEventHandler;
import org.mozilla.jrex.event.window.WindowEvent;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.window.JRexWindowManager;

public class WindowEventHandler
implements JRexEventHandler {
    private static final String className;
    private JRexWindowManager windowManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Object handleEvent(JRexEvent event) {
        if (JRexL.on) {
            JRexL.log(className, "**** handleEvent()-->event <" + event + "> ****");
        }
        if (!$assertionsDisabled && event == null) {
            throw new AssertionError();
        }
        WindowEvent wEvent = (WindowEvent)event.getData();
        if (JRexL.on) {
            JRexL.log(className, "**** handleEvent()-->wEvent <" + wEvent + "> ****");
        }
        if (!$assertionsDisabled && wEvent == null) {
            throw new AssertionError();
        }
        int winEventType = wEvent.getEventType();
        if (this.windowManager == null) {
            this.windowManager = (JRexWindowManager)JRexFactory.getInstance().getImplInstance("WindowManager");
        }
        switch (winEventType) {
            case 0: {
                if (JRexL.on) {
                    JRexL.log(className, "*** handleEvent()-->WIN_CREATE_EVENT ***");
                }
                int jrexPeer = this.windowManager.createWindow(wEvent);
                if (JRexL.on) {
                    JRexL.log(className, "**** handleEvent()-->createWindow jrexPeer<" + jrexPeer + "> ****");
                }
                return new Integer(jrexPeer);
            }
            case 1: {
                if (JRexL.on) {
                    JRexL.log(className, "*** handleEvent()-->WIN_SETMODAL_EVENT ***");
                }
                this.windowManager.setModal(wEvent);
                if (!JRexL.on) break;
                JRexL.log(className, "**** handleEvent()-->setModal ****");
                break;
            }
            case 2: {
                if (JRexL.on) {
                    JRexL.log(className, "*** handleEvent()-->WIN_RESIZE_EVENT ***");
                }
                this.windowManager.setSize(wEvent);
                if (!JRexL.on) break;
                JRexL.log(className, "**** handleEvent()-->setSize ****");
                break;
            }
            case 3: {
                if (JRexL.on) {
                    JRexL.log(className, "*** handleEvent()-->WIN_DESTROY_EVENT ***");
                }
                this.windowManager.destroyWindow(wEvent);
                if (JRexL.on) {
                    JRexL.log(className, "**** handleEvent()-->destroyWindow ****");
                }
                return null;
            }
            case 4: {
                if (JRexL.on) {
                    JRexL.log(className, "*** handleEvent()-->WIN_SET_TITLE_EVENT ***");
                }
                this.windowManager.setTitle(wEvent);
                if (!JRexL.on) break;
                JRexL.log(className, "**** handleEvent()-->setTitle ****");
                break;
            }
            case 5: {
                if (JRexL.on) {
                    JRexL.log(className, "*** handleEvent()-->WIN_CHROME_FLAG_EVENT ***");
                }
                this.windowManager.setChromeFlags(wEvent);
                if (!JRexL.on) break;
                JRexL.log(className, "**** handleEvent()-->setChromeFlags ****");
                break;
            }
            case 6: {
                if (JRexL.on) {
                    JRexL.log(className, "*** handleEvent()-->WIN_REALIZED_EVENT ***");
                }
                this.windowManager.setRealized(wEvent);
                if (!JRexL.on) break;
                JRexL.log(className, "**** handleEvent()-->setRealized ****");
                break;
            }
            default: {
                if (!JRexL.on) break;
                JRexL.log(className, "**** handleEvent()--> UNKNOW TYPE ****");
            }
        }
        return null;
    }

    static {
        $assertionsDisabled = !WindowEventHandler.class.desiredAssertionStatus();
        className = WindowEventHandler.class.getName();
    }
}

