/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jrex.selection;

import org.mozilla.jrex.exception.JRexException;
import org.mozilla.jrex.log.JRexL;
import org.mozilla.jrex.selection.JRexSelection;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;

public class JRexSelectionImpl
implements JRexSelection {
    private static final String className = JRexSelectionImpl.class.getName();
    private int jrexPeer = 0;

    public void setJRexPeer(int jrexPeer) {
        this.jrexPeer = jrexPeer;
    }

    public Node getAnchorNode() throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** getAnchorNode jrexPeer<" + this.jrexPeer + "> ****");
        }
        Node node = null;
        try {
            node = this.GetAnchorNode(this.jrexPeer);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** getAnchorNode node<" + node + "> ****");
        }
        return node;
    }

    public int getAnchorOffset() throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** getAnchorOffset jrexPeer<" + this.jrexPeer + "> ****");
        }
        int offset = 0;
        try {
            offset = this.GetAnchorOffset(this.jrexPeer);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** getAnchorOffset offset<" + offset + "> ****");
        }
        return offset;
    }

    public Node getFocusNode() throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** getFocusNode jrexPeer<" + this.jrexPeer + "> ****");
        }
        Node node = null;
        try {
            node = this.GetFocusNode(this.jrexPeer);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** getFocusNode node<" + node + "> ****");
        }
        return node;
    }

    public int getFocusOffset() throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** getFocusOffset jrexPeer<" + this.jrexPeer + "> ****");
        }
        int offset = 0;
        try {
            offset = this.GetFocusOffset(this.jrexPeer);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** getFocusOffset offset<" + offset + "> ****");
        }
        return offset;
    }

    public boolean getIsCollapsed() throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** getIsCollapsed jrexPeer<" + this.jrexPeer + "> ****");
        }
        boolean collapsed = false;
        try {
            collapsed = this.GetIsCollapsed(this.jrexPeer);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** getIsCollapsed collapsed<" + collapsed + "> ****");
        }
        return collapsed;
    }

    public int getRangeCount() throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** getRangeCount jrexPeer<" + this.jrexPeer + "> ****");
        }
        int count = 0;
        try {
            count = this.GetRangeCount(this.jrexPeer);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** getRangeCount count<" + count + "> ****");
        }
        return count;
    }

    public Range getRangeAt(int index) throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** getRangeAt jrexPeer<" + this.jrexPeer + "> index<" + index + "> ****");
        }
        Range range = null;
        try {
            range = this.GetRangeAt(this.jrexPeer, index);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** getRangeAt range<" + range + "> ****");
        }
        return range;
    }

    public void collapse(Node parentNode, int offset) throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** collapse jrexPeer<" + this.jrexPeer + "> parentNode<" + parentNode + "> offset<" + offset + "> ****");
        }
        try {
            this.Collapse(this.jrexPeer, parentNode, offset);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void extend(Node parentNode, int offset) throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** extend jrexPeer<" + this.jrexPeer + "> parentNode<" + parentNode + "> offset<" + offset + "> ****");
        }
        try {
            this.Extend(this.jrexPeer, parentNode, offset);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void collapseToStart() throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** collapseToStart jrexPeer<" + this.jrexPeer + "> ****");
        }
        try {
            this.CollapseToStart(this.jrexPeer);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void collapseToEnd() throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** collapseToEnd jrexPeer<" + this.jrexPeer + "> ****");
        }
        try {
            this.CollapseToEnd(this.jrexPeer);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public boolean containsNode(Node node, boolean entirelyContained) throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** containsNode jrexPeer<" + this.jrexPeer + "> node<" + node + "> entirelyContained<" + entirelyContained + "> ****");
        }
        boolean contains = false;
        try {
            contains = this.ContainsNode(this.jrexPeer, node, entirelyContained);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** containsNode jrexPeer<" + this.jrexPeer + "> contains<" + contains + "> ****");
        }
        return contains;
    }

    public void selectAllChildren(Node parentNode) throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** selectAllChildren jrexPeer<" + this.jrexPeer + "> parentNode<" + parentNode + "> ****");
        }
        try {
            this.SelectAllChildren(this.jrexPeer, parentNode);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void addRange(Range range) throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** addRange jrexPeer<" + this.jrexPeer + "> range<" + range + "> ****");
        }
        try {
            this.AddRange(this.jrexPeer, range);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void removeRange(Range range) throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** removeRange jrexPeer<" + this.jrexPeer + "> range<" + range + "> ****");
        }
        try {
            this.RemoveRange(this.jrexPeer, range);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void removeAllRanges() throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** removeAllRanges jrexPeer<" + this.jrexPeer + "> ****");
        }
        try {
            this.RemoveAllRanges(this.jrexPeer);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void deleteFromDocument() throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** deleteFromDocument jrexPeer<" + this.jrexPeer + "> ****");
        }
        try {
            this.DeleteFromDocument(this.jrexPeer);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public void selectionLanguageChange(boolean langRTL) throws JRexException {
        if (JRexL.on) {
            JRexL.log(className, "**** selectionLanguageChange jrexPeer<" + this.jrexPeer + "> langRTL<" + langRTL + "> ****");
        }
        try {
            this.SelectionLanguageChange(this.jrexPeer, langRTL);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
    }

    public String toString() {
        if (JRexL.on) {
            JRexL.log(className, "**** toString jrexPeer<" + this.jrexPeer + "> ****");
        }
        String string = null;
        try {
            string = this.ToString(this.jrexPeer);
        }
        catch (JRexException ex) {
            JRexL.printStackTrace(ex);
        }
        if (JRexL.on) {
            JRexL.log(className, "**** toString string<" + string + "> ****");
        }
        return string;
    }

    private native Node GetAnchorNode(int var1) throws JRexException;

    private native int GetAnchorOffset(int var1) throws JRexException;

    private native Node GetFocusNode(int var1) throws JRexException;

    private native int GetFocusOffset(int var1) throws JRexException;

    private native boolean GetIsCollapsed(int var1) throws JRexException;

    private native int GetRangeCount(int var1) throws JRexException;

    private native Range GetRangeAt(int var1, int var2) throws JRexException;

    private native void Collapse(int var1, Node var2, int var3) throws JRexException;

    private native void Extend(int var1, Node var2, int var3) throws JRexException;

    private native void CollapseToStart(int var1) throws JRexException;

    private native void CollapseToEnd(int var1) throws JRexException;

    private native boolean ContainsNode(int var1, Node var2, boolean var3) throws JRexException;

    private native void SelectAllChildren(int var1, Node var2) throws JRexException;

    private native void AddRange(int var1, Range var2) throws JRexException;

    private native void RemoveRange(int var1, Range var2) throws JRexException;

    private native void RemoveAllRanges(int var1) throws JRexException;

    private native void DeleteFromDocument(int var1) throws JRexException;

    private native void SelectionLanguageChange(int var1, boolean var2) throws JRexException;

    private native String ToString(int var1) throws JRexException;
}

